/*
 * Decompiled with CFR 0.152.
 */
package satDomain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import satDomain.AffineEntry;
import satDomain.Flag;
import satDomain.HashedSubstitution;
import satDomain.NumDomain;
import satDomain.Renamer;
import satDomain.SatDomain;
import satDomain.Substitution;

public class AffineSatDomain
extends NumDomain<AffineSatDomain> {
    public SatDomain sd;
    final int innerTrueVar;
    Map<Integer, Set<AffineEntry>> partitions;
    Map<Integer, AffineEntry> translation;

    private static boolean interSectionNotEmpty(Set<AffineEntry> value, Collection<Integer> fromSet) {
        HashSet<AffineEntry> s = new HashSet<AffineEntry>(value);
        s.removeAll(fromSet);
        assert (false);
        return !s.isEmpty();
    }

    private static String printPartition(int inner, Set<AffineEntry> s) {
        String txt = null;
        for (AffineEntry e : s) {
            txt = txt == null ? inner + ": " : txt + " = ";
            if (!e.polarity) {
                txt = txt + "!";
            }
            txt = txt + e.outerVar;
        }
        return txt + "\n";
    }

    AffineSatDomain() {
        this.translation = new HashMap<Integer, AffineEntry>();
        this.partitions = new HashMap<Integer, Set<AffineEntry>>();
        this.sd = new SatDomain();
        this.innerTrueVar = this.sd.freshTrueVar();
    }

    AffineSatDomain(AffineSatDomain other) {
        super(other);
        ArrayList<AffineEntry> v = new ArrayList<AffineEntry>();
        for (AffineEntry e : other.translation.values()) {
            v.add(new AffineEntry(e));
        }
        this.setPartitions(v);
        this.sd = other.sd.copy();
        this.innerTrueVar = other.innerTrueVar;
    }

    @Override
    public void assumeClause(int[] clause) {
        int[] is = new int[clause.length];
        int length = 0;
        for (int i = 0; i < is.length; ++i) {
            is[i] = this.innerVar(clause[i]);
            assert (is[i] != 0);
            if (is[i] == this.innerTrueVar) {
                return;
            }
            if (is[i] == -this.innerTrueVar) continue;
            ++length;
        }
        int j = 0;
        int[] cl = new int[length];
        for (int curr : is) {
            if (curr == -this.innerTrueVar) continue;
            cl[j++] = curr;
        }
        if (length == 1) {
            this.mergePartitions(this.innerTrueVar, cl[0]);
        } else {
            this.sd.assumeClause(cl);
        }
    }

    @Override
    public void assumeEquality(int v1, int v2) {
        this.assertProperContents();
        this.mergePartitions(this.innerVar(v1), this.innerVar(v2));
    }

    @Override
    public void assumeTrue(int v) {
        assert (v != 0);
        this.mergePartitions(this.innerTrueVar, this.innerVar(v));
    }

    @Override
    public void assumeTwoBitSum(int x1f, int x0f, int y0f, int s1f, int s0f) {
        this.assumeClause(new int[]{-x1f, s1f});
        this.assumeClause(new int[]{-x0f, -y0f, s1f});
        this.assumeClause(new int[]{x1f, x0f, -s1f});
        this.assumeClause(new int[]{x1f, y0f, -s1f});
        this.assumeClause(new int[]{x1f, x0f, y0f, -s0f});
        this.assumeClause(new int[]{s0f, -x0f});
        this.assumeClause(new int[]{s0f, -y0f});
    }

    @Override
    public void assumeUnsatisfiable() {
        this.sd.assumeUnsatisfiable();
    }

    @Override
    public AffineSatDomain copy() {
        return new AffineSatDomain(this);
    }

    @Override
    public int duplicate(int f) {
        int ov = this.freshVarIndex();
        int iv = this.innerVar(f);
        this.addToPartition(ov, iv);
        return ov;
    }

    @Override
    public Substitution expand(String reason, Collection<Integer> fromSet) {
        HashSet<Integer> innerExpandees = new HashSet<Integer>();
        HashSet outerExpandees = new HashSet();
        HashSet<AffineEntry> outerEqual = new HashSet<AffineEntry>();
        HashSet<Integer> equalVars = new HashSet<Integer>();
        for (Map.Entry<Integer, Set<AffineEntry>> e : this.partitions.entrySet()) {
            Set<AffineEntry> v = e.getValue();
            boolean wholePartition = this.containsAllEntries(fromSet, v);
            if (wholePartition) {
                innerExpandees.add(e.getKey());
                outerExpandees.addAll(e.getValue());
                continue;
            }
            if (!AffineSatDomain.interSectionNotEmpty(e.getValue(), fromSet)) continue;
            equalVars.add(e.getKey());
            for (AffineEntry h : e.getValue()) {
                if (!fromSet.contains(h.outerVar)) continue;
                outerEqual.add(h);
            }
        }
        Substitution innerSubst = this.sd.expand(reason, innerExpandees);
        HashedSubstitution outerSubst = new HashedSubstitution();
        for (AffineEntry e : outerExpandees) {
            int no = this.freshVarIndex();
            ((Substitution)outerSubst).put(e.outerVar, no);
            this.addToPartition(no, innerSubst.get(e.innerVar), e.polarity);
        }
        for (AffineEntry e : outerEqual) {
            int no = this.freshVarIndex();
            ((Substitution)outerSubst).put(e.outerVar, no);
            this.addToPartition(no, e.innerVar, e.polarity);
        }
        this.assertProperContents();
        return outerSubst;
    }

    @Override
    public int freshFalseVar() {
        int v = this.freshVarIndex();
        this.addToPartition(v, this.innerTrueVar, false);
        return v;
    }

    @Override
    public int freshTopVar() {
        int inner = this.sd.freshTopVar();
        int outer = this.freshVarIndex();
        this.addToPartition(outer, inner, true);
        return outer;
    }

    @Override
    public int freshTrueVar() {
        int v = this.freshVarIndex();
        this.addToPartition(v, this.innerTrueVar, true);
        return v;
    }

    public Set<AffineEntry> getPartition(int inner) {
        Set<AffineEntry> s = this.partitions.get(inner);
        if (s == null) {
            s = new HashSet<AffineEntry>();
            this.partitions.put(inner, s);
        }
        return s;
    }

    @Deprecated
    public AffineEntry getTranslation(int outer) {
        return this.translation.get(Math.abs(outer));
    }

    public boolean isSubset(AffineSatDomain other) {
        assert (this.getLastVar() == other.getLastVar());
        this.makePartitionsCompatible(other);
        boolean result = this.sd.isSubset(other.sd);
        return result;
    }

    @Override
    public boolean isUnsatisfiable() {
        return this.sd.isUnsatisfiable();
    }

    @Override
    public void joinWith(AffineSatDomain other) {
        assert (this.getLastVar() == other.getLastVar());
        this.makePartitionsCompatible(other);
        this.sd.joinWith(other.sd);
        this.findConstantValues();
    }

    public void makePartitionsCompatible(AffineSatDomain other) {
        while (this.sd.getLastVar() < other.sd.getLastVar()) {
            this.sd.freshTopVar();
        }
        while (other.sd.getLastVar() < this.sd.getLastVar()) {
            other.sd.freshTopVar();
        }
        int innerLastVar = this.sd.getLastVar();
        HashSet<AffineEntry> thisNewEntries = new HashSet<AffineEntry>();
        HashSet<AffineEntry> otherNewEntries = new HashSet<AffineEntry>();
        int[] innervars = new int[innerLastVar * (innerLastVar + 1) * 2 + 2];
        for (int ov = 1; ov <= this.getLastVar(); ++ov) {
            AffineEntry otherNewEntry;
            AffineEntry thisNewEntry;
            boolean samePolarity;
            AffineEntry thisEntry = this.getTranslation(ov);
            AffineEntry otherEntry = other.getTranslation(ov);
            boolean bl = samePolarity = thisEntry.polarity == otherEntry.polarity;
            if (thisEntry.innerVar == otherEntry.innerVar && samePolarity) {
                thisNewEntry = thisEntry;
                otherNewEntry = otherEntry;
            } else {
                int ti = thisEntry.innerVar;
                int oi = otherEntry.innerVar;
                int iv = (ti * innerLastVar + oi) * 2 + (samePolarity ? 1 : 0);
                if (innervars[iv] == 0) {
                    int inner = this.duplicateInnerVar(ti);
                    int inner2 = other.duplicateInnerVar(samePolarity ? oi : -oi);
                    assert (inner == inner2);
                    innervars[iv] = inner;
                }
                thisNewEntry = new AffineEntry(ov, innervars[iv], thisEntry.polarity);
                otherNewEntry = new AffineEntry(ov, innervars[iv], thisEntry.polarity);
            }
            thisNewEntries.add(thisNewEntry);
            otherNewEntries.add(otherNewEntry);
        }
        this.setPartitions(thisNewEntries);
        other.setPartitions(otherNewEntries);
    }

    @Override
    public void project(Renamer renamer, boolean withCompression) {
        HashSet<AffineEntry> entries = new HashSet<AffineEntry>(this.translation.values());
        this.translation.clear();
        this.partitions.clear();
        int innerCount = this.innerTrueVar;
        int outerCount = 0;
        ArrayList<Integer> innerRenamings = new ArrayList<Integer>(this.sd.getLastVar() + 1);
        for (int i = 0; i <= this.sd.getLastVar(); ++i) {
            innerRenamings.add(i, 0);
        }
        innerRenamings.set(this.innerTrueVar, this.innerTrueVar);
        for (AffineEntry e : entries) {
            int newOuter = renamer.get(e.outerVar);
            outerCount = Math.max(newOuter, outerCount);
            if (newOuter == 0) continue;
            int newInner = (Integer)innerRenamings.get(e.innerVar);
            if (newInner == 0) {
                newInner = ++innerCount;
                innerRenamings.set(e.innerVar, newInner);
            }
            this.addToPartition(newOuter, newInner, e.polarity);
        }
        this.setLastVar(outerCount);
        this.sd.project(innerRenamings, withCompression);
        this.findConstantValues();
    }

    public void setPartitions(Collection<AffineEntry> v) {
        this.translation = new HashMap<Integer, AffineEntry>();
        this.partitions = new HashMap<Integer, Set<AffineEntry>>();
        for (AffineEntry e : v) {
            this.addToPartition(e.outerVar, e.innerVar, e.polarity);
        }
    }

    public String showAffineEqualities() {
        String txt = "affine equalities(" + this.getLastVar() + ")\n";
        for (Map.Entry<Integer, Set<AffineEntry>> e : this.partitions.entrySet()) {
            txt = txt + AffineSatDomain.printPartition(e.getKey(), e.getValue());
        }
        return txt;
    }

    @Override
    public int summarize(int discr, int a, int b) {
        int ai = this.innerVar(a);
        int bi = this.innerVar(b);
        if (ai == 1 && bi == 1) {
            return this.freshTrueVar();
        }
        if (ai == -1 && bi == -1) {
            return this.freshFalseVar();
        }
        if (ai == 1 && bi == -1) {
            return this.duplicate(-discr);
        }
        if (ai == -1 && bi == 1) {
            return this.duplicate(discr);
        }
        int nf = this.freshTopVar();
        this.assumeClause(new int[]{discr, -nf, b});
        this.assumeClause(new int[]{discr, nf, -b});
        this.assumeClause(new int[]{-discr, -nf, a});
        this.assumeClause(new int[]{-discr, nf, -a});
        return nf;
    }

    @Override
    public String toDetailedString() {
        return this.sd.toDetailedString();
    }

    public String toString() {
        return this.sd.toString() + this.showAffineEqualities();
    }

    void addEquality(Flag v1, Flag v2) {
        this.assumeEquality(v1.flag, v2.flag);
    }

    void assertProperContents() {
        for (Map.Entry<Integer, AffineEntry> entry : this.translation.entrySet()) {
            assert (entry.getKey() == entry.getValue().outerVar);
        }
        for (Map.Entry<Integer, Object> entry : this.partitions.entrySet()) {
            Set s = (Set)entry.getValue();
            for (AffineEntry ae : s) {
                assert (entry.getKey() == ae.innerVar);
                if (this.translation.get((Object)Integer.valueOf((int)ae.outerVar)).innerVar != entry.getKey()) assert (false);
            }
        }
    }

    boolean containsAllEntries(Collection<Integer> set, Set<AffineEntry> entries) {
        for (AffineEntry e : entries) {
            if (set.contains(e.outerVar)) continue;
            return false;
        }
        return true;
    }

    @Override
    String showFlag(int v) {
        int iv = this.innerVar(v);
        if (iv == 1) {
            return "1";
        }
        if (iv == -1) {
            return "0";
        }
        return this.sd.showFlag(iv);
    }

    private void addToPartition(int outer, int inner) {
        this.addToPartition(outer, inner > 0 ? inner : -inner, inner > 0);
    }

    private void addToPartition(int outer, int inner, boolean polarity) {
        assert (inner > 0);
        AffineEntry e = new AffineEntry(outer, inner, polarity);
        assert (e != null);
        Set<AffineEntry> p = this.getPartition(e.innerVar);
        p.add(e);
        this.translation.put(e.outerVar, e);
    }

    private int duplicateInnerVar(int v) {
        if (v == this.innerTrueVar) {
            return this.sd.freshTrueVar();
        }
        if (v == -this.innerTrueVar) {
            return this.sd.freshFalseVar();
        }
        return this.sd.duplicate(v);
    }

    private void findConstantValues() {
        List<Integer> consts = this.sd.findConstants();
        if (consts.size() < 2) {
            return;
        }
        for (int c : consts) {
            this.mergePartitions(this.innerTrueVar, c);
        }
    }

    private int innerVar(int v) {
        assert (v != 0);
        AffineEntry h = this.getTranslation(v);
        return v < 0 == h.polarity ? -h.innerVar : h.innerVar;
    }

    private void mergePartitions(int i, int j) {
        this.sd.mergeVars(i, j);
        if (i == j || i == -j) {
            return;
        }
        int i1 = Math.abs(i);
        int i2 = Math.abs(j);
        this.assertProperContents();
        Set<AffineEntry> s2 = this.getPartition(i2);
        Set<AffineEntry> s1 = this.getPartition(i1);
        for (AffineEntry e : s2) {
            e.innerVar = i1;
            e.polarity = e.polarity == (j > 0 == i > 0);
            s1.add(e);
        }
        this.partitions.remove(i2);
        this.assertProperContents();
    }

    public void rename(Map<Integer, Integer> renamer) {
        if (renamer.size() == 0) {
            return;
        }
        assert (false);
    }

    public void assumeClauses(List<int[]> clauses) {
        for (int[] c : clauses) {
            this.assumeClause(c);
        }
    }
}

