/*
 * Decompiled with CFR 0.152.
 */
package rreil.tester.gdb.responses;

import rreil.tester.gdb.GdbTools;
import rreil.tester.gdb.responses.GdbResponseType;
import rreil.tester.gdb.responses.IGdbResponse;

public class GdbRegistersResponse
implements IGdbResponse {
    private final int[] generalPurposeRegisters = new int[32];
    private final int sreg;
    private final int sp;
    private final int pc;

    public int[] getGeneralPurposeRegisters() {
        return this.generalPurposeRegisters;
    }

    public int getSreg() {
        return this.sreg;
    }

    public int getSp() {
        return this.sp;
    }

    public int getPc() {
        return this.pc;
    }

    public GdbRegistersResponse(String data) {
        for (int i = 0; i < this.generalPurposeRegisters.length; ++i) {
            this.generalPurposeRegisters[i] = Integer.parseInt(data.substring(2 * i, 2 * i + 2), 16);
        }
        this.sreg = Integer.parseInt(data.substring(64, 66), 16);
        this.sp = Integer.parseInt(data.substring(66, 70), 16);
        this.pc = Integer.parseInt(GdbTools.changeStringEndianess(data.substring(70, 74)), 16);
    }

    @Override
    public GdbResponseType getType() {
        return GdbResponseType.Registers;
    }
}

