/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javalx.exceptions.UnimplementedException;
import javalx.fn.Fn;
import javalx.mutablecollections.CollectionHelpers;
import rreil.lang.Lhs;
import rreil.lang.RReil;
import rreil.lang.Rhs;
import rreil.lang.util.RReilVisitor;
import rreil.lang.util.RhsVisitor;

public class RvarExtractor {
    private static LhsExtractor lhsExtract = new LhsExtractor();
    private static RhsExtractor rhsExtract = new RhsExtractor();

    public static List<Rhs.Rvar> fromSimpleExpression(Rhs.SimpleExpression s) {
        Collector collector = new Collector();
        s.accept(collector, null);
        return collector.variables;
    }

    private static List<Rhs.Rvar> singleton(Rhs.Rvar variable) {
        return Collections.singletonList(variable);
    }

    private static List<Rhs.Rvar> none() {
        return Collections.emptyList();
    }

    public static List<Rhs.Rvar> fromRval(Rhs.Rval variable) {
        if (variable instanceof Rhs.Rvar) {
            return RvarExtractor.singleton((Rhs.Rvar)variable);
        }
        return RvarExtractor.none();
    }

    public static List<Rhs.Rvar> fromRhs(Rhs rhs) {
        Collector collector = new Collector();
        rhs.accept(collector, null);
        return new ArrayList<Rhs.Rvar>(collector.variables);
    }

    public static List<Rhs.Rvar> getAll(RReil insn) {
        Collector collector = new Collector();
        insn.accept(collector, null);
        return collector.variables;
    }

    public static Set<Rhs.Rvar> getUnique(RReil insn) {
        Collector collector = new Collector();
        insn.accept(collector, null);
        return RvarExtractor.unique(collector.variables);
    }

    public static Set<Rhs.Rvar> unique(List<Rhs.Rvar> variables) {
        LinkedHashSet<Rhs.Rvar> uniqueVariables = new LinkedHashSet<Rhs.Rvar>();
        for (Rhs.Rvar rvar : variables) {
            uniqueVariables.add(rvar);
        }
        return uniqueVariables;
    }

    public static List<Rhs.Rvar> getLhs(RReil insn) {
        return insn.accept(lhsExtract, null);
    }

    public static List<Rhs.Rvar> getRhs(RReil insn) {
        return insn.accept(rhsExtract, null);
    }

    private static class Collector
    implements RReilVisitor<Void, Void>,
    RhsVisitor<Void, Void> {
        public final List<Rhs.Rvar> variables = new LinkedList<Rhs.Rvar>();

        @Override
        public Void visit(Rhs.Bin expr, Void _) {
            expr.getLeft().accept(this, _);
            expr.getRight().accept(this, _);
            return null;
        }

        @Override
        public Void visit(Rhs.LinBin expr, Void _) {
            expr.getLeft().accept(this, _);
            expr.getRight().accept(this, _);
            return null;
        }

        @Override
        public Void visit(Rhs.LinScale expr, Void _) {
            expr.getOpnd().accept(this, _);
            return null;
        }

        @Override
        public Void visit(Rhs.LinRval expr, Void _) {
            expr.getRval().accept(this, _);
            return null;
        }

        @Override
        public Void visit(Rhs.Cmp expr, Void _) {
            expr.getLeft().accept(this, _);
            expr.getRight().accept(this, _);
            return null;
        }

        @Override
        public Void visit(Rhs.SignExtend expr, Void _) {
            expr.getRhs().accept(this, _);
            return null;
        }

        @Override
        public Void visit(Rhs.Convert expr, Void _) {
            expr.getRhs().accept(this, _);
            return null;
        }

        @Override
        public Void visit(Rhs.Rvar expr, Void _) {
            this.variables.add(expr);
            return null;
        }

        @Override
        public Void visit(Rhs.Rlit expr, Void _) {
            return null;
        }

        @Override
        public Void visit(Rhs.Address expr, Void data) {
            return null;
        }

        @Override
        public Void visit(Rhs.RangeRhs expr, Void _) {
            return null;
        }

        @Override
        public Void visit(RReil.Assign stmt, Void _) {
            this.collect(stmt.getLhs());
            stmt.getRhs().accept(this, _);
            return null;
        }

        @Override
        public Void visit(RReil.Load stmt, Void _) {
            this.collect(stmt.getLhs());
            stmt.getReadAddress().accept(this, _);
            return null;
        }

        @Override
        public Void visit(RReil.Store stmt, Void _) {
            stmt.getWriteAddress().accept(this, _);
            stmt.getRhs().accept(this, _);
            return null;
        }

        @Override
        public Void visit(RReil.BranchToNative stmt, Void _) {
            stmt.getCond().accept(this, _);
            stmt.getTarget().accept(this, _);
            return null;
        }

        @Override
        public Void visit(RReil.BranchToRReil stmt, Void _) {
            return null;
        }

        @Override
        public Void visit(RReil.Branch stmt, Void _) {
            stmt.getTarget().accept(this, _);
            return null;
        }

        @Override
        public Void visit(RReil.Nop stmt, Void _) {
            return null;
        }

        @Override
        public Void visit(RReil.Assertion stmt, Void _) {
            if (stmt instanceof RReil.Assertion.AssertionCompare) {
                RReil.Assertion.AssertionCompare assertion = (RReil.Assertion.AssertionCompare)stmt;
                assertion.getLhs().accept(this, _);
                assertion.getRhs().accept(this, _);
            }
            return null;
        }

        @Override
        public Void visit(RReil.PrimOp stmt, Void _) {
            for (Lhs lhs : stmt.getOutArgs()) {
                this.collect(lhs);
            }
            for (Rhs.Rval rhs : stmt.getInArgs()) {
                if (!(rhs instanceof Rhs.Rvar)) continue;
                this.variables.add((Rhs.Rvar)rhs);
            }
            return null;
        }

        @Override
        public Void visit(RReil.Native stmt, Void _) {
            return null;
        }

        private void collect(Lhs lhs) {
            this.variables.add(lhs.asRvar());
        }

        @Override
        public Void visit(RReil.Throw stmt, Void data) {
            throw new UnimplementedException();
        }

        @Override
        public Void visit(RReil.Flop stmt, Void data) {
            throw new UnimplementedException();
        }
    }

    private static class RhsExtractor
    implements RReilVisitor<List<Rhs.Rvar>, Void> {
        private RhsExtractor() {
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Assign stmt, Void data) {
            return RvarExtractor.fromRhs(stmt.getRhs());
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Load stmt, Void data) {
            return RvarExtractor.fromSimpleExpression(stmt.getReadAddress());
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Store stmt, Void data) {
            ArrayList<Rhs.Rvar> result = new ArrayList<Rhs.Rvar>();
            result.addAll(RvarExtractor.fromSimpleExpression(stmt.getWriteAddress()));
            result.addAll(RvarExtractor.fromRhs(stmt.getRhs()));
            return result;
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.BranchToNative stmt, Void data) {
            ArrayList<Rhs.Rvar> result = new ArrayList<Rhs.Rvar>();
            result.addAll(RvarExtractor.fromSimpleExpression(stmt.getCond()));
            result.addAll(RvarExtractor.fromSimpleExpression(stmt.getTarget()));
            return result;
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.BranchToRReil stmt, Void data) {
            return RvarExtractor.fromSimpleExpression(stmt.getCond());
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Nop stmt, Void data) {
            return RvarExtractor.none();
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Assertion stmt, Void data) {
            if (stmt instanceof RReil.Assertion.AssertionCompare) {
                RReil.Assertion.AssertionCompare assertion = (RReil.Assertion.AssertionCompare)stmt;
                return RvarExtractor.fromRhs(assertion.getRhs());
            }
            return RvarExtractor.none();
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Branch stmt, Void data) {
            return RvarExtractor.fromSimpleExpression(stmt.getTarget());
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.PrimOp stmt, Void data) {
            ArrayList<Rhs.Rvar> result = new ArrayList<Rhs.Rvar>();
            for (Rhs.Rval variable : stmt.getInArgs()) {
                if (!(variable instanceof Rhs.Rvar)) continue;
                result.add((Rhs.Rvar)variable);
            }
            return result;
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Native stmt, Void data) {
            return RvarExtractor.none();
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Throw stmt, Void data) {
            return RvarExtractor.none();
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Flop stmt, Void data) {
            return stmt.getRhs();
        }
    }

    private static class LhsExtractor
    implements RReilVisitor<List<Rhs.Rvar>, Void> {
        LhsExtractor() {
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Assign stmt, Void data) {
            return RvarExtractor.singleton(stmt.getLhs().asRvar());
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Load stmt, Void data) {
            return RvarExtractor.singleton(stmt.getLhs().asRvar());
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Store stmt, Void data) {
            return RvarExtractor.none();
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.BranchToNative stmt, Void data) {
            return RvarExtractor.none();
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.BranchToRReil stmt, Void data) {
            return RvarExtractor.none();
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Nop stmt, Void data) {
            return RvarExtractor.none();
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Assertion stmt, Void data) {
            if (stmt instanceof RReil.Assertion.AssertionCompare) {
                RReil.Assertion.AssertionCompare assertion = (RReil.Assertion.AssertionCompare)stmt;
                return RvarExtractor.fromRhs(assertion.getLhs());
            }
            return RvarExtractor.none();
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Branch stmt, Void data) {
            return RvarExtractor.none();
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.PrimOp stmt, Void data) {
            return CollectionHelpers.map(stmt.getOutArgs(), new Fn<Lhs, Rhs.Rvar>(){

                @Override
                public Rhs.Rvar apply(Lhs a) {
                    return a.asRvar();
                }
            });
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Native stmt, Void data) {
            return RvarExtractor.none();
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Throw stmt, Void data) {
            return RvarExtractor.none();
        }

        @Override
        public List<Rhs.Rvar> visit(RReil.Flop stmt, Void data) {
            return RvarExtractor.singleton(stmt.getLhs());
        }
    }
}

