/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang;

import javalx.numeric.BigInt;
import rreil.lang.AssemblerParseable;
import rreil.lang.Reconstructable;

public final class RReilAddr
implements Comparable<RReilAddr>,
AssemblerParseable,
Reconstructable {
    public static final RReilAddr ZERO = RReilAddr.valueOf(0L);
    public static final RReilAddr ONE = RReilAddr.valueOf(1L);
    private final long base;
    private final int offset;

    public RReilAddr(long base, int offset) {
        this.base = base;
        this.offset = offset;
    }

    public long base() {
        return this.base;
    }

    public int offset() {
        return this.offset;
    }

    public boolean isNative() {
        return this.offset == 0;
    }

    @Override
    public int compareTo(RReilAddr other) {
        if (this.base == other.base) {
            return this.offset == other.offset ? 0 : (this.offset < other.offset ? -1 : 1);
        }
        return this.base < other.base ? -1 : 1;
    }

    public static RReilAddr valueOf(long base, int offset) {
        return new RReilAddr(base, offset);
    }

    public static RReilAddr valueOf(long base) {
        return new RReilAddr(base, 0);
    }

    public static RReilAddr valueOf(BigInt base) {
        return new RReilAddr(base.longValue(), 0);
    }

    public static RReilAddr valueOf(String address) {
        String[] addressSplit;
        int radix = 10;
        if (address.toLowerCase().startsWith("0x")) {
            radix = 16;
            address = address.substring(2);
        }
        if ((addressSplit = address.split("\\.")).length > 2) {
            throw new IllegalArgumentException("The address string: \"" + address + "\" cannot be parsed to a RREIL address. The string must be of the form [0x][base].[offset]");
        }
        String baseString = addressSplit[0];
        String offsetString = addressSplit.length == 2 ? addressSplit[1] : "0";
        return new RReilAddr(Long.parseLong(baseString, radix), Integer.parseInt(offsetString, radix));
    }

    public RReilAddr nextBase() {
        return new RReilAddr(this.base + 1L, this.offset);
    }

    public RReilAddr nextBase(long opcodeLength) {
        return new RReilAddr(this.base + opcodeLength, 0);
    }

    public RReilAddr nextOffset() {
        return new RReilAddr(this.base, this.offset + 1);
    }

    public RReilAddr withOffset(int newOffset) {
        return new RReilAddr(this.base, newOffset);
    }

    public String toString() {
        return String.format("%08x.%02x", this.base, this.offset);
    }

    public String toShortString() {
        if (this.offset != 0) {
            return String.format("%x.%02x", this.base, this.offset);
        }
        return String.format("%x", this.base);
    }

    public String toShortStringWithHexPrefix() {
        if (this.offset != 0) {
            return String.format("0x%x.%02x", this.base, this.offset);
        }
        return String.format("0x%x", this.base);
    }

    public String toStringWithHexPrefix() {
        return String.format("0x%08x.%02x", this.base, this.offset);
    }

    @Override
    public String toAssemblerString() {
        return this.toStringWithHexPrefix() + ":";
    }

    @Override
    public String reconstructCode() {
        return "new RReilAddr(" + this.base + ", " + this.offset + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RReilAddr)) {
            return false;
        }
        RReilAddr other = (RReilAddr)obj;
        if (this.base != other.base) {
            return false;
        }
        return this.offset == other.offset;
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + (int)(this.base ^ this.base >>> 32);
        hash = 61 * hash + this.offset;
        return hash;
    }
}

