/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang;

import com.jamesmurty.utils.XMLBuilder;
import javalx.numeric.FiniteRange;
import javalx.xml.XmlPrintable;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.Rhs;

public final class Field
implements XmlPrintable {
    private final int size;
    private final int offset;
    private final MemVar region;

    public static Field field(Rhs.Rvar rhs) {
        return new Field(rhs.getSize(), rhs.offset, rhs.getRegionId());
    }

    public static Field field(Lhs lhs) {
        return new Field(lhs.getSize(), lhs.getOffset(), lhs.getRegionId());
    }

    public static FiniteRange finiteRangeKey(int offset, int size) {
        return FiniteRange.of(offset, (long)(offset + size - 1));
    }

    public Field(int size, int offset, MemVar region) {
        this.size = size;
        this.offset = offset;
        this.region = region;
    }

    public FiniteRange finiteRangeKey() {
        return Field.finiteRangeKey(this.offset, this.size);
    }

    public int getSize() {
        return this.size;
    }

    public int getOffset() {
        return this.offset;
    }

    public MemVar getRegion() {
        return this.region;
    }

    public String toString() {
        return String.format("<Field %s:%d/%d>", this.region, this.size, this.offset);
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        return builder.e("Field").a("region", this.region.toString()).a("size", String.valueOf(this.size)).a("offset", String.valueOf(this.offset)).up();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.offset;
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Field)) {
            return false;
        }
        Field other = (Field)obj;
        if (this.offset != other.offset) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        return this.size == other.size;
    }
}

