/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang;

import rreil.lang.Reconstructable;
import rreil.lang.SignednessHint;

public enum BinOp implements Reconstructable
{
    Add("add", "+"),
    Sub("sub", "-"),
    Mul("mul", "*"),
    Divu("div", "/u"),
    Divs("divs", "/s"),
    Mod("mod", "%"),
    Mods("mods", "%s"),
    Shl("shl", "<<"),
    Shr("shr", ">>u"),
    Shrs("shrs", ">>s"),
    Xor("xor", "xor"),
    Or("or", "or"),
    And("and", "and");

    private final String asInfix;
    private final String asPrefix;

    private BinOp(String asPrefix, String asInfix) {
        this.asInfix = asInfix;
        this.asPrefix = asPrefix;
    }

    public String asInfix() {
        return this.asInfix;
    }

    public String asPrefix() {
        return this.asPrefix;
    }

    public SignednessHint signedness() {
        switch (this) {
            case Divs: 
            case Shrs: {
                return SignednessHint.ForceSigned;
            }
            case Divu: 
            case Shr: {
                return SignednessHint.ForceUnsigned;
            }
        }
        return SignednessHint.DontCare;
    }

    @Override
    public String reconstructCode() {
        return "BinOp." + this.toString();
    }
}

