/*
 * Decompiled with CFR 0.152.
 */
package rreil.interpreter;

import java.util.HashMap;
import java.util.Map;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import rreil.interpreter.RReilMachineException;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.Rhs;

public class RegisterModel {
    protected final Map<MemVar, BigInt> registers = new HashMap<MemVar, BigInt>();
    protected final int baseSize;

    public RegisterModel(int baseSize) {
        this.baseSize = baseSize;
    }

    public BigInt get(Rhs.Rvar variable) {
        return this.fetch(variable.getRegionId(), variable.getSize(), variable.getOffset());
    }

    public BigInt getSigned(Rhs.Rvar variable) {
        return this.fetchSigned(variable.getRegionId(), variable.getSize());
    }

    public BigInt get(Rhs.Rlit literal) {
        return this.getUnsigned(literal);
    }

    public BigInt getUnsigned(Rhs.Rlit literal) {
        return this.wrap(literal.getValue(), literal.getSize());
    }

    public BigInt getSigned(Rhs.Rlit literal) {
        return this.fetchSigned(literal.getValue(), literal.getSize());
    }

    public BigInt get(Rhs.RangeRhs range) {
        throw new RReilMachineException("Range values not allowed");
    }

    public BigInt getSigned(Rhs.RangeRhs range) {
        throw new RReilMachineException("Range values not allowed");
    }

    public void set(Rhs.Rvar lhs, BigInt unmaskedValue) {
        this.set(lhs.asLhs(), unmaskedValue);
    }

    public void set(Lhs lhs, BigInt unmaskedValue) {
        int offset = lhs.getOffset();
        assert (this.baseSize >= lhs.getSize() + offset) : "Invalid effective register access size (size + offset > baseSize)";
        BigInt baseValue = this.fetchFromPossiblyUndefined(lhs.getRegionId(), this.baseSize, Bound.ZERO);
        BigInt value = this.wrap(unmaskedValue, lhs.getSize());
        int lowerSz = lhs.getSize() + offset;
        int upperSz = this.baseSize - lowerSz;
        BigInt lower = baseValue.and(this.sizeMask(offset));
        BigInt upper = baseValue.and(this.sizeMask(upperSz).shl(lowerSz));
        BigInt effectiveValue = upper.or(lower.or(value.shl(offset)));
        this.registers.put(lhs.getRegionId(), effectiveValue);
    }

    protected BigInt fetchSigned(MemVar name, int size) {
        return this.fetchSigned(this.registers.get(name), size);
    }

    protected BigInt fetchSigned(BigInt unmaskedValue, int size) {
        BigInt msbMask;
        BigInt value = this.wrap(unmaskedValue, size);
        BigInt msb = value.and(msbMask = BigInt.powerOfTwo(size - 1));
        if (msb.isEqualTo(msbMask)) {
            return value.not().and(msbMask.sub(Bound.ONE)).add(Bound.ONE).negate();
        }
        return value;
    }

    protected BigInt fetch(MemVar name, int size, int offset) {
        return this.wrap(this.registers.get(name).shr(offset), size);
    }

    protected BigInt fetchFromPossiblyUndefined(MemVar name, int size, BigInt undefinedValue) {
        if (!this.registers.containsKey(name)) {
            return this.wrap(undefinedValue, size);
        }
        return this.wrap(this.registers.get(name), size);
    }

    protected BigInt wrap(BigInt value, int size) {
        return value.and(this.sizeMask(size));
    }

    protected BigInt sizeMask(int size) {
        return BigInt.powerOfTwo(size).sub(Bound.ONE);
    }
}

