/*
 * Decompiled with CFR 0.152.
 */
package rreil.interpreter;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import rreil.interpreter.RReilMachineException;

public final class MemoryModel {
    private static final BigInt MASK64 = BigInt.powerOfTwo(64).sub(Bound.ONE);
    public static final long DEFAULT_BASE_ADDRESS = 65535L;
    public static final int DEFAULT_SIZE = 100;
    private final ByteBuffer data;
    private final long baseAddress;

    public MemoryModel(byte[] segment, long baseAddress, ByteOrder ord) {
        this.data = ByteBuffer.wrap(segment);
        this.baseAddress = baseAddress;
        this.data.order(ord);
    }

    public MemoryModel(ByteOrder ord) {
        this(new byte[100], 65535L, ord);
    }

    public BigInt load(int size, long address) {
        switch (size) {
            case 8: {
                int value = this.data.get((int)(address - this.baseAddress)) & 0xFF;
                return BigInt.of(value);
            }
            case 16: {
                int value = this.data.getShort((int)(address - this.baseAddress)) & 0xFFFF;
                return BigInt.of(value);
            }
            case 32: {
                long value = (long)this.data.getInt((int)(address - this.baseAddress)) & 0xFFFFFFFFL;
                return BigInt.of(value);
            }
            case 64: {
                long value = this.data.getLong((int)(address - this.baseAddress));
                return BigInt.of(value).and(MASK64);
            }
        }
        throw new RReilMachineException("Invalid memory access size :" + size);
    }

    public void store(int size, long address, BigInt value) {
        switch (size) {
            case 8: {
                this.data.put((int)(address - this.baseAddress), value.getValue().byteValue());
                break;
            }
            case 16: {
                this.data.putShort((int)(address - this.baseAddress), value.getValue().shortValue());
                break;
            }
            case 32: {
                this.data.putInt((int)(address - this.baseAddress), value.intValue());
                break;
            }
            case 64: {
                this.data.putLong((int)(address - this.baseAddress), value.longValue());
                break;
            }
            default: {
                throw new RReilMachineException("Invalid memory access size :" + size);
            }
        }
    }
}

