/*
 * Decompiled with CFR 0.152.
 */
package rreil.gdsl.exp_builder.linear;

import java.util.SortedMap;
import rreil.gdsl.BuildingStateManager;
import rreil.gdsl.builder.BuildResult;
import rreil.gdsl.exp_builder.linear.LinearBuilder;
import rreil.lang.LinBinOp;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.util.RhsFactory;

public class BinopBuilder
extends LinearBuilder {
    private LinearBuilder lhs;
    private LinearBuilder rhs;
    private LinBinOp op;

    public BinopBuilder(BuildingStateManager manager, LinBinOp op, LinearBuilder lhs, LinearBuilder rhs) {
        super(manager);
        this.op = op;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public LinearBuilder size(int size) {
        this.lhs.size(size);
        this.rhs.size(size);
        return this;
    }

    @Override
    public BuildResult<? extends Rhs> build() {
        BuildResult<? extends Rhs.Rval> lhsR = this.lhs.buildRval();
        BuildResult<? extends Rhs.Rval> rhsR = this.rhs.buildRval();
        SortedMap<RReilAddr, RReil> stmts = lhsR.before(rhsR);
        return BinopBuilder.result(RhsFactory.getInstance().binary(lhsR.getResult(), this.op, rhsR.getResult()), stmts);
    }

    @Override
    public int getSize() {
        return this.lhs.getSize();
    }
}

