/*
 * Decompiled with CFR 0.152.
 */
package rreil.gdsl.builder.statement;

import java.util.SortedMap;
import rreil.gdsl.BuildingStateManager;
import rreil.gdsl.builder.AddressBuilder;
import rreil.gdsl.builder.BuildResult;
import rreil.gdsl.builder.Builder;
import rreil.gdsl.builder.sexpr.SexprBuilder;
import rreil.gdsl.builder.statement.StatementBuilder;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.util.RReilFactory;

public class ConditionalBranchBuilder
extends StatementBuilder {
    private SexprBuilder condition;
    private AddressBuilder target_true;
    private AddressBuilder target_false;

    public ConditionalBranchBuilder(BuildingStateManager manager, SexprBuilder condition, AddressBuilder target_true, AddressBuilder target_false) {
        super(manager);
        this.condition = condition.size(1);
        this.target_true = target_true;
        this.target_false = target_false;
    }

    @Override
    public BuildResult<? extends RReil> build() {
        BuildResult<? extends Rhs.SimpleExpression> condSe = this.condition.build();
        BuildResult<? extends Rhs.Lin> targetTrueSe = this.target_true.build();
        BuildResult<? extends Rhs.Lin> targetFalseSe = this.target_false.build();
        SortedMap<RReilAddr, RReil> stmts = BuildResult.emptyStatements();
        RReil.BranchToNative cbranch = RReilFactory.instance.branchNative(this.manager.nextAddress(), condSe.getResult(), targetTrueSe.getResult());
        stmts.put(cbranch.getRReilAddress(), cbranch);
        return ConditionalBranchBuilder.result(RReilFactory.instance.branchNative(this.manager.nextAddress(), targetFalseSe.getResult(), RReil.Branch.BranchTypeHint.Jump), stmts);
    }

    @Override
    public Builder<RReil> size(int size) {
        return this;
    }

    @Override
    public int getSize() {
        throw new RuntimeException("No size field");
    }
}

