/*
 * Decompiled with CFR 0.152.
 */
package rreil.gdsl;

import rreil.lang.MemVar;
import rreil.lang.RReilAddr;

public class BuildingStateManager {
    private RReilAddr currentInstructionAddress;
    private boolean staged = false;
    private int nextTemp = 0;

    public BuildingStateManager(RReilAddr start) {
        this.currentInstructionAddress = start;
    }

    public BuildingStateManager() {
        this.currentInstructionAddress = RReilAddr.ZERO;
    }

    public RReilAddr nextAddress() {
        RReilAddr result = this.currentInstructionAddress;
        this.currentInstructionAddress = this.currentInstructionAddress.nextOffset();
        this.staged = false;
        return result;
    }

    public RReilAddr stageAddress() {
        this.staged = true;
        return this.currentInstructionAddress;
    }

    public boolean hasStagedAddress() {
        return this.staged;
    }

    public MemVar nextTemporary() {
        MemVar var = MemVar.getVarOrFresh("tt" + this.nextTemp++);
        return var;
    }
}

