/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.InsnEmitter;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.disassembler.translators.x86.common.X86OperandTranslator;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;
import rreil.lang.lowlevel.TranslationHelpers;

public class X86RmRegBitmodTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private final InsnEmitter emitter;

    public X86RmRegBitmodTranslator(InsnEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        List<OperandTree> operands = instruction.operands();
        OperandTree targetOperand = operands.get(0);
        OperandTree sourceOperand = operands.get(1);
        TranslationState opnd1 = X86OperandTranslator.translateOperand(env, targetOperand);
        TranslationState opnd2 = X86OperandTranslator.translateOperand(env, sourceOperand);
        instructions.addAll(opnd1.getInstructionStack());
        instructions.addAll(opnd2.getInstructionStack());
        LowLevelRReilOpnd src1 = opnd1.getOperandStack().pop();
        LowLevelRReilOpnd src2 = opnd2.getOperandStack().pop();
        LowLevelRReilOpnd dst = registerTranslator.temporaryRegister(env, src1.size());
        this.emitter.emit(env, dst, src1, src2, instructions);
        if (opnd1.getOperandStack().size() >= 1) {
            LowLevelRReilOpnd addr = opnd1.getOperandStack().pop();
            instructions.add(factory.STORE(env.getNextReilAddress(), addr, dst));
        } else {
            instructions.add(factory.MOV(env.getNextReilAddress(), src1, dst));
        }
    }

    public static class BtsEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd r, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, List<LowLevelRReil> instructions) {
            RegisterTranslator registerTranslator = env.getRegisterTranslator();
            LowLevelRReilOpnd i = registerTranslator.temporaryRegister(env, src2.size());
            LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, src1.size());
            LowLevelRReilOpnd m = registerTranslator.temporaryRegister(env, t.size());
            instructions.addAll(Arrays.asList(factory.AND(env.getNextReilAddress(), i, src2, TranslationHelpers.getMaxImmediate(src2.size())), factory.SHRU(env.getNextReilAddress(), t, src1, i), factory.MOV(env.getNextReilAddress(), X86Helpers.BELOW_FLAG_OPERAND, t.withSize(OperandSize.BIT)), factory.SHL(env.getNextReilAddress(), m, factory.immediate(m.size(), (Number)1), i), factory.OR(env.getNextReilAddress(), r, src1, m), factory.UNDEF(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND)));
        }
    }

    public static class BtrEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd r, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, List<LowLevelRReil> instructions) {
            RegisterTranslator registerTranslator = env.getRegisterTranslator();
            LowLevelRReilOpnd i = registerTranslator.temporaryRegister(env, src2.size());
            LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, src1.size());
            LowLevelRReilOpnd m1 = registerTranslator.temporaryRegister(env, t.size());
            LowLevelRReilOpnd m2 = registerTranslator.temporaryRegister(env, t.size());
            instructions.addAll(Arrays.asList(factory.AND(env.getNextReilAddress(), i, src2, TranslationHelpers.getMaxImmediate(src2.size())), factory.SHRU(env.getNextReilAddress(), t, src1, i), factory.MOV(env.getNextReilAddress(), X86Helpers.BELOW_FLAG_OPERAND, t.withSize(OperandSize.BIT)), factory.SHL(env.getNextReilAddress(), m1, factory.immediate(m1.size(), (Number)1), i), factory.XOR(env.getNextReilAddress(), m2, m1, TranslationHelpers.getMaxImmediate(m1.size())), factory.AND(env.getNextReilAddress(), r, src1, m2), factory.UNDEF(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND)));
        }
    }

    public static class BtcEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd r, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, List<LowLevelRReil> instructions) {
            RegisterTranslator registerTranslator = env.getRegisterTranslator();
            LowLevelRReilOpnd i = registerTranslator.temporaryRegister(env, src2.size());
            LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, src1.size());
            LowLevelRReilOpnd m = registerTranslator.temporaryRegister(env, t.size());
            instructions.addAll(Arrays.asList(factory.AND(env.getNextReilAddress(), i, src2, TranslationHelpers.getMaxImmediate(src2.size())), factory.SHRU(env.getNextReilAddress(), t, src1, i), factory.MOV(env.getNextReilAddress(), X86Helpers.BELOW_FLAG_OPERAND, t.withSize(OperandSize.BIT)), factory.SHL(env.getNextReilAddress(), m, factory.immediate(m.size(), (Number)1), i), factory.XOR(env.getNextReilAddress(), r, src1, m), factory.UNDEF(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND)));
        }
    }
}

