/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.InsnEmitter;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.disassembler.translators.x86.common.X86OperandTranslator;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public class X86RegRmTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private final InsnEmitter emitter;

    public X86RegRmTranslator(InsnEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        List<OperandTree> operands = instruction.operands();
        OperandTree targetOperand = operands.get(0);
        OperandTree sourceOperand = operands.get(1);
        TranslationState opnd1 = X86OperandTranslator.translateOperand(env, targetOperand);
        TranslationState opnd2 = X86OperandTranslator.translateOperand(env, sourceOperand);
        instructions.addAll(opnd1.getInstructionStack());
        instructions.addAll(opnd2.getInstructionStack());
        assert (opnd1.getOperandStack().size() == 1) : "Destination operand must be a register";
        LowLevelRReilOpnd dst = opnd1.getOperandStack().pop();
        LowLevelRReilOpnd src = opnd2.getOperandStack().pop();
        LowLevelRReilOpnd tmp = registerTranslator.temporaryRegister(env, dst.size());
        this.emitter.emit(env, tmp, src, null, instructions);
        X86Helpers.emitWritebackAndMaybeZeroExtend(env, dst, tmp, instructions);
    }

    public static class BsrEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd tmp, LowLevelRReilOpnd src1, LowLevelRReilOpnd _null, List<LowLevelRReil> instructions) {
            RegisterTranslator registerTranslator = env.getRegisterTranslator();
            LowLevelRReilOpnd zero = factory.immediate(src1.size(), (Number)0);
            LowLevelRReilOpnd one = factory.immediate(OperandSize.BIT, (Number)1);
            LowLevelRReilOpnd srcNonZero = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd src = registerTranslator.temporaryRegister(env, src1.size());
            LowLevelRReilOpnd bitIsSet = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            long base = env.getBaseAddress();
            long reilBase = env.getCurrentReilOffset();
            long loopInit = reilBase + 5L;
            long loopBody = loopInit + 3L;
            long done = loopBody + 5L;
            instructions.addAll(Arrays.asList(factory.CMPLTU(env.getNextReilAddress(), srcNonZero, zero, src1), factory.IFGOTORREIL(env.getNextReilAddress(), srcNonZero, base, loopInit), factory.UNDEF(env.getNextReilAddress(), tmp), factory.MOV(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND, one), factory.GOTORREIL(env.getNextReilAddress(), base, done), factory.MOV(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND, zero.withSize(OperandSize.BIT)), factory.MOV(env.getNextReilAddress(), tmp, factory.immediate(tmp.size(), (Number)(tmp.size() - 1))), factory.MOV(env.getNextReilAddress(), src, src1), factory.CMPEQ(env.getNextReilAddress(), bitIsSet, src.withOffset(src.size() - 1, OperandSize.BIT), one), factory.IFGOTORREIL(env.getNextReilAddress(), bitIsSet, base, done), factory.SUB(env.getNextReilAddress(), tmp, tmp, factory.immediate(tmp.size(), (Number)1)), factory.SHL(env.getNextReilAddress(), src, src, factory.immediate(src.size(), (Number)1)), factory.GOTORREIL(env.getNextReilAddress(), base, loopBody), factory.UNDEF(env.getNextReilAddress(), X86Helpers.AUXILIARY_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.PARITY_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND)));
        }
    }

    public static class BsfEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd tmp, LowLevelRReilOpnd src1, LowLevelRReilOpnd _null, List<LowLevelRReil> instructions) {
            RegisterTranslator registerTranslator = env.getRegisterTranslator();
            LowLevelRReilOpnd zero = factory.immediate(src1.size(), (Number)0);
            LowLevelRReilOpnd one = factory.immediate(OperandSize.BIT, (Number)1);
            LowLevelRReilOpnd srcNonZero = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd src = registerTranslator.temporaryRegister(env, src1.size());
            LowLevelRReilOpnd bitIsSet = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            long base = env.getBaseAddress();
            long reilBase = env.getCurrentReilOffset();
            long loopInit = reilBase + 5L;
            long loopBody = loopInit + 3L;
            long done = loopBody + 5L;
            instructions.addAll(Arrays.asList(factory.CMPLTU(env.getNextReilAddress(), srcNonZero, zero, src1), factory.IFGOTORREIL(env.getNextReilAddress(), srcNonZero, base, loopInit), factory.UNDEF(env.getNextReilAddress(), tmp), factory.MOV(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND, one), factory.GOTORREIL(env.getNextReilAddress(), base, done), factory.MOV(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND, zero.withSize(OperandSize.BIT)), factory.MOV(env.getNextReilAddress(), tmp, zero), factory.MOV(env.getNextReilAddress(), src, src1), factory.CMPEQ(env.getNextReilAddress(), bitIsSet, src.withSize(OperandSize.BIT), one), factory.IFGOTORREIL(env.getNextReilAddress(), bitIsSet, base, done), factory.ADD(env.getNextReilAddress(), tmp, tmp, factory.immediate(tmp.size(), (Number)1)), factory.SHRU(env.getNextReilAddress(), src, src, factory.immediate(src.size(), (Number)1)), factory.GOTORREIL(env.getNextReilAddress(), base, loopBody), factory.UNDEF(env.getNextReilAddress(), X86Helpers.AUXILIARY_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.PARITY_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND)));
        }
    }

    public static class MovzxEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, List<LowLevelRReil> instructions) {
            instructions.add(factory.CONVERT(env.getNextReilAddress(), dst, src1));
        }
    }

    public static class MovsxEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, List<LowLevelRReil> instructions) {
            instructions.add(factory.SIGNEXTEND(env.getNextReilAddress(), dst, src1));
        }
    }
}

