/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Stack;
import rreil.disassembler.OperandPostorderIterator;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;

public final class X86OperandTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();

    public static TranslationState translateOperand(TranslationCtx env, OperandTree opnd) {
        return X86OperandTranslator.translateOperand(env, opnd, true);
    }

    public static TranslationState translateOperand(TranslationCtx env, OperandTree opnd, boolean load) {
        OperandPostorderIterator it = new OperandPostorderIterator(opnd.getRoot());
        TranslationState state = new TranslationState();
        block7: while (it.next()) {
            OperandTree.Node t = it.current();
            switch (t.getType()) {
                case Sym: {
                    X86OperandTranslator.translateRegister(env, state, it);
                    continue block7;
                }
                case Immi: {
                    X86OperandTranslator.translateImmediate(env, state, it);
                    continue block7;
                }
                case Op: {
                    X86OperandTranslator.translateOperator(env, state, it);
                    continue block7;
                }
                case Mem: {
                    if (load) {
                        X86OperandTranslator.translateMemoryDereferenceAndLoad(env, state, it);
                        continue block7;
                    }
                    X86OperandTranslator.translateMemoryDereferenceNoLoad(env, state, it);
                    continue block7;
                }
                case Size: {
                    continue block7;
                }
            }
            throw new RuntimeException("Error: Unhandled expression type during operand translation: " + (Object)((Object)t.getType()));
        }
        return state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void translateRegister(TranslationCtx env, TranslationState state, OperandPostorderIterator it) {
        OperandTree.Node t = it.current();
        LowLevelRReilOpnd reg = env.getRegisterTranslator().translateRegister((String)t.getData());
        if (it.currentSizeScope().intValue() != reg.size()) {
            if (!X86OperandTranslator.isSegment((String)t.getData())) throw new RuntimeException("Error: Register accessed with different size than expected (eg. byte eax)");
            state.getOperandStack().push(reg);
            state.getOperandStack().push(reg.withSize(it.currentSizeScope().intValue()));
            return;
        } else {
            state.getOperandStack().push(reg);
        }
    }

    private static boolean isSegment(String value) {
        return value.equals("cs") || value.equals("ds") || value.equals("es") || value.equals("fs") || value.equals("gs") || value.equals("ss");
    }

    private static void translateImmediate(TranslationCtx env, TranslationState state, OperandPostorderIterator it) {
        OperandTree.Node t = it.current();
        state.getOperandStack().push(factory.immediate(it.currentSizeScope(), (Number)t.getData()));
    }

    private static void translateOperator(TranslationCtx env, TranslationState state, OperandPostorderIterator it) {
        OperandTree.Node t = it.current();
        String operator = (String)t.getData();
        if (operator.equals("+")) {
            X86OperandTranslator.translatePlusOperator(env, state, it);
        } else if (operator.equals("*")) {
            X86OperandTranslator.translateMulOperator(env, state, it);
        } else if (operator.endsWith(":")) {
            X86OperandTranslator.translateSizePrefixOperator(env, state, it);
        } else {
            throw new RuntimeException("Encountered invalid operator during operand translation '" + operator + "'");
        }
    }

    private static void translatePlusOperator(TranslationCtx env, TranslationState state, OperandPostorderIterator it) {
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        LowLevelRReilOpnd opnd1 = state.getOperandStack().pop();
        LowLevelRReilOpnd opnd2 = state.getOperandStack().pop();
        assert (opnd1.size() == opnd2.size()) : "Invalid operand sizes";
        LowLevelRReilOpnd target = registerTranslator.temporaryRegister(env, opnd1.size());
        LowLevelRReil insn = factory.ADD(env.getNextReilAddress(), target, opnd1, opnd2);
        state.getInstructionStack().push(insn);
        state.getOperandStack().push(target);
    }

    private static void translateMulOperator(TranslationCtx env, TranslationState state, OperandPostorderIterator it) {
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        LowLevelRReilOpnd opnd1 = state.getOperandStack().pop();
        LowLevelRReilOpnd opnd2 = state.getOperandStack().pop();
        assert (opnd1.size() == opnd2.size()) : "Invalid operand sizes";
        LowLevelRReilOpnd target = registerTranslator.temporaryRegister(env, opnd1.size());
        LowLevelRReil insn = factory.MUL(env.getNextReilAddress(), target, opnd1, opnd2);
        state.getInstructionStack().push(insn);
        state.getOperandStack().push(target);
    }

    private static void translateSizePrefixOperator(TranslationCtx env, TranslationState state, OperandPostorderIterator it) {
    }

    private static void translateMemoryDereferenceAndLoad(TranslationCtx env, TranslationState state, OperandPostorderIterator it) {
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        Stack<Number> stack = it.getOperandSizeStack();
        stack.pop();
        Number derefSz = stack.pop();
        LowLevelRReilOpnd address = state.getOperandStack().peek();
        LowLevelRReilOpnd target = registerTranslator.temporaryRegister(env, derefSz);
        LowLevelRReil insn = factory.LOAD(env.getNextReilAddress(), target, address);
        state.getInstructionStack().push(insn);
        state.getOperandStack().push(target);
    }

    private static void translateMemoryDereferenceNoLoad(TranslationCtx env, TranslationState state, OperandPostorderIterator it) {
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        Stack<Number> stack = it.getOperandSizeStack();
        stack.pop();
        Number derefSz = stack.pop();
        state.getOperandStack().push(registerTranslator.temporaryRegister(env, derefSz));
    }
}

