/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public class X86Helpers {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    public static final String AUXILIARY_FLAG = "AF";
    public static final String CARRY_FLAG = "CF";
    public static final String DIRECTION_FLAG = "DF";
    public static final String INTERRUPT_FLAG = "IF";
    public static final String OVERFLOW_FLAG = "OF";
    public static final String PARITY_FLAG = "PF";
    public static final String SIGN_FLAG = "SF";
    public static final String ZERO_FLAG = "ZF";
    public static final String BELOW_OR_EQUAL_FLAG = "BE";
    public static final String LESS_FLAG = "LT";
    public static final String LESS_OR_EQUAL_FLAG = "LE";
    public static final LowLevelRReilOpnd AUXILIARY_FLAG_OPERAND = factory.flag("AF");
    public static final LowLevelRReilOpnd DIRECTION_FLAG_OPERAND = factory.flag("DF");
    public static final LowLevelRReilOpnd OVERFLOW_FLAG_OPERAND = factory.flag("OF");
    public static final LowLevelRReilOpnd SIGN_FLAG_OPERAND = factory.flag("SF");
    public static final LowLevelRReilOpnd INTERRUPT_FLAG_OPERAND = factory.flag("IF");
    public static final LowLevelRReilOpnd PARITY_FLAG_OPERAND = factory.flag("PF");
    public static final LowLevelRReilOpnd BELOW_FLAG_OPERAND = factory.flag("CF");
    public static final LowLevelRReilOpnd BELOW_OR_EQUAL_FLAG_OPERAND = factory.flag("BE");
    public static final LowLevelRReilOpnd EQUAL_FLAG_OPERAND = factory.flag("ZF");
    public static final LowLevelRReilOpnd LESS_FLAG_OPERAND = factory.flag("LT");
    public static final LowLevelRReilOpnd LESS_OR_EQUAL_FLAG_OPERAND = factory.flag("LE");

    public static void emitWritebackAndMaybeZeroExtend(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd src, List<LowLevelRReil> insns) {
        if (env.getDefaultArchitectureSize() == 64 && dst.size() == 32) {
            insns.add(factory.MOV(env.getNextReilAddress(), dst, src));
            insns.add(factory.MOV(env.getNextReilAddress(), dst.withOffset(32, OperandSize.DWORD.getBits()), factory.immediate(dst.size(), (Number)0)));
        } else {
            insns.add(factory.MOV(env.getNextReilAddress(), dst, src));
        }
    }

    public static void _POP(TranslationCtx env, LowLevelRReilOpnd dst, List<LowLevelRReil> insns) {
        LowLevelRReilOpnd esp = env.getRegisterTranslator().translateRegister("esp").withSize(env.getDefaultArchitectureSize());
        LowLevelRReilOpnd inc = factory.immediate(esp.size(), (Number)(dst.size() / 8));
        insns.addAll(Arrays.asList(factory.LOAD(env.getNextReilAddress(), dst, esp), factory.ADD(env.getNextReilAddress(), esp, esp, inc)));
    }

    public static void _PUSH(TranslationCtx env, LowLevelRReilOpnd src, List<LowLevelRReil> insns) {
        LowLevelRReilOpnd esp = env.getRegisterTranslator().translateRegister("esp").withSize(env.getDefaultArchitectureSize());
        LowLevelRReilOpnd dec = factory.immediate(esp.size(), (Number)(src.size() / 8));
        LowLevelRReilOpnd tmp = env.getRegisterTranslator().temporaryRegister(env, src.size());
        insns.addAll(Arrays.asList(factory.MOV(env.getNextReilAddress(), tmp, src), factory.SUB(env.getNextReilAddress(), esp, esp, dec), factory.STORE(env.getNextReilAddress(), esp, tmp)));
    }
}

