/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.InsnEmitter;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.disassembler.translators.x86.common.X86OperandTranslator;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;

public class PopTranslator
implements InsnTranslator {
    private final InsnEmitter emitter;
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();

    public PopTranslator(InsnEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        List<OperandTree> operands = instruction.operands();
        OperandTree operand = operands.get(0);
        TranslationState opnd = X86OperandTranslator.translateOperand(env, operand, false);
        instructions.addAll(opnd.getInstructionStack());
        if (opnd.getOperandStack().size() > 1) {
            LowLevelRReilOpnd dummy = opnd.getOperandStack().pop();
            LowLevelRReilOpnd addr = opnd.getOperandStack().pop();
            this.emitter.emit(env, dummy, null, null, instructions);
            instructions.add(factory.STORE(env.getNextReilAddress(), addr, dummy));
        } else {
            LowLevelRReilOpnd dst = opnd.getOperandStack().pop();
            LowLevelRReilOpnd tmp = registerTranslator.temporaryRegister(env, dst.size());
            this.emitter.emit(env, tmp, null, null, instructions);
            X86Helpers.emitWritebackAndMaybeZeroExtend(env, dst, tmp, instructions);
        }
    }

    public static class PopEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd _null1, LowLevelRReilOpnd _null2, List<LowLevelRReil> instructions) {
            RegisterTranslator registerTranslator = env.getRegisterTranslator();
            LowLevelRReilOpnd esp = registerTranslator.translateRegister("esp").withSize(env.getDefaultArchitectureSize());
            LowLevelRReilOpnd inc = factory.immediate(esp.size(), (Number)(dst.size() / 8));
            instructions.addAll(Arrays.asList(factory.LOAD(env.getNextReilAddress(), dst, esp), factory.ADD(env.getNextReilAddress(), esp, esp, inc)));
        }
    }
}

