/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.disassembler.translators.x86.common.X86OperandTranslator;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public class MulTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        List<OperandTree> operands = instruction.operands();
        OperandTree operand = operands.get(0);
        TranslationState opnd = X86OperandTranslator.translateOperand(env, operand);
        instructions.addAll(opnd.getInstructionStack());
        LowLevelRReilOpnd src = opnd.getOperandStack().pop();
        int size = src.size();
        switch (size) {
            case 8: {
                LowLevelRReilOpnd ax = registerTranslator.translateRegister("ax");
                LowLevelRReilOpnd al = registerTranslator.translateRegister("al");
                LowLevelRReilOpnd op1 = registerTranslator.temporaryRegister(env, OperandSize.WORD);
                LowLevelRReilOpnd op2 = registerTranslator.temporaryRegister(env, OperandSize.WORD);
                instructions.addAll(Arrays.asList(factory.CONVERT(env.getNextReilAddress(), op1, al), factory.CONVERT(env.getNextReilAddress(), op2, src), factory.MUL(env.getNextReilAddress(), ax, op1, op2)));
                MulTranslator.emitFlags(env, ax, al, instructions);
                break;
            }
            case 16: {
                LowLevelRReilOpnd dx = registerTranslator.translateRegister("dx");
                LowLevelRReilOpnd ax = registerTranslator.translateRegister("ax");
                LowLevelRReilOpnd op1 = registerTranslator.temporaryRegister(env, OperandSize.DWORD);
                LowLevelRReilOpnd op2 = registerTranslator.temporaryRegister(env, OperandSize.DWORD);
                LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, OperandSize.DWORD);
                instructions.addAll(Arrays.asList(factory.CONVERT(env.getNextReilAddress(), op1, ax), factory.CONVERT(env.getNextReilAddress(), op2, src), factory.MUL(env.getNextReilAddress(), t, op1, op2), factory.MOV(env.getNextReilAddress(), ax, t.withSize(OperandSize.WORD)), factory.MOV(env.getNextReilAddress(), dx, t.withOffset(16, OperandSize.WORD))));
                MulTranslator.emitFlags(env, t, ax, instructions);
                break;
            }
            case 32: {
                LowLevelRReilOpnd edx = registerTranslator.translateRegister("edx");
                LowLevelRReilOpnd eax = registerTranslator.translateRegister("eax");
                LowLevelRReilOpnd op1 = registerTranslator.temporaryRegister(env, OperandSize.QWORD);
                LowLevelRReilOpnd op2 = registerTranslator.temporaryRegister(env, OperandSize.QWORD);
                LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, OperandSize.QWORD);
                instructions.addAll(Arrays.asList(factory.CONVERT(env.getNextReilAddress(), op1, eax), factory.CONVERT(env.getNextReilAddress(), op2, src), factory.MUL(env.getNextReilAddress(), t, op1, op2)));
                X86Helpers.emitWritebackAndMaybeZeroExtend(env, eax, t.withSize(OperandSize.DWORD), instructions);
                X86Helpers.emitWritebackAndMaybeZeroExtend(env, edx, t.withOffset(32, OperandSize.DWORD), instructions);
                MulTranslator.emitFlags(env, t, eax, instructions);
                break;
            }
            case 64: {
                LowLevelRReilOpnd rdx = registerTranslator.translateRegister("rdx");
                LowLevelRReilOpnd rax = registerTranslator.translateRegister("rax");
                LowLevelRReilOpnd op1 = registerTranslator.temporaryRegister(env, OperandSize.OWORD);
                LowLevelRReilOpnd op2 = registerTranslator.temporaryRegister(env, OperandSize.OWORD);
                LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, OperandSize.OWORD);
                instructions.addAll(Arrays.asList(factory.CONVERT(env.getNextReilAddress(), op1, rax), factory.CONVERT(env.getNextReilAddress(), op2, src), factory.MUL(env.getNextReilAddress(), t, op1, op2), factory.MOV(env.getNextReilAddress(), rax, t.withSize(OperandSize.QWORD)), factory.MOV(env.getNextReilAddress(), rdx, t.withOffset(64, OperandSize.QWORD))));
                MulTranslator.emitFlags(env, t, rax, instructions);
                break;
            }
            default: {
                throw new RuntimeException("Error: Invalid operand size");
            }
        }
        MulTranslator.emitUndefineFlags(env, instructions);
    }

    private static void emitUndefineFlags(TranslationCtx env, List<LowLevelRReil> instructions) {
        instructions.addAll(Arrays.asList(factory.UNDEF(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.PARITY_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.AUXILIARY_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND)));
    }

    private static void emitFlags(TranslationCtx env, LowLevelRReilOpnd precise, LowLevelRReilOpnd actual, List<LowLevelRReil> instructions) {
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, precise.size());
        instructions.addAll(Arrays.asList(factory.CONVERT(env.getNextReilAddress(), t, actual), factory.CMPEQ(env.getNextReilAddress(), X86Helpers.BELOW_FLAG_OPERAND, precise, t), factory.CMPEQ(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND, precise, t)));
    }
}

