/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public class LahfTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        LowLevelRReilOpnd ax = registerTranslator.translateRegister("ax");
        LowLevelRReilOpnd zero = factory.immediate(OperandSize.BIT, (Number)0);
        LowLevelRReilOpnd one = factory.immediate(OperandSize.BIT, (Number)1);
        instructions.addAll(Arrays.asList(factory.MOV(env.getNextReilAddress(), ax.withOffset(8, OperandSize.BIT), X86Helpers.BELOW_FLAG_OPERAND), factory.MOV(env.getNextReilAddress(), ax.withOffset(9, OperandSize.BIT), one), factory.MOV(env.getNextReilAddress(), ax.withOffset(10, OperandSize.BIT), X86Helpers.PARITY_FLAG_OPERAND), factory.MOV(env.getNextReilAddress(), ax.withOffset(11, OperandSize.BIT), zero), factory.MOV(env.getNextReilAddress(), ax.withOffset(12, OperandSize.BIT), X86Helpers.AUXILIARY_FLAG_OPERAND), factory.MOV(env.getNextReilAddress(), ax.withOffset(13, OperandSize.BIT), zero), factory.MOV(env.getNextReilAddress(), ax.withOffset(14, OperandSize.BIT), X86Helpers.EQUAL_FLAG_OPERAND), factory.MOV(env.getNextReilAddress(), ax.withOffset(15, OperandSize.BIT), X86Helpers.SIGN_FLAG_OPERAND)));
    }
}

