/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.common;

import rreil.disassembler.Instruction;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.lang.RReilAddr;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public final class TranslationCtx {
    private final RegisterTranslator registerTranslator;
    private int currentRReilOffset = 0;
    private int nextVariable = 0;
    private final int defaultArchitectureSize;
    private final long baseAddress;
    private Instruction currentInstruction;

    public TranslationCtx(long baseAddress, RegisterTranslator translator, int defaultArchitectureSize) {
        this.baseAddress = baseAddress;
        this.registerTranslator = translator;
        this.defaultArchitectureSize = defaultArchitectureSize;
    }

    public String getNextVariableString() {
        return String.format("t%d", this.generateNextVariable());
    }

    public int generateNextVariable() {
        return this.nextVariable++;
    }

    public RReilAddr getNextReilAddress() {
        return new RReilAddr(this.baseAddress, this.currentRReilOffset++);
    }

    public long getCurrentReilOffset() {
        return this.currentRReilOffset;
    }

    public RegisterTranslator getRegisterTranslator() {
        return this.registerTranslator;
    }

    public int getDefaultArchitectureSize() {
        return this.defaultArchitectureSize;
    }

    public long getBaseAddress() {
        return this.baseAddress;
    }

    public long getFollowupAddress(Instruction insn) {
        return this.baseAddress + (long)insn.length();
    }

    public void setCurrentInstruction(Instruction insn) {
        this.currentInstruction = insn;
    }

    public Instruction getCurrentInstruction() {
        return this.currentInstruction;
    }

    public LowLevelRReilOpnd translateRegister(String name) {
        return this.registerTranslator.translateRegister(name);
    }

    public LowLevelRReilOpnd temporaryRegister(Number size) {
        return this.registerTranslator.temporaryRegister(this, size);
    }

    public LowLevelRReilOpnd temporaryRegister(OperandSize size) {
        return this.registerTranslator.temporaryRegister(this, size);
    }
}

