/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler;

import java.util.Stack;
import javalx.data.products.P2;
import rreil.disassembler.OperandTree;

public class OperandPostorderIterator {
    private final Stack<P2<OperandTree.Node, Integer>> traversalStack = new Stack();
    private final Stack<Number> sizeScope = new Stack();
    private final OperandTree.Node root;
    private boolean started = false;

    public OperandPostorderIterator(OperandTree.Node root) {
        this.root = root;
    }

    private void pushLeftmostPath(OperandTree.Node node) {
        OperandTree.Node current = node;
        while (true) {
            if (current.getType() == OperandTree.Type.Size) {
                this.sizeScope.push((Number)current.getData());
            } else if (current.getType() == OperandTree.Type.Mem) {
                this.sizeScope.push((Number)current.getData());
            }
            this.traversalStack.push(new P2<OperandTree.Node, Integer>(current, 0));
            if (current.getChildren().isEmpty()) break;
            current = current.getChildren().get(0);
        }
    }

    public OperandTree.Node current() {
        return (OperandTree.Node)((P2)this.traversalStack.lastElement())._1();
    }

    public Number currentSizeScope() {
        return this.sizeScope.peek();
    }

    public Stack<Number> getOperandSizeStack() {
        return (Stack)this.sizeScope.clone();
    }

    public boolean next() {
        if (!this.started) {
            this.pushLeftmostPath(this.root);
            this.started = true;
        } else {
            if (this.traversalStack.empty()) {
                throw new RuntimeException("Internal Error: Traversal already finished");
            }
            P2<OperandTree.Node, Integer> lastProcessed = this.traversalStack.pop();
            OperandTree.Node lastProcessedNode = lastProcessed._1();
            int lastProcessedChildrenProcessed = lastProcessed._2();
            if (lastProcessedNode.getType() == OperandTree.Type.Size || lastProcessedNode.getType() == OperandTree.Type.Mem) {
                this.sizeScope.pop();
            }
            if (lastProcessedChildrenProcessed >= lastProcessedNode.getChildren().size()) {
                if (this.traversalStack.empty()) {
                    return false;
                }
                P2<OperandTree.Node, Integer> parent = this.traversalStack.pop();
                OperandTree.Node parentNode = parent._1();
                Integer parentChild = parent._2();
                this.traversalStack.push(new P2<OperandTree.Node, Integer>(parentNode, parentChild + 1));
                if (parentChild + 1 < parentNode.getChildren().size()) {
                    this.pushLeftmostPath(parentNode.getChildren().get(parentChild + 1));
                }
                if (parentChild > 1) {
                    this.traversalStack.push(parent);
                }
            }
        }
        return !this.traversalStack.empty();
    }
}

