/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler;

import java.util.Stack;
import javalx.data.products.P2;
import rreil.disassembler.OperandTree;

public class OperandInfixIterator {
    private final Stack<P2<OperandTree.Node, Integer>> m_traversalStack = new Stack();
    private final OperandTree.Node root;
    private boolean started = false;

    public OperandInfixIterator(OperandTree.Node root) {
        this.root = root;
    }

    private void pushLongestPathFrom(OperandTree.Node node) {
        OperandTree.Node current = node;
        while (true) {
            this.m_traversalStack.push(new P2<OperandTree.Node, Integer>(current, 0));
            if (current.getChildren().size() <= 1) break;
            current = current.getChildren().get(0);
        }
    }

    public OperandTree.Node current() {
        return (OperandTree.Node)((P2)this.m_traversalStack.lastElement())._1();
    }

    public boolean next() {
        if (!this.started) {
            this.pushLongestPathFrom(this.root);
            this.started = true;
        } else {
            if (this.m_traversalStack.empty()) {
                throw new RuntimeException("Internal Error: Traversal already finished");
            }
            P2<OperandTree.Node, Integer> lastProcessed = this.m_traversalStack.pop();
            OperandTree.Node lastProcessedNode = lastProcessed._1();
            int lastProcessedChildrenProcessed = lastProcessed._2();
            if (lastProcessedChildrenProcessed < lastProcessedNode.getChildren().size()) {
                if (lastProcessed._1().getChildren().size() > 1) {
                    this.m_traversalStack.add(lastProcessed);
                }
                this.pushLongestPathFrom(lastProcessedNode.getChildren().get(lastProcessedChildrenProcessed));
                return true;
            }
            if (this.m_traversalStack.empty()) {
                return false;
            }
            do {
                P2<OperandTree.Node, Integer> parent;
                if ((parent = this.m_traversalStack.pop())._2() >= parent._1().getChildren().size() - 1) continue;
                this.m_traversalStack.push(new P2<OperandTree.Node, Integer>(parent._1(), parent._2() + 1));
                return true;
            } while (!this.m_traversalStack.empty());
        }
        return !this.m_traversalStack.empty();
    }
}

