/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public abstract class WLClause
implements Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double activity;
    protected final int[] lits;
    protected final ILits voc;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.minisat.constraints.cnf.WLClause");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public WLClause(IVecInt ps, ILits voc) {
        this.lits = new int[ps.size()];
        ps.moveTo(this.lits);
        if (!$assertionsDisabled && ps.size() != 0) {
            throw new AssertionError();
        }
        this.voc = voc;
        this.activity = 0.0;
    }

    public void calcReason(int p, IVecInt outReason) {
        int[] mylits = this.lits;
        int i = p == -1 ? 0 : 1;
        while (i < mylits.length) {
            if (!$assertionsDisabled && !this.voc.isFalsified(mylits[i])) {
                throw new AssertionError();
            }
            outReason.push(mylits[i] ^ 1);
            ++i;
        }
    }

    public void remove(UnitPropagationListener upl) {
        this.voc.watches(this.lits[0] ^ 1).remove(this);
        this.voc.watches(this.lits[1] ^ 1).remove(this);
    }

    public boolean simplify() {
        int i = 0;
        while (i < this.lits.length) {
            if (this.voc.isSatisfied(this.lits[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        int[] mylits = this.lits;
        if (mylits[0] == (p ^ 1)) {
            mylits[0] = mylits[1];
            mylits[1] = p ^ 1;
        }
        int previous = p ^ 1;
        int i = 2;
        while (i < mylits.length) {
            if (!this.voc.isFalsified(mylits[i])) {
                mylits[1] = mylits[i];
                mylits[i] = previous;
                this.voc.watch(mylits[1] ^ 1, this);
                return true;
            }
            int tmp = previous;
            previous = mylits[i];
            mylits[i] = tmp;
            ++i;
        }
        i = 2;
        while (i < mylits.length) {
            mylits[i - 1] = mylits[i];
            ++i;
        }
        mylits[mylits.length - 1] = previous;
        this.voc.watch(p, this);
        return s.enqueue(mylits[0], this);
    }

    public boolean locked() {
        return this.voc.getReason(this.lits[0]) == this;
    }

    public double getActivity() {
        return this.activity;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < this.lits.length) {
            stb.append(Lits.toString(this.lits[i]));
            stb.append("[");
            stb.append(this.voc.valueToString(this.lits[i]));
            stb.append("]");
            stb.append(" ");
            ++i;
        }
        return stb.toString();
    }

    public int get(int i) {
        return this.lits[i];
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    public int size() {
        return this.lits.length;
    }

    public void assertConstraint(UnitPropagationListener s) {
        boolean ret = s.enqueue(this.lits[0], this);
        if (!$assertionsDisabled && !ret) {
            throw new AssertionError();
        }
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public int[] getLits() {
        int[] tmp = new int[this.size()];
        System.arraycopy(this.lits, 0, tmp, 0, this.size());
        return tmp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            WLClause wcl = (WLClause)obj;
            if (this.lits.length != wcl.lits.length) {
                return false;
            }
            int[] nArray = this.lits;
            int n = this.lits.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                int lit = nArray[n2];
                boolean ok = false;
                int[] nArray2 = wcl.lits;
                int n3 = wcl.lits.length;
                int n4 = 0;
                while (n4 < n3) {
                    int lit2 = nArray2[n4];
                    if (lit == lit2) {
                        ok = true;
                        break;
                    }
                    ++n4;
                }
                if (!ok) {
                    return false;
                }
                ++n2;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long sum = 0L;
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            sum += (long)p;
            ++n2;
        }
        return (int)sum / this.lits.length;
    }

    public boolean canBePropagatedMultipleTimes() {
        return false;
    }
}

