/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.dwarf;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICompileOptionsFinder;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.cdt.utils.debug.IDebugEntryRequestor;
import org.eclipse.cdt.utils.debug.dwarf.Dwarf;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class DwarfReader
extends Dwarf
implements ISymbolReader,
ICompileOptionsFinder {
    static final String[] DWARF_SectionsToParse = new String[]{".debug_info", ".debug_line", ".debug_abbrev", ".debug_str", ".debug_macro"};
    static final String[] DWARF_ALT_SectionsToParse = new String[]{".debug_str", ".debug_macro"};
    private final Collection<String> m_fileCollection = new HashSet<String>();
    private final Map<Long, String> m_stmtFileMap = new HashMap<Long, String>();
    private final Map<String, ArrayList<String>> m_compileOptionsMap = new HashMap<String, ArrayList<String>>();
    private String[] m_fileNames = null;
    private boolean m_parsed = false;
    private boolean m_macros_parsed = false;
    private final ArrayList<Integer> m_parsedLineTableOffsets = new ArrayList();
    private long m_parsedLineTableSize = 0L;

    public DwarfReader(String file) throws IOException {
        super(file);
    }

    public DwarfReader(Elf exe) throws IOException {
        super(exe);
    }

    public DwarfReader(PE exe) throws IOException {
        super(exe);
    }

    @Override
    public void init(Elf exe) throws IOException {
        ByteBuffer data;
        Elf.Section gnuDebugLink;
        Elf.ELFhdr header = exe.getELFhdr();
        this.isLE = header.e_ident[5] == 1;
        IPath debugInfoPath = new Path(exe.getFilename());
        Elf.Section[] sections = exe.getSections();
        boolean have_build_id = false;
        for (Elf.Section section : sections) {
            ByteBuffer data2;
            if (section.sh_type != 7L || (data2 = section.mapSectionData()).remaining() <= 12) continue;
            try {
                int name_sz = this.read_4_bytes(data2);
                int data_sz = this.read_4_bytes(data2);
                int note_type = this.read_4_bytes(data2);
                String noteName = this.readString(data2);
                String buildId = null;
                if (!noteName.equals("GNU") || note_type != 3) continue;
                byte[] byteArray = new byte[data_sz];
                while ((data2.position() & 3) != 0) {
                    data2.get();
                }
                int i = 0;
                while (data2.hasRemaining() && data_sz-- > 0) {
                    byteArray[i++] = data2.get();
                }
                String bName = DatatypeConverter.printHexBinary((byte[])byteArray).toLowerCase();
                buildId = bName.substring(0, 2) + "/" + bName.substring(2) + ".debug";
                IPath buildIdPath = new Path("/usr/lib/debug/.build-id").append(buildId);
                File buildIdFile = buildIdPath.toFile();
                if (!buildIdFile.exists()) continue;
                Elf debugInfo = new Elf(buildIdFile.getCanonicalPath());
                sections = debugInfo.getSections();
                have_build_id = true;
                debugInfoPath = new Path(buildIdFile.getCanonicalPath()).removeLastSegments(1);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                CCorePlugin.log(e);
            }
        }
        if (!have_build_id && (gnuDebugLink = exe.getSectionByName(".gnu_debuglink")) != null && (data = gnuDebugLink.mapSectionData()) != null) {
            try {
                String debugName = "";
                if (data.hasRemaining()) {
                    byte c;
                    StringBuffer sb = new StringBuffer();
                    while ((c = data.get()) != -1 && c != 0) {
                        sb.append((char)c);
                    }
                    debugName = sb.toString();
                }
                if (debugName.length() > 0) {
                    File debugFile = null;
                    Path exePath = new Path(exe.getFilename());
                    IPath p = exePath.removeLastSegments(1);
                    debugFile = p.append(debugName).toFile();
                    if (!debugFile.exists() && !(debugFile = p.append(".debug").append(debugName).toFile()).exists()) {
                        debugFile = new Path("/usr/lib/debug").append(p).append(debugName).toFile();
                    }
                    if (debugFile.exists()) {
                        Elf debugInfo = new Elf(debugFile.getCanonicalPath());
                        sections = debugInfo.getSections();
                        debugInfoPath = new Path(debugFile.getCanonicalPath()).removeLastSegments(1);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                CCorePlugin.log(e);
            }
        }
        for (Elf.Section section : sections) {
            String name = section.toString();
            if (name.equals(".gnu_debugaltlink")) {
                ByteBuffer data3 = section.mapSectionData();
                try {
                    Elf.Section[] altSections;
                    File altFile;
                    String altInfoName = this.readString(data3);
                    if (altInfoName.length() <= 0) continue;
                    IPath altPath = new Path(altInfoName);
                    if (!altPath.isAbsolute()) {
                        altPath = debugInfoPath.append(altPath);
                    }
                    if (!(altFile = altPath.toFile()).exists()) continue;
                    Elf altInfo = new Elf(altFile.getCanonicalPath());
                    for (Elf.Section altSection : altSections = altInfo.getSections()) {
                        String altName = altSection.toString();
                        for (String element : DWARF_ALT_SectionsToParse) {
                            if (!altName.equals(element)) continue;
                            try {
                                this.dwarfAltSections.put(element, altSection.mapSectionData());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                CCorePlugin.log(e);
                            }
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CCorePlugin.log(e);
                    continue;
                }
            }
            for (String element : DWARF_SectionsToParse) {
                if (!name.equals(element)) continue;
                try {
                    this.dwarfSections.put(element, section.mapSectionData());
                }
                catch (Exception e) {
                    CCorePlugin.log(e);
                }
            }
        }
        this.printEnabled = false;
        this.m_parsed = false;
    }

    @Override
    public void init(PE exe) throws IOException {
        this.isLE = true;
        Coff.SectionHeader[] sections = exe.getSectionHeaders();
        for (int i = 0; i < sections.length; ++i) {
            String name = new String(sections[i].s_name).trim();
            if (name.startsWith("/")) {
                int stringTableOffset = Integer.parseInt(name.substring(1));
                name = exe.getStringTableEntry(stringTableOffset);
            }
            for (String element : Dwarf.DWARF_SCNNAMES) {
                if (!name.equals(element)) continue;
                try {
                    this.dwarfSections.put(element, sections[i].mapSectionData());
                }
                catch (Exception e) {
                    CCorePlugin.log(e);
                }
            }
        }
        this.printEnabled = false;
        this.m_parsed = false;
    }

    void parseSourceInCULineInfo(String cuCompDir, int cuStmtList) {
        ByteBuffer data = (ByteBuffer)this.dwarfSections.get(".debug_line");
        if (data != null) {
            try {
                String fileName;
                String str;
                data.position(cuStmtList);
                Integer cuOffset = new Integer(cuStmtList);
                boolean dwarf64Bit = false;
                if (!this.m_parsedLineTableOffsets.contains(cuOffset)) {
                    this.m_parsedLineTableOffsets.add(cuOffset);
                    Dwarf.InitialLengthValue length = this.readInitialLengthField(data);
                    dwarf64Bit = length.offsetSize == 8;
                    this.m_parsedLineTableSize += length.length + (long)(dwarf64Bit ? 12 : 4);
                } else {
                    return;
                }
                short version = this.read_2_bytes(data);
                int skip_bytes = 8;
                if (version >= 4) {
                    skip_bytes = (short)(skip_bytes + 1);
                }
                if (dwarf64Bit) {
                    skip_bytes = (short)(skip_bytes + 4);
                }
                data.position(data.position() + skip_bytes);
                byte opcode_base = data.get();
                data.position(data.position() + opcode_base - 1);
                ArrayList<String> dirList = new ArrayList<String>();
                dirList.add(cuCompDir);
                while ((str = this.readString(data)).length() != 0) {
                    IPath dir = new Path(str);
                    if (!dir.isAbsolute()) {
                        dir = new Path(cuCompDir).append(str);
                    }
                    dirList.add(dir.toString());
                }
                while ((fileName = this.readString(data)).length() != 0) {
                    long leb128 = this.read_unsigned_leb128(data);
                    this.addSourceFile((String)dirList.get((int)leb128), fileName);
                    leb128 = this.read_unsigned_leb128(data);
                    leb128 = this.read_unsigned_leb128(data);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void getSourceFilesFromDebugLineSection() {
        int minHeaderSize;
        ByteBuffer data = (ByteBuffer)this.dwarfSections.get(".debug_line");
        if (data == null) {
            return;
        }
        int sectionSize = data.capacity();
        if (this.m_parsedLineTableSize >= (long)(sectionSize - (minHeaderSize = 16))) {
            return;
        }
        int lineTableStart = 0;
        try {
            while (lineTableStart < sectionSize - minHeaderSize) {
                String fileName;
                String str;
                data.position(lineTableStart);
                Integer currLineTableStart = new Integer(lineTableStart);
                Dwarf.InitialLengthValue sectionLength = this.readInitialLengthField(data);
                boolean dwarf64Bit = sectionLength.offsetSize == 8;
                this.m_parsedLineTableSize += sectionLength.length + (long)(dwarf64Bit ? 12 : 4);
                if ((lineTableStart += (int)(sectionLength.length + (long)(dwarf64Bit ? 12 : 4))) < sectionSize - minHeaderSize && (lineTableStart & 3) != 0) {
                    boolean dataValid;
                    int savedPosition = data.position();
                    data.position(lineTableStart);
                    long ltLength = dwarf64Bit ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                    short dwarfVer = this.read_2_bytes(data);
                    byte minInstLengh = data.get(data.position() + (dwarf64Bit ? 8 : 4));
                    boolean bl = dataValid = ltLength > (long)minHeaderSize && ltLength < 0x100000L && dwarfVer > 0 && dwarfVer < 5 && minInstLengh > 0 && minInstLengh <= 8;
                    if (!dataValid) {
                        lineTableStart = lineTableStart + 3 & 0xFFFFFFFC;
                    }
                    data.position(savedPosition);
                }
                if (this.m_parsedLineTableOffsets.contains(currLineTableStart)) continue;
                short version = this.read_2_bytes(data);
                int skip_bytes = 8;
                if (version >= 4) {
                    skip_bytes = (short)(skip_bytes + 1);
                }
                if (dwarf64Bit) {
                    skip_bytes = (short)(skip_bytes + 4);
                }
                data.position(data.position() + skip_bytes);
                byte opcode_base = data.get();
                data.position(data.position() + opcode_base - 1);
                ArrayList<String> dirList = new ArrayList<String>();
                dirList.add("");
                while ((str = this.readString(data)).length() != 0) {
                    dirList.add(str);
                }
                while ((fileName = this.readString(data)).length() != 0) {
                    long leb128 = this.read_unsigned_leb128(data);
                    this.addSourceFile((String)dirList.get((int)leb128), fileName);
                    leb128 = this.read_unsigned_leb128(data);
                    leb128 = this.read_unsigned_leb128(data);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public String[] getSourceFiles() {
        if (!this.m_parsed) {
            this.m_fileCollection.clear();
            this.getSourceFilesFromDebugInfoSection();
            this.getSourceFilesFromDebugLineSection();
            this.m_parsed = true;
            this.m_fileNames = new String[this.m_fileCollection.size()];
            this.m_fileCollection.toArray(this.m_fileNames);
        }
        return this.m_fileNames;
    }

    private void getSourceFilesFromDebugInfoSection() {
        this.parse(null);
    }

    private String addSourceFileWithStmt(String dir, String name, int stmt) {
        String fullName = this.addSourceFile(dir, name);
        this.m_stmtFileMap.put(Long.valueOf(stmt), fullName);
        return fullName;
    }

    private String addSourceFile(String dir, String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.charAt(0) == '<') {
            return null;
        }
        String fullName = name;
        Path dirPa = new Path(dir);
        IPath pa = new Path(name);
        if (!pa.isAbsolute() && dir.length() > 0) {
            pa = dirPa.append(pa);
        }
        if (!this.m_fileCollection.contains(fullName = pa.toOSString())) {
            this.m_fileCollection.add(fullName);
        }
        return fullName;
    }

    @Override
    void processDebugInfoEntry(IDebugEntryRequestor requestor, Dwarf.AbbreviationEntry entry, List<Dwarf.AttributeValue> list) {
        int tag = (int)entry.tag;
        switch (tag) {
            case 17: {
                this.processCompileUnit(requestor, list);
                break;
            }
        }
    }

    @Override
    void processCompileUnit(IDebugEntryRequestor requestor, List<Dwarf.AttributeValue> list) {
        int stmtList = -1;
        String cuCompDir = "";
        String cuName = "";
        for (int i = 0; i < list.size(); ++i) {
            Dwarf.AttributeValue av = list.get(i);
            try {
                int name = (int)av.attribute.name;
                switch (name) {
                    case 3: {
                        cuName = (String)av.value;
                        break;
                    }
                    case 27: {
                        cuCompDir = (String)av.value;
                        break;
                    }
                    case 16: {
                        stmtList = ((Number)av.value).intValue();
                        break;
                    }
                }
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.addSourceFileWithStmt(cuCompDir, cuName, stmtList);
        if (stmtList > -1) {
            this.parseSourceInCULineInfo(cuCompDir, stmtList);
        }
    }

    @Override
    public String[] getSourceFiles(IProgressMonitor monitor) {
        return this.getSourceFiles();
    }

    private String getCommandLineMacro(String macro) {
        String commandLineMacro = "-D" + macro;
        commandLineMacro = commandLineMacro.replaceFirst(" ", "=");
        return commandLineMacro;
    }

    private void getCommandMacrosFromMacroSection() {
        ByteBuffer data = (ByteBuffer)this.dwarfSections.get(".debug_macro");
        ByteBuffer str = (ByteBuffer)this.dwarfSections.get(".debug_str");
        ByteBuffer altdata = (ByteBuffer)this.dwarfAltSections.get(".debug_macro");
        ByteBuffer altstr = (ByteBuffer)this.dwarfAltSections.get(".debug_str");
        HashSet<String> fixupList = new HashSet<String>();
        HashSet<String> fixupAltList = new HashSet<String>();
        boolean DEBUG = false;
        if (data == null) {
            return;
        }
        HashMap<Long, ArrayList<String>> t_macros = new HashMap<Long, ArrayList<String>>();
        HashMap<Long, ArrayList<String>> t_alt_macros = new HashMap<Long, ArrayList<String>>();
        this.parseMacroSection(data, str, altstr, fixupList, fixupAltList, "=FIXUP=", DEBUG, t_macros);
        if (altdata != null) {
            if (DEBUG) {
                System.out.println("Processing Alternate Macro Section");
            }
            this.parseMacroSection(altdata, altstr, altstr, fixupAltList, fixupAltList, "=FIXUPALT=", DEBUG, t_alt_macros);
        }
        this.fixupMacros(fixupList, "=FIXUP=", DEBUG, t_macros);
        if (DEBUG) {
            System.out.println("Fix up forward references in alternate macro section");
        }
        this.fixupMacros(fixupAltList, "=FIXUPALT=", DEBUG, t_alt_macros);
    }

    private void fixupMacros(Set<String> fixupList, String fixupMarker, boolean DEBUG, HashMap<Long, ArrayList<String>> t_macros) {
        for (String name : fixupList) {
            ArrayList<String> macros = this.m_compileOptionsMap.get(name);
            for (int i = 0; i < macros.size(); ++i) {
                String macroLine = macros.get(i);
                if (!macroLine.startsWith(fixupMarker)) continue;
                Long offset = Long.valueOf(macroLine.substring(7));
                if (DEBUG) {
                    System.out.println("Found fixup needed for offset: " + offset + " for file: " + name);
                }
                ArrayList<String> insertMacros = t_macros.get(offset);
                if (DEBUG) {
                    System.out.println("insert macros are: " + insertMacros.toString());
                }
                macros.remove(i);
                macros.addAll(i, insertMacros);
                i += insertMacros.size();
            }
            this.m_compileOptionsMap.put(name, macros);
        }
    }

    private void parseMacroSection(ByteBuffer data, ByteBuffer str, ByteBuffer altstr, Set<String> fixupList, Set<String> fixupAltList, String fixupMarker, boolean DEBUG, HashMap<Long, ArrayList<String>> t_macros) {
        while (data.hasRemaining()) {
            try {
                boolean offset_size_8;
                int original_position = data.position();
                short type = this.read_2_bytes(data);
                byte flags = data.get();
                long lt_offset = -1L;
                String fileName = null;
                HashMap<Integer, OpcodeInfo> opcodeInfos = null;
                if (DEBUG) {
                    System.out.println("type is " + type);
                }
                boolean bl = offset_size_8 = (flags & 1) == 1;
                if (DEBUG) {
                    System.out.println("offset size is " + (offset_size_8 ? 8 : 4));
                }
                if ((flags & 2) != 0) {
                    lt_offset = offset_size_8 ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                    fileName = this.m_stmtFileMap.get(lt_offset);
                    if (DEBUG) {
                        System.out.println("debug line offset is " + lt_offset);
                    }
                }
                if ((flags & 4) != 0) {
                    opcodeInfos = new HashMap<Integer, OpcodeInfo>();
                    int num_opcodes = data.get();
                    for (int i = 0; i < num_opcodes; ++i) {
                        OpcodeInfo info = new OpcodeInfo(offset_size_8);
                        byte opcode = data.get();
                        long numArgs = this.read_unsigned_leb128(data);
                        info.setNumArgs((int)numArgs);
                        int j = 0;
                        while ((long)j < numArgs) {
                            byte argType = data.get();
                            info.addArgType(argType);
                            ++j;
                        }
                        opcodeInfos.put(Integer.valueOf(opcode), info);
                    }
                }
                ArrayList<String> macros = new ArrayList<String>();
                boolean done = false;
                block18: while (!done) {
                    byte op = data.get();
                    switch (op) {
                        case 3: {
                            long lineno = this.read_signed_leb128(data);
                            long filenum = this.read_signed_leb128(data);
                            if (filenum == 1L && lt_offset >= 0L) {
                                this.m_compileOptionsMap.put(fileName, macros);
                                if (DEBUG) {
                                    System.out.println("following macros found for file " + macros.toString());
                                }
                                macros = new ArrayList();
                            }
                            if (fileName == null) continue block18;
                            if (DEBUG) {
                                System.out.println(" DW_MACRO_start_file - lineno: " + lineno + " filenum: " + filenum + " " + fileName);
                                continue block18;
                            }
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_start_file - lineno: " + lineno + " filenum: " + filenum);
                            continue block18;
                        }
                        case 4: {
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_end_file");
                            continue block18;
                        }
                        case 1: {
                            long lineno = this.read_signed_leb128(data);
                            String string = this.readString(data);
                            if (lineno == 0L) {
                                macros.add(this.getCommandLineMacro(string));
                            }
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_define - lineno : " + lineno + " macro : " + string);
                            continue block18;
                        }
                        case 2: {
                            long lineno = this.read_signed_leb128(data);
                            String macro = this.readString(data);
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_undef - lineno : " + lineno + " macro : " + macro);
                            continue block18;
                        }
                        case 5: {
                            long lineno = this.read_signed_leb128(data);
                            long offset = offset_size_8 ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                            str.position((int)offset);
                            String macro = this.readString(str);
                            if (lineno == 0L) {
                                macros.add(this.getCommandLineMacro(macro));
                            }
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_define_indirect - lineno : " + lineno + " macro : " + macro);
                            continue block18;
                        }
                        case 8: {
                            long lineno = this.read_signed_leb128(data);
                            long offset = offset_size_8 ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                            altstr.position((int)offset);
                            String macro = this.readString(altstr);
                            if (lineno == 0L) {
                                macros.add(this.getCommandLineMacro(macro));
                            }
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_define_indirect_alt - lineno : " + lineno + " macro : " + macro);
                            continue block18;
                        }
                        case 6: {
                            long lineno = this.read_signed_leb128(data);
                            long offset = offset_size_8 ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                            str.position((int)offset);
                            String macro = this.readString(str);
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_undef_indirect - lineno : " + lineno + " macro : " + macro);
                            continue block18;
                        }
                        case 9: {
                            long lineno = this.read_signed_leb128(data);
                            long offset = offset_size_8 ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                            altstr.position((int)offset);
                            String macro = this.readString(altstr);
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_undef_indirect_alt - lineno : " + lineno + " macro : " + macro);
                            continue block18;
                        }
                        case 7: {
                            long offset = offset_size_8 ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                            ArrayList<String> foundMacros = t_macros.get(offset);
                            if (foundMacros != null) {
                                macros.addAll(foundMacros);
                            } else if (lt_offset >= 0L) {
                                macros.add(fixupMarker + offset);
                                if (DEBUG) {
                                    System.out.println("Adding fixup for offset: " + offset + " for file: " + fileName);
                                }
                                fixupList.add(fileName);
                            }
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_transparent_include - offset : " + offset);
                            continue block18;
                        }
                        case 10: {
                            long offset;
                            long l = offset = offset_size_8 ? this.read_8_bytes(data) : (long)this.read_4_bytes(data);
                            if (lt_offset >= 0L) {
                                macros.add("=FIXUPALT=" + offset);
                                if (DEBUG) {
                                    System.out.println("Adding alt fixup for offset: " + offset + " for file: " + fileName);
                                }
                                fixupAltList.add(fileName);
                            }
                            if (!DEBUG) continue block18;
                            System.out.println(" DW_MACRO_transparent_include - offset : " + offset);
                            continue block18;
                        }
                        case 0: {
                            if (lt_offset < 0L) {
                                if (DEBUG) {
                                    System.out.println("creating transparent include macros for offset: " + original_position);
                                }
                                t_macros.put(Long.valueOf(original_position), macros);
                            }
                            done = true;
                            continue block18;
                        }
                    }
                    if (opcodeInfos == null) continue;
                    OpcodeInfo info = (OpcodeInfo)opcodeInfos.get(op);
                    info.readPastEntry(data);
                }
            }
            catch (IOException iOException) {
            }
        }
    }

    @Override
    public String getCompileOptions(String fileName) {
        ArrayList<String> macros;
        if (!this.m_macros_parsed) {
            this.getSourceFiles();
            this.getCommandMacrosFromMacroSection();
            this.m_macros_parsed = true;
        }
        if ((macros = this.m_compileOptionsMap.get(fileName)) == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String option : macros) {
            sb.append(option);
            sb.append(" ");
        }
        return sb.toString();
    }

    private class OpcodeInfo {
        private int numArgs;
        private final boolean offset_size_8;
        ArrayList<Integer> argTypes;

        public OpcodeInfo(boolean offset_size_8) {
            this.offset_size_8 = offset_size_8;
        }

        public void setNumArgs(int numArgs) {
            this.numArgs = numArgs;
        }

        public void addArgType(int argType) {
            this.argTypes.add(argType);
        }

        public void readPastEntry(ByteBuffer data) {
            block17: for (int i = 0; i < this.numArgs; ++i) {
                int argType = this.argTypes.get(i);
                switch (argType) {
                    case 11: 
                    case 12: {
                        data.get();
                        continue block17;
                    }
                    case 5: {
                        data.getShort();
                        continue block17;
                    }
                    case 6: {
                        data.getInt();
                        continue block17;
                    }
                    case 7: {
                        data.getLong();
                        continue block17;
                    }
                    case 13: 
                    case 15: {
                        try {
                            DwarfReader.this.read_signed_leb128(data);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue block17;
                    }
                    case 9: {
                        try {
                            long off = DwarfReader.this.read_signed_leb128(data);
                            data.position((int)((long)data.position() + off));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue block17;
                    }
                    case 10: {
                        byte off = data.get();
                        data.position(data.position() + off + 1);
                        continue block17;
                    }
                    case 3: {
                        short off = data.getShort();
                        data.position(data.position() + off + 2);
                        continue block17;
                    }
                    case 4: {
                        int off = data.getInt();
                        data.position(data.position() + off + 4);
                        continue block17;
                    }
                    case 8: {
                        while (data.get() != 0) {
                        }
                        continue block17;
                    }
                    case 14: 
                    case 23: 
                    case 7968: 
                    case 7969: {
                        if (this.offset_size_8) {
                            data.getLong();
                            continue block17;
                        }
                        data.getInt();
                    }
                }
            }
        }
    }
}

