/*
 * Decompiled with CFR 0.152.
 */
package javalx.persistentcollections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.fn.Fn2;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.AVLSet;
import javalx.persistentcollections.FiniteMap;
import javalx.persistentcollections.ThreeWaySplit;

public class MultiMap<K, V>
implements Iterable<P2<K, V>> {
    private final AVLMap<K, AVLSet<V>> map;
    private final Fn2<AVLSet<V>, AVLSet<V>, AVLSet<V>> setUnion = new Fn2<AVLSet<V>, AVLSet<V>, AVLSet<V>>(){

        @Override
        public AVLSet<V> apply(AVLSet<V> a, AVLSet<V> b) {
            return a.union(b);
        }
    };
    private final Fn2<AVLSet<V>, AVLSet<V>, AVLSet<V>> setIntersection = new Fn2<AVLSet<V>, AVLSet<V>, AVLSet<V>>(){

        @Override
        public AVLSet<V> apply(AVLSet<V> a, AVLSet<V> b) {
            return a.intersection(b);
        }
    };

    private MultiMap(AVLMap<K, AVLSet<V>> map) {
        this.map = map;
    }

    private MultiMap<K, V> build(AVLMap<K, AVLSet<V>> map) {
        return new MultiMap<K, V>(map);
    }

    public static <K, V> MultiMap<K, V> empty() {
        return new MultiMap(AVLMap.empty());
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public AVLSet<V> get(K key) {
        Option<AVLSet<V>> values = this.map.get(key);
        if (values.isSome()) {
            return values.get();
        }
        return AVLSet.empty();
    }

    public boolean contains(K key) {
        return this.map.contains(key) && !this.map.get(key).get().isEmpty();
    }

    public MultiMap<K, V> add(K key, V value) {
        AVLSet<V> values = this.get(key);
        if ((values = values.add(value)).isEmpty()) {
            return this;
        }
        return this.build((AVLMap<K, AVLSet<V>>)this.map.bind((Object)key, (Object)values));
    }

    public MultiMap<K, V> add(K key, AVLSet<V> values) {
        AVLSet<V> oldValues = this.get(key);
        AVLSet<V> newValues = oldValues.union(values);
        if (newValues.isEmpty()) {
            return this;
        }
        return this.build((AVLMap<K, AVLSet<V>>)this.map.bind((Object)key, (Object)newValues));
    }

    public MultiMap<K, V> remove(K key) {
        return this.build((AVLMap<K, AVLSet<V>>)this.map.remove((Object)key));
    }

    public MultiMap<K, V> remove(K key, V value) {
        AVLSet<V> values = this.get(key);
        if (!values.contains(value)) {
            return this;
        }
        if ((values = values.remove(value)).isEmpty()) {
            return this.remove(key);
        }
        return this.build((AVLMap<K, AVLSet<V>>)this.map.bind((Object)key, (Object)values));
    }

    public MultiMap<K, V> replaceKey(K oldKey, K newKey) {
        AVLSet<V> values = this.get(oldKey);
        if (values.isEmpty()) {
            return this;
        }
        FiniteMap newMap = this.map.remove((Object)oldKey);
        values = values.union(this.get(newKey));
        newMap = ((AVLMap)newMap).bind((Object)newKey, values);
        return this.build((AVLMap<K, AVLSet<V>>)newMap);
    }

    public MultiMap<K, V> replaceValue(K key, V oldValue, V newValue) {
        if (!this.contains(key)) {
            return this;
        }
        MultiMap<K, V> newMap = this.remove(key, oldValue);
        return newMap.add(key, newValue);
    }

    public MultiMap<K, V> replaceValues(K key, AVLSet<V> values) {
        if (values.isEmpty()) {
            return this.remove(key);
        }
        return this.build((AVLMap<K, AVLSet<V>>)this.map.bind((Object)key, (Object)values));
    }

    public MultiMap<K, V> union(MultiMap<K, V> other) {
        return this.build(this.map.union(this.setUnion, other.map));
    }

    public MultiMap<K, V> intersection(MultiMap<K, V> other) {
        FiniteMap intersection = this.map.intersection(this.setIntersection, other.map);
        for (P2<K, AVLSet<V>> p2 : intersection) {
            if (!p2._2().isEmpty()) continue;
            intersection = intersection.remove((Object)p2._1());
        }
        return this.build((AVLMap<K, AVLSet<V>>)intersection);
    }

    public MultiMap<K, V> difference(MultiMap<K, V> other) {
        ThreeWaySplit<MultiMap<K, V>> split = this.splitWithDifference(other);
        return split.onlyInFirst().union(split.inBothButDiffering());
    }

    public ThreeWaySplit<MultiMap<K, V>> splitWithDifference(MultiMap<K, V> other) {
        ThreeWaySplit<AVLMap<K, AVLSet<V>>> split = this.map.split(other.map);
        MultiMap<K, V> onlyInFirst = this.build(split.onlyInFirst());
        MultiMap<K, V> onlyInSecond = this.build(split.onlyInSecond());
        MultiMap<K, V> inBothButDiffering = MultiMap.empty();
        for (P2<K, AVLSet<V>> p2 : split.inBothButDiffering()) {
            K key = p2._1();
            AVLSet<V> values = p2._2().difference(other.map.getOrNull(key));
            inBothButDiffering = inBothButDiffering.add(key, values);
        }
        return ThreeWaySplit.make(onlyInFirst, inBothButDiffering, onlyInSecond);
    }

    public ThreeWaySplit<MultiMap<K, V>> splitWithUnion(MultiMap<K, V> other) {
        ThreeWaySplit<AVLMap<K, AVLSet<V>>> split = this.map.split(other.map);
        MultiMap<K, V> onlyInFirst = this.build(split.onlyInFirst());
        MultiMap<K, V> onlyInSecond = this.build(split.onlyInSecond());
        MultiMap<K, V> inBothButDiffering = MultiMap.empty();
        for (P2<K, AVLSet<V>> p2 : split.inBothButDiffering()) {
            K key = p2._1();
            AVLSet<V> values = p2._2().union(other.map.getOrNull(key));
            inBothButDiffering = inBothButDiffering.add(key, values);
        }
        return ThreeWaySplit.make(onlyInFirst, inBothButDiffering, onlyInSecond);
    }

    public Iterable<K> keys() {
        return this.map.keys();
    }

    public Iterator<P2<K, AVLSet<V>>> iteratorKeyValueSet() {
        return this.map.iterator();
    }

    @Override
    public Iterator<P2<K, V>> iterator() {
        return new Iterator<P2<K, V>>(){
            private final Iterator<P2<K, AVLSet<V>>> mapIterator;
            private Iterator<V> valuesIterator;
            private K currentKey;
            {
                this.mapIterator = MultiMap.this.map.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.mapIterator.hasNext()) {
                    return true;
                }
                return this.valuesIterator != null && this.valuesIterator.hasNext();
            }

            @Override
            public P2<K, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.valuesIterator == null || !this.valuesIterator.hasNext()) {
                    P2 nextElement = this.mapIterator.next();
                    this.currentKey = nextElement._1();
                    AVLSet values = nextElement._2();
                    assert (!values.isEmpty());
                    this.valuesIterator = values.iterator();
                }
                return P2.tuple2(this.currentKey, this.valuesIterator.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove operation not supported with immutable maps.");
            }
        };
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<P2<K, AVLSet<V>>> iterator = this.map.iterator();
        builder.append('{');
        while (iterator.hasNext()) {
            P2<K, AVLSet<V>> element = iterator.next();
            K key = element._1();
            AVLSet<V> values = element._2();
            builder.append((Object)(key == this ? "(this Map)" : key));
            builder.append('=');
            builder.append(values);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }
}

