/*
 * Decompiled with CFR 0.152.
 */
package javalx.persistentcollections;

import java.util.Iterator;
import java.util.Map;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.FiniteMap;

public class BiMap<K, V>
implements Iterable<P2<K, V>> {
    private final AVLMap<K, V> forward;
    private final AVLMap<V, K> backward;

    private BiMap(AVLMap<K, V> forward, AVLMap<V, K> backward) {
        this.forward = forward;
        this.backward = backward;
    }

    private BiMap<K, V> build(AVLMap<K, V> newForward, AVLMap<V, K> newBackward) {
        return new BiMap<K, V>(newForward, newBackward);
    }

    public static <K, V> BiMap<K, V> empty() {
        return new BiMap(AVLMap.empty(), AVLMap.empty());
    }

    public static <K, V> BiMap<K, V> from(Map<K, V> map) {
        BiMap<K, V> newMap = BiMap.empty();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            newMap = newMap.bind(entry.getKey(), entry.getValue());
        }
        return newMap;
    }

    public BiMap<V, K> inverted() {
        return new BiMap<V, K>(this.backward, this.forward);
    }

    public BiMap<K, V> remove(K key) {
        if (!this.forward.contains(key)) {
            return this;
        }
        V value = this.forward.get(key).get();
        assert (this.backward.contains(value));
        return this.remove(key, value);
    }

    public BiMap<K, V> removeValue(V value) {
        if (!this.backward.contains(value)) {
            return this;
        }
        K key = this.backward.get(value).get();
        assert (this.forward.contains(key));
        return this.remove(key, value);
    }

    private BiMap<K, V> remove(K key, V value) {
        FiniteMap newForward = this.forward.remove((Object)key);
        FiniteMap newBackward = this.backward.remove((Object)value);
        return this.build((AVLMap<K, V>)newForward, (AVLMap<V, K>)newBackward);
    }

    public BiMap<K, V> bind(K key, V value) {
        BiMap<K, V> newMap = this;
        newMap = newMap.remove(key);
        newMap = newMap.removeValue(value);
        FiniteMap newForward = newMap.forward.bind((Object)key, (Object)value);
        FiniteMap newBackward = newMap.backward.bind((Object)value, (Object)key);
        return super.build((AVLMap<K, V>)newForward, (AVLMap<V, K>)newBackward);
    }

    public Option<V> get(K key) {
        return this.forward.get(key);
    }

    public Option<K> getKey(V value) {
        return this.backward.get(value);
    }

    public boolean contains(K key) {
        return this.forward.contains(key);
    }

    public boolean containsValue(V value) {
        return this.backward.contains(value);
    }

    public Iterable<K> keys() {
        return this.forward.keys();
    }

    public Iterable<V> values() {
        return this.backward.keys();
    }

    public int size() {
        return this.forward.size();
    }

    public boolean isEmpty() {
        return this.forward.isEmpty();
    }

    @Override
    public Iterator<P2<K, V>> iterator() {
        return this.forward.iterator();
    }

    public String toString() {
        return this.forward.toString();
    }
}

