/*
 * Decompiled with CFR 0.152.
 */
package javalx.persistentcollections;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.fn.Fn;
import javalx.persistentcollections.ThreeWaySplit;
import javalx.persistentcollections.tree.AVLTree;

public class AVLSet<K>
implements Iterable<K> {
    private final AVLTree<K, K> tree;
    private final Fn<P2<K, K>, K> getSecond = new Fn<P2<K, K>, K>(){

        @Override
        public K apply(P2<K, K> p2) {
            return p2._2();
        }
    };
    private final Fn<AVLTree<K, K>, AVLSet<K>> buildSetFromTree = new Fn<AVLTree<K, K>, AVLSet<K>>(){

        @Override
        public AVLSet<K> apply(AVLTree<K, K> tree) {
            return AVLSet.this.build(tree);
        }
    };

    private AVLSet(AVLTree<K, K> tree) {
        this.tree = tree;
    }

    public static <K> AVLSet<K> empty() {
        return new AVLSet(AVLTree.empty());
    }

    public static <K> AVLSet<K> singleton(K element) {
        return AVLSet.empty().add(element);
    }

    public static <K> AVLSet<K> fromIterable(Iterable<K> values) {
        AVLSet<K> s = AVLSet.empty();
        for (K v : values) {
            s = s.add(v);
        }
        return s;
    }

    private AVLSet<K> build(AVLTree<K, K> tree) {
        return new AVLSet<K>(tree);
    }

    public int size() {
        return this.tree.size();
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public boolean contains(K key) {
        return this.tree.get(key).isSome();
    }

    public K get(K key) {
        return this.tree.getOrNull(key);
    }

    public AVLSet<K> add(K key) {
        return this.build((AVLTree<K, K>)this.tree.bind((Object)key, (Object)key));
    }

    public AVLSet<K> remove(K key) {
        return this.build((AVLTree<K, K>)this.tree.remove((Object)key));
    }

    public Option<K> getMin() {
        return this.tree.getMin().fmap(this.getSecond);
    }

    public Option<K> getMax() {
        return this.tree.getMax().fmap(this.getSecond);
    }

    public AVLSet<K> removeMin() {
        return this.build((AVLTree<K, K>)this.tree.removeMin());
    }

    public AVLSet<K> removeMax() {
        return this.build((AVLTree<K, K>)this.tree.removeMax());
    }

    public AVLSet<K> union(AVLSet<K> other) {
        return this.build(this.tree.union(other.tree));
    }

    public AVLSet<K> difference(AVLSet<K> right) {
        return this.build(this.tree.difference(right.tree));
    }

    public AVLSet<K> intersection(AVLSet<K> right) {
        return this.build(this.tree.intersection(right.tree));
    }

    public ThreeWaySplit<AVLSet<K>> split(AVLSet<K> other) {
        return ThreeWaySplit.map(this.tree.split(other.tree), this.buildSetFromTree);
    }

    @Override
    public Iterator<K> iterator() {
        return new Iterator<K>(){
            private final Iterator<P2<K, K>> iterator;
            {
                this.iterator = AVLSet.this.tree.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public K next() {
                return this.iterator.next()._2();
            }

            @Override
            public void remove() {
                AVLSet.this.iterator().remove();
            }
        };
    }

    public String toString() {
        Iterator<K> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        while (iterator.hasNext()) {
            K element = iterator.next();
            builder.append((Object)(element == this ? "(this Set)" : element));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AVLSet)) {
            return false;
        }
        AVLSet other = (AVLSet)obj;
        return this.difference(other).isEmpty() && other.difference(this).isEmpty();
    }

    public <R> AVLSet<R> map(Fn<K, R> fn) {
        AVLSet<R> result = AVLSet.empty();
        for (K element : this) {
            result = result.add(fn.apply(element));
        }
        return result;
    }

    public SortedSet<K> toMutable() {
        TreeSet<K> set = new TreeSet<K>();
        for (K element : this) {
            set.add(element);
        }
        return set;
    }
}

