/*
 * Decompiled with CFR 0.152.
 */
package javalx.numeric;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import javalx.numeric.Bound;

public class BigInt
extends Bound {
    private final BigInteger value;

    private BigInt(BigInteger value) {
        this.value = value;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public static BigInt of(long value) {
        return BigInt.of(BigInteger.valueOf(value));
    }

    public static BigInt of(BigInteger value) {
        return new BigInt(value);
    }

    public static BigInt of(String value, int base) {
        return BigInt.of(new BigInteger(value, base));
    }

    public static BigInt powerOfTwo(int power) {
        return Bound.ONE.shl(power);
    }

    private boolean isInRange(long lowerBound, long upperBound) {
        return BigInteger.valueOf(lowerBound).compareTo(this.value) <= 0 && this.value.compareTo(BigInteger.valueOf(upperBound)) <= 0;
    }

    public int intValue() {
        long min = Integer.MIN_VALUE;
        long max = Integer.MAX_VALUE;
        if (!this.isInRange(min, max)) {
            throw new ArithmeticException("Value " + this.value + " cannot correctly be converted to fit integer range: " + min + ", " + max);
        }
        return this.value.intValue();
    }

    public long longValue() {
        long min = Long.MIN_VALUE;
        long max = Long.MAX_VALUE;
        if (!this.isInRange(min, max)) {
            throw new ArithmeticException("Value " + this.value + " cannot correctly be converted to fit long range: " + min + ", " + max);
        }
        return this.value.longValue();
    }

    public BigInteger bigIntegerValue() {
        return this.value;
    }

    public String toString() {
        return this.toDecimalString();
    }

    public String toBinaryStringSigned(int size) {
        return this.toBinaryString(size, true);
    }

    public String toBinaryStringUnsigned(int size) {
        return this.toBinaryString(size, false);
    }

    private String toBinaryString(int size, boolean signExtend) {
        byte[] internalByteRepresentation;
        StringBuilder builder = new StringBuilder();
        for (byte part : internalByteRepresentation = this.value.toByteArray()) {
            builder.append(BigInt.toBitsString(part));
        }
        if (builder.length() < size) {
            char fillBit = '0';
            if (signExtend && this.sign() == -1) {
                fillBit = builder.charAt(0);
            }
            int paddingLength = size - builder.length();
            for (int i = 0; i < paddingLength; ++i) {
                builder.insert(0, fillBit);
            }
        } else if (builder.length() > size) {
            builder = new StringBuilder(builder.substring(builder.length() - size));
        }
        return builder.toString();
    }

    private static String toBitsString(byte val) {
        StringBuilder builder = new StringBuilder();
        byte mask = 1;
        for (int i = 0; i <= 7; ++i) {
            if ((val & mask) != 0) {
                builder.insert(0, '1');
            } else {
                builder.insert(0, '0');
            }
            mask = (byte)(mask << 1);
        }
        return builder.toString();
    }

    public String toDecimalString() {
        return this.value.toString();
    }

    public String toHexString() {
        return this.value.toString(16);
    }

    public String toStringUsingRadix(int radix) {
        return this.value.toString(radix);
    }

    public boolean isLessThan(BigInt other) {
        return this.value.compareTo(other.value) < 0;
    }

    public boolean isGreaterThan(BigInt other) {
        return this.value.compareTo(other.value) > 0;
    }

    @Override
    public BigInt negate() {
        return BigInt.of(this.value.negate());
    }

    public BigInt sub(long other) {
        return this.sub(BigInt.of(other));
    }

    public BigInt sub(BigInt other) {
        return BigInt.of(this.value.subtract(other.value));
    }

    public BigInt mul(long other) {
        return this.mul(BigInt.of(other));
    }

    public BigInt mul(BigInt other) {
        return BigInt.of(this.value.multiply(other.value));
    }

    public BigInt pow(int exponent) {
        return BigInt.of(this.value.pow(exponent));
    }

    public BigInt pow(BigInt exponent) {
        return BigInt.of(this.value.pow(exponent.intValue()));
    }

    public BigInt div(BigInt other) {
        return this.divRoundZero(other);
    }

    @Override
    public BigInt divRoundUp(BigInt other) {
        BigDecimal a = new BigDecimal(this.value);
        BigDecimal b = new BigDecimal(other.value);
        BigDecimal result = a.divide(b, RoundingMode.CEILING);
        return BigInt.of(result.toBigInteger());
    }

    public BigInt divRoundDown(BigInt other) {
        BigDecimal a = new BigDecimal(this.value);
        BigDecimal b = new BigDecimal(other.value);
        BigDecimal result = a.divide(b, RoundingMode.FLOOR);
        return BigInt.of(result.toBigInteger());
    }

    public BigInt divRoundZero(BigInt other) {
        return BigInt.of(this.value.divide(other.value));
    }

    public BigInt divRoundNearest(BigInt other) {
        BigDecimal a = new BigDecimal(this.value);
        BigDecimal b = new BigDecimal(other.value);
        BigDecimal result = a.divide(b, RoundingMode.HALF_EVEN);
        return BigInt.of(result.toBigInteger());
    }

    public BigInt divRoundNone(BigInt other) {
        BigDecimal a = new BigDecimal(this.value);
        BigDecimal b = new BigDecimal(other.value);
        try {
            BigDecimal result = a.divide(b, RoundingMode.UNNECESSARY);
            return BigInt.of(result.toBigInteger());
        }
        catch (ArithmeticException e) {
            if (other.isZero()) {
                throw e;
            }
            return null;
        }
    }

    public BigInt mod(BigInt other) {
        return BigInt.of(this.value.mod(other.value));
    }

    public BigInt remainder(BigInt other) {
        return BigInt.of(this.value.remainder(other.value));
    }

    public BigInt[] divideAndRemainder(BigInt other) {
        BigInteger[] res = this.value.divideAndRemainder(other.value);
        return new BigInt[]{BigInt.of(res[0]), BigInt.of(res[1])};
    }

    public BigInt gcd(BigInt other) {
        return BigInt.of(this.value.gcd(other.value));
    }

    public BigInt shl(int n) {
        return BigInt.of(this.value.shiftLeft(n));
    }

    public BigInt shl(BigInt n) {
        return BigInt.of(this.value.shiftLeft(n.intValue()));
    }

    public BigInt shr(int n) {
        return BigInt.of(this.value.shiftRight(n));
    }

    public BigInt shr(BigInt n) {
        return BigInt.of(this.value.shiftRight(n.intValue()));
    }

    public BigInt not() {
        return BigInt.of(this.value.not());
    }

    public BigInt and(BigInt other) {
        return BigInt.of(this.value.and(other.value));
    }

    public BigInt or(BigInt other) {
        return BigInt.of(this.value.or(other.value));
    }

    public BigInt xor(BigInt other) {
        return BigInt.of(this.value.xor(other.value));
    }

    public BigInt abs() {
        return BigInt.of(this.value.abs());
    }

    @Override
    public int sign() {
        return this.value.signum();
    }

    public boolean isOne() {
        return this.isEqualTo(Bound.ONE);
    }

    public static BigInt minOr(BigInt a, BigInt b, BigInt c, BigInt d) {
        int bitLength = a.xor((BigInt)c).value.bitLength();
        return BigInt.minOr(a, b, c, d, BigInt.powerOfTwo(bitLength));
    }

    public static BigInt minOr(BigInt a, BigInt b, BigInt c, BigInt d, int size) {
        return BigInt.minOr(a, b, c, d, BigInt.powerOfTwo(size - 1));
    }

    public static BigInt minOr(BigInt a, BigInt b, BigInt c, BigInt d, BigInt m) {
        while (!m.isZero()) {
            BigInt t;
            if (!a.not().and(c).and(m).isZero()) {
                t = a.or(m).and(m.negate());
                if (t.compareTo(b) <= 0) {
                    a = t;
                    break;
                }
            } else if (a.and(c.not()).and(m).compareTo(Bound.ZERO) != 0 && (t = c.or(m).and(m.negate())).compareTo(d) <= 0) {
                c = t;
                break;
            }
            m = m.shr(1);
        }
        return a.or(c);
    }

    public static BigInt maxOr(BigInt a, BigInt b, BigInt c, BigInt d) {
        int bitLength = b.and((BigInt)d).value.bitLength();
        return BigInt.maxOr(a, b, c, d, BigInt.powerOfTwo(bitLength));
    }

    public static BigInt maxOr(BigInt a, BigInt b, BigInt c, BigInt d, int size) {
        return BigInt.maxOr(a, b, c, d, BigInt.powerOfTwo(size - 1));
    }

    public static BigInt maxOr(BigInt a, BigInt b, BigInt c, BigInt d, BigInt m) {
        while (!m.isZero()) {
            if (!b.and(d).and(m).isZero()) {
                BigInt t = b.sub(m).or(m.sub(Bound.ONE));
                if (t.compareTo(a) >= 0) {
                    b = t;
                    break;
                }
                t = d.sub(m).or(m.sub(Bound.ONE));
                if (t.compareTo(c) >= 0) {
                    d = t;
                    break;
                }
            }
            m = m.shr(1);
        }
        return b.or(d);
    }

    public static BigInt minAnd(BigInt a, BigInt b, BigInt c, BigInt d) {
        return BigInt.maxOr(b.not(), a.not(), d.not(), c.not()).not();
    }

    public static BigInt maxAnd(BigInt a, BigInt b, BigInt c, BigInt d) {
        return BigInt.minOr(b.not(), a.not(), d.not(), c.not()).not();
    }

    public static BigInt minXor(BigInt a, BigInt b, BigInt c, BigInt d) {
        int bitLength = a.xor((BigInt)c).value.bitLength();
        return BigInt.minXor(a, b, c, d, BigInt.powerOfTwo(bitLength));
    }

    public static BigInt minXor(BigInt a, BigInt b, BigInt c, BigInt d, int size) {
        return BigInt.minXor(a, b, c, d, BigInt.powerOfTwo(size - 1));
    }

    public static BigInt minXor(BigInt a, BigInt b, BigInt c, BigInt d, BigInt m) {
        while (!m.isZero()) {
            BigInt t;
            if (!a.not().and(c).and(m).isZero()) {
                t = a.or(m).and(m.negate());
                if (t.compareTo(b) <= 0) {
                    a = t;
                }
            } else if (!a.and(c.not()).and(m).isZero() && (t = c.or(m).and(m.negate())).compareTo(d) <= 0) {
                c = t;
            }
            m = m.shr(1);
        }
        return a.xor(c);
    }

    public static BigInt maxXor(BigInt a, BigInt b, BigInt c, BigInt d) {
        int bitLength = b.and((BigInt)d).value.bitLength();
        return BigInt.maxXor(a, b, c, d, BigInt.powerOfTwo(bitLength));
    }

    public static BigInt maxXor(BigInt a, BigInt b, BigInt c, BigInt d, int size) {
        return BigInt.maxXor(a, b, c, d, BigInt.powerOfTwo(size - 1));
    }

    public static BigInt maxXor(BigInt a, BigInt b, BigInt c, BigInt d, BigInt m) {
        while (!m.isZero()) {
            if (!b.and(d).and(m).isZero()) {
                BigInt t = b.sub(m).or(m.sub(Bound.ONE));
                if (t.compareTo(a) >= 0) {
                    b = t;
                } else {
                    t = d.sub(m).or(m.sub(Bound.ONE));
                    if (t.compareTo(c) >= 0) {
                        d = t;
                    }
                }
            }
            m = m.shr(1);
        }
        return b.xor(d);
    }

    @Override
    public BigInt asInteger() {
        return this;
    }

    @Override
    public Bound max(Bound other) {
        return other.max(this);
    }

    @Override
    public BigInt max(BigInt other) {
        return BigInt.of(this.value.max(other.value));
    }

    @Override
    public Bound min(Bound other) {
        return other.min(this);
    }

    @Override
    public BigInt min(BigInt other) {
        return BigInt.of(this.value.min(other.value));
    }

    @Override
    public Bound add(Bound other) {
        return other.add(this);
    }

    @Override
    public BigInt add(BigInt other) {
        return BigInt.of(this.value.add(other.value));
    }

    @Override
    public Bound sub(Bound other) {
        if (other.isFinite()) {
            return this.sub(other.asInteger());
        }
        return this.add(other.negate());
    }

    @Override
    public Bound divRoundDown(Bound other) {
        if (other.isFinite()) {
            return this.divRoundDown(other.asInteger());
        }
        return other.divRoundDown(this);
    }

    @Override
    public Bound divRoundZero(Bound other) {
        if (other.isFinite()) {
            return this.divRoundZero(other.asInteger());
        }
        return other.divRoundDown(this);
    }

    @Override
    public Bound divRoundNearest(Bound other) {
        if (other.isFinite()) {
            return this.divRoundNearest(other.asInteger());
        }
        return other.divRoundDown(this);
    }

    @Override
    public Bound divRoundNone(Bound other) {
        if (other.isFinite()) {
            BigInt result = this.divRoundNone(other.asInteger());
            if (result == null) {
                return null;
            }
            return result;
        }
        return other.divRoundDown(this);
    }

    @Override
    public Bound mul(Bound other) {
        if (other.isFinite()) {
            return this.mul(other.asInteger());
        }
        return other.mul(this);
    }

    @Override
    public Bound shl(Bound other) {
        if (other.isFinite()) {
            return this.shl(other.asInteger());
        }
        return POSINF;
    }

    public boolean isEqualTo(BigInt other) {
        return this.value.equals(other.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(Bound other) {
        return -other.compareTo(this);
    }

    @Override
    public int compareTo(BigInt other) {
        return this.value.compareTo(other.value);
    }
}

