/*
 * Decompiled with CFR 0.152.
 */
package javalx.mutablecollections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.fn.Fn;
import javalx.fn.Predicate;
import javalx.persistentcollections.AVLSet;

public final class CollectionHelpers {
    private CollectionHelpers() {
    }

    public static <T> Iterable<T> toIterable(final Iterator<T> iterator) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    public static <T> Iterable<T> reversedIterable(List<T> list) {
        if (list.size() == 1) {
            return list;
        }
        final ListIterator<T> iterator = list.listIterator(list.size());
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return iterator.previous();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    public static <K, V> Map<V, K> reverseMapping(Map<K, V> map) {
        HashMap<V, K> newMap = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            newMap.put(entry.getValue(), entry.getKey());
        }
        return newMap;
    }

    public static <A> List<? extends A> list(A ... elements) {
        return Arrays.asList(elements);
    }

    public static <A> Set<? extends A> set(A ... elements) {
        return new HashSet<A>(CollectionHelpers.list(elements));
    }

    public static <A> AVLSet<A> filter(AVLSet<A> set, Predicate<A> predicate) {
        AVLSet<A> output = set;
        for (A element : set) {
            if (((Boolean)predicate.apply(element)).booleanValue()) continue;
            output = output.remove(element);
        }
        return output;
    }

    public static <A> Set<A> filter(Set<A> set, Predicate<A> predicate) {
        return CollectionHelpers.filter(set, new HashSet(), predicate);
    }

    public static <A> Collection<A> filter(Collection<A> collection, Predicate<A> predicate) {
        return CollectionHelpers.filter(collection, new ArrayList(), predicate);
    }

    public static <A> List<A> filter(List<A> list, Predicate<A> predicate) {
        return CollectionHelpers.filter(list, new ArrayList(), predicate);
    }

    public static <A> List<A> filter(A[] list, Predicate<A> predicate) {
        return CollectionHelpers.filter(Arrays.asList(list), new ArrayList(), predicate);
    }

    private static <A, C extends Collection<? super A>> C filter(Collection<A> input, C output, Predicate<A> predicate) {
        for (A element : input) {
            if (!((Boolean)predicate.apply(element)).booleanValue()) continue;
            output.add(element);
        }
        return output;
    }

    public static <A, B> Collection<B> map(Collection<A> collection, Fn<A, B> f) {
        return CollectionHelpers.map(collection, new ArrayList(collection.size()), f);
    }

    public static <A, B> List<B> map(List<A> list, Fn<A, B> f) {
        return CollectionHelpers.map(list, new ArrayList(list.size()), f);
    }

    public static <A, B> Set<B> map(Set<A> set, Fn<A, B> f) {
        return CollectionHelpers.map(set, new HashSet(set.size()), f);
    }

    public static <A, B> Iterator<B> map(final Iterator<A> iterator, final Fn<A, B> fun) {
        return new Iterator<B>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public B next() {
                return fun.apply(iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    private static <A, B, C extends Collection<? super B>> C map(Collection<A> input, C output, Fn<A, B> f) {
        for (A element : input) {
            output.add(f.apply(element));
        }
        return output;
    }

    public static <A, B> P2<List<A>, List<B>> split(List<P2<A, B>> list) {
        ArrayList<A> listA = new ArrayList<A>();
        ArrayList<B> listB = new ArrayList<B>();
        for (P2<A, B> tuple : list) {
            listA.add(tuple._1());
            listB.add(tuple._2());
        }
        return new P2<List<A>, List<B>>(listA, listB);
    }

    public static <A, B> List<P2<A, B>> zip(List<A> listA, List<B> listB) {
        if (listA.size() != listB.size()) {
            throw new IllegalArgumentException("The lists are not of equal size.");
        }
        ArrayList<P2<A, B>> list = new ArrayList<P2<A, B>>();
        Iterator<A> iterA = listA.iterator();
        Iterator<B> iterB = listB.iterator();
        while (iterA.hasNext()) {
            P2<A, B> tuple = new P2<A, B>(iterA.next(), iterB.next());
            list.add(tuple);
        }
        return list;
    }

    public static <T> List<T> cast(List<?> list) {
        return list;
    }

    public static <A> boolean all(Collection<A> collection, Predicate<A> predicate) {
        for (A element : collection) {
            if (((Boolean)predicate.apply(element)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static <A> Option<A> find(Collection<A> collection, Predicate<A> predicate) {
        for (A elem : collection) {
            if (!((Boolean)predicate.apply(elem)).booleanValue()) continue;
            return Option.some(elem);
        }
        return Option.none();
    }

    public static <A> boolean exists(Collection<A> collection, Predicate<A> predicate) {
        return CollectionHelpers.find(collection, predicate).isSome();
    }
}

