/*
 * Decompiled with CFR 0.152.
 */
package gdsl.rreil;

import gdsl.rreil.Address;
import gdsl.rreil.BranchHint;
import gdsl.rreil.DefaultLimitedVariableCollection;
import gdsl.rreil.DefaultStatementCollection;
import gdsl.rreil.Flop;
import gdsl.rreil.IAddress;
import gdsl.rreil.IBranchHint;
import gdsl.rreil.IFlop;
import gdsl.rreil.ILimitedVariable;
import gdsl.rreil.IRReilBuilder;
import gdsl.rreil.IRReilCollection;
import gdsl.rreil.IVariable;
import gdsl.rreil.LimitedVariable;
import gdsl.rreil.Variable;
import gdsl.rreil.exception.Exception;
import gdsl.rreil.exception.GenericArchException;
import gdsl.rreil.exception.IException;
import gdsl.rreil.expression.And;
import gdsl.rreil.expression.Compare;
import gdsl.rreil.expression.CompareEqual;
import gdsl.rreil.expression.CompareLessOrEqualSigned;
import gdsl.rreil.expression.CompareLessOrEqualUnsigned;
import gdsl.rreil.expression.CompareLessSigned;
import gdsl.rreil.expression.CompareLessUnsigned;
import gdsl.rreil.expression.CompareNotEqual;
import gdsl.rreil.expression.Division;
import gdsl.rreil.expression.Expression;
import gdsl.rreil.expression.ICompare;
import gdsl.rreil.expression.IExpression;
import gdsl.rreil.expression.Modulo;
import gdsl.rreil.expression.Multiplication;
import gdsl.rreil.expression.Or;
import gdsl.rreil.expression.ShiftLeft;
import gdsl.rreil.expression.ShiftRight;
import gdsl.rreil.expression.ShiftRightSigned;
import gdsl.rreil.expression.SignExtend;
import gdsl.rreil.expression.SignedDivision;
import gdsl.rreil.expression.SignedModulo;
import gdsl.rreil.expression.Simple;
import gdsl.rreil.expression.Xor;
import gdsl.rreil.expression.ZeroExtend;
import gdsl.rreil.id.ArchRegister;
import gdsl.rreil.id.FloatingFlags;
import gdsl.rreil.id.IId;
import gdsl.rreil.id.Id;
import gdsl.rreil.id.VirtualTemporaryId;
import gdsl.rreil.linear.ILinearExpression;
import gdsl.rreil.linear.LinearAdditionExpression;
import gdsl.rreil.linear.LinearExpression;
import gdsl.rreil.linear.LinearImmediateExpression;
import gdsl.rreil.linear.LinearScaleExpression;
import gdsl.rreil.linear.LinearSubtractionExpression;
import gdsl.rreil.linear.LinearVariableExpression;
import gdsl.rreil.sexpression.Arbitrary;
import gdsl.rreil.sexpression.ISimpleExpression;
import gdsl.rreil.sexpression.SimpleCompareExpression;
import gdsl.rreil.sexpression.SimpleExpression;
import gdsl.rreil.sexpression.SimpleLinearExpression;
import gdsl.rreil.statement.AssignStatement;
import gdsl.rreil.statement.BranchStatement;
import gdsl.rreil.statement.ConditionalBranchStatement;
import gdsl.rreil.statement.FlopStatement;
import gdsl.rreil.statement.IStatement;
import gdsl.rreil.statement.IfThenElseStatement;
import gdsl.rreil.statement.LoadStatement;
import gdsl.rreil.statement.PrimitiveStatement;
import gdsl.rreil.statement.Statement;
import gdsl.rreil.statement.StoreStatement;
import gdsl.rreil.statement.ThrowStatement;
import gdsl.rreil.statement.WhileStatement;

public class DefaultRReilBuilder
implements IRReilBuilder {
    @Override
    public IId shared_floating_flags() {
        return new FloatingFlags();
    }

    @Override
    public Id virt_t(long l) {
        return new VirtualTemporaryId(l);
    }

    @Override
    public IId arch(String string) {
        return new ArchRegister(string);
    }

    @Override
    public IException exception_shared_division_by_zero() {
        return Exception.DIVISION_BY_ZERO;
    }

    @Override
    public IException exception_arch(String string) {
        return new GenericArchException(string);
    }

    @Override
    public Address sem_address(long l, ILinearExpression iLinearExpression) {
        return new Address(l, (LinearExpression)iLinearExpression);
    }

    @Override
    public Variable sem_var(IId iId, long l) {
        return new Variable((Id)iId, l);
    }

    @Override
    public LinearExpression sem_lin_var(IVariable iVariable) {
        return new LinearVariableExpression((Variable)iVariable);
    }

    @Override
    public LinearExpression sem_lin_imm(long l) {
        return new LinearImmediateExpression(l);
    }

    @Override
    public LinearExpression sem_lin_add(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new LinearAdditionExpression((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public LinearExpression sem_lin_sub(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new LinearSubtractionExpression((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public LinearExpression sem_lin_scale(long l, ILinearExpression iLinearExpression) {
        return new LinearScaleExpression(l, (LinearExpression)iLinearExpression);
    }

    @Override
    public SimpleLinearExpression sem_sexpr_lin(ILinearExpression iLinearExpression) {
        return new SimpleLinearExpression((LinearExpression)iLinearExpression);
    }

    @Override
    public SimpleCompareExpression sem_sexpr_cmp(long l, ICompare iCompare) {
        return new SimpleCompareExpression(l, (Compare)iCompare);
    }

    @Override
    public SimpleExpression sem_sexpr_arb() {
        return new Arbitrary();
    }

    @Override
    public Compare sem_cmpeq(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new CompareEqual((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Compare sem_cmpneq(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new CompareNotEqual((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Compare sem_cmples(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new CompareLessOrEqualSigned((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Compare sem_cmpleu(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new CompareLessOrEqualUnsigned((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Compare sem_cmplts(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new CompareLessSigned((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Compare sem_cmpltu(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new CompareLessUnsigned((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Expression sem_sexpr(ISimpleExpression iSimpleExpression) {
        return new Simple((SimpleExpression)iSimpleExpression);
    }

    @Override
    public Expression sem_mul(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new Multiplication((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Expression sem_div(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new Division((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Expression sem_divs(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new SignedDivision((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Expression sem_mod(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new Modulo((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Expression sem_mods(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new SignedModulo((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Expression sem_shl(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new ShiftLeft((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Expression sem_shr(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new ShiftRight((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Expression sem_shrs(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new ShiftRightSigned((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Expression sem_and(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new And((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Expression sem_or(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new Or((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Expression sem_xor(ILinearExpression iLinearExpression, ILinearExpression iLinearExpression2) {
        return new Xor((LinearExpression)iLinearExpression, (LinearExpression)iLinearExpression2);
    }

    @Override
    public Expression sem_sx(long l, ILinearExpression iLinearExpression) {
        return new SignExtend(l, (LinearExpression)iLinearExpression);
    }

    @Override
    public Expression sem_zx(long l, ILinearExpression iLinearExpression) {
        return new ZeroExtend(l, (LinearExpression)iLinearExpression);
    }

    @Override
    public ILimitedVariable sem_varl(IId iId, long l, long l2) {
        return new LimitedVariable((Id)iId, l, l2);
    }

    @Override
    public IRReilCollection<ILimitedVariable> sem_varls_next(ILimitedVariable iLimitedVariable, IRReilCollection<ILimitedVariable> iRReilCollection) {
        iRReilCollection.add(iLimitedVariable);
        return iRReilCollection;
    }

    @Override
    public IRReilCollection<ILimitedVariable> sem_varls_init() {
        return new DefaultLimitedVariableCollection();
    }

    @Override
    public IFlop sem_flop_fadd() {
        return Flop.FADD;
    }

    @Override
    public IFlop sem_flop_fsub() {
        return Flop.FSUB;
    }

    @Override
    public IFlop sem_flop_fmul() {
        return Flop.FMUL;
    }

    @Override
    public Statement sem_assign(long l, IVariable iVariable, IExpression iExpression) {
        return new AssignStatement(l, (Variable)iVariable, (Expression)iExpression);
    }

    @Override
    public Statement sem_load(long l, IVariable iVariable, IAddress iAddress) {
        return new LoadStatement(l, (Variable)iVariable, (Address)iAddress);
    }

    @Override
    public Statement sem_store(long l, IAddress iAddress, ILinearExpression iLinearExpression) {
        return new StoreStatement(l, (Address)iAddress, (LinearExpression)iLinearExpression);
    }

    @Override
    public Statement sem_ite(ISimpleExpression iSimpleExpression, IRReilCollection<IStatement> iRReilCollection, IRReilCollection<IStatement> iRReilCollection2) {
        return new IfThenElseStatement((SimpleExpression)iSimpleExpression, (DefaultStatementCollection)iRReilCollection, (DefaultStatementCollection)iRReilCollection2);
    }

    @Override
    public Statement sem_while(ISimpleExpression iSimpleExpression, IRReilCollection<IStatement> iRReilCollection) {
        return new WhileStatement((SimpleExpression)iSimpleExpression, (DefaultStatementCollection)iRReilCollection);
    }

    @Override
    public Statement sem_cbranch(ISimpleExpression iSimpleExpression, IAddress iAddress, IAddress iAddress2) {
        return new ConditionalBranchStatement((SimpleExpression)iSimpleExpression, (Address)iAddress, (Address)iAddress2);
    }

    @Override
    public Statement sem_branch(IBranchHint iBranchHint, IAddress iAddress) {
        return new BranchStatement((BranchHint)iBranchHint, (Address)iAddress);
    }

    @Override
    public Statement sem_flop_stmt(IFlop iFlop, IVariable iVariable, ILimitedVariable iLimitedVariable, IRReilCollection<ILimitedVariable> iRReilCollection) {
        return new FlopStatement((Flop)iFlop, (Variable)iVariable, (LimitedVariable)iLimitedVariable, (DefaultLimitedVariableCollection)iRReilCollection);
    }

    @Override
    public Statement sem_prim(String string, IRReilCollection<ILimitedVariable> iRReilCollection, IRReilCollection<ILimitedVariable> iRReilCollection2) {
        return new PrimitiveStatement(string, (DefaultLimitedVariableCollection)iRReilCollection, (DefaultLimitedVariableCollection)iRReilCollection2);
    }

    @Override
    public Statement sem_throw(IException iException) {
        return new ThrowStatement(iException);
    }

    @Override
    public BranchHint hint_jump() {
        return BranchHint.JUMP;
    }

    @Override
    public BranchHint hint_call() {
        return BranchHint.CALL;
    }

    @Override
    public BranchHint hint_ret() {
        return BranchHint.RET;
    }

    @Override
    public IRReilCollection<IStatement> sem_stmts_next(IStatement iStatement, IRReilCollection<IStatement> iRReilCollection) {
        iRReilCollection.add(iStatement);
        return iRReilCollection;
    }

    @Override
    public IRReilCollection<IStatement> sem_stmts_init() {
        return new DefaultStatementCollection();
    }
}

