/*
 * Decompiled with CFR 0.152.
 */
package gdsl.asm;

import gdsl.asm.Instruction;
import gdsl.asm.annotation.Annotation;
import gdsl.asm.annotation.FunctionAnnotation;
import gdsl.asm.annotation.OperandAnnotation;
import gdsl.asm.annotation.StringAnnotation;
import gdsl.asm.boundary.SizeBoundary;
import gdsl.asm.boundary.SizeOffsetBoundary;
import gdsl.asm.operand.Annotated;
import gdsl.asm.operand.Bounded;
import gdsl.asm.operand.Composite;
import gdsl.asm.operand.Immediate;
import gdsl.asm.operand.Memory;
import gdsl.asm.operand.Operand;
import gdsl.asm.operand.PostOperation;
import gdsl.asm.operand.PreOperation;
import gdsl.asm.operand.Register;
import gdsl.asm.operand.Relative;
import gdsl.asm.operand.Scale;
import gdsl.asm.operand.Sign;
import gdsl.asm.operand.Sum;

public class Visitor {
    public void visit(Instruction instruction) {
        Annotation[] annotationArray = instruction.getAnnotations();
        for (int i = 0; i < annotationArray.length; ++i) {
            annotationArray[i].accept(this);
        }
        Operand[] operandArray = instruction.getOperands();
        for (int i = 0; i < operandArray.length; ++i) {
            operandArray[i].accept(this);
        }
    }

    public void visit(FunctionAnnotation functionAnnotation) {
        Operand[] operandArray = functionAnnotation.getArguments();
        for (int i = 0; i < operandArray.length; ++i) {
            operandArray[i].accept(this);
        }
    }

    public void visit(OperandAnnotation operandAnnotation) {
        operandAnnotation.getOperand().accept(this);
    }

    public void visit(StringAnnotation stringAnnotation) {
    }

    public void visit(SizeBoundary sizeBoundary) {
    }

    public void visit(SizeOffsetBoundary sizeOffsetBoundary) {
    }

    public void visit(Annotated annotated) {
        annotated.getAnnotation().accept(this);
        annotated.getOperand().accept(this);
    }

    public void visit(Bounded bounded) {
        bounded.getBoundary().accept(this);
        bounded.getOperand().accept(this);
    }

    public void visit(Composite composite) {
        Operand[] operandArray = composite.getOperands();
        for (int i = 0; i < operandArray.length; ++i) {
            operandArray[i].accept(this);
        }
    }

    public void visit(Immediate immediate) {
    }

    public void visit(Memory memory) {
        memory.getPointer().accept(this);
    }

    public void visit(PostOperation postOperation) {
        postOperation.getOperand().accept(this);
        postOperation.getExpression().accept(this);
    }

    public void visit(PreOperation preOperation) {
        preOperation.getExpression().accept(this);
        preOperation.getOperand().accept(this);
    }

    public void visit(Register register) {
    }

    public void visit(Relative relative) {
        relative.getOperand().accept(this);
    }

    public void visit(Scale scale) {
        scale.getRhs().accept(this);
    }

    public void visit(Sign sign) {
        sign.getOperand().accept(this);
    }

    public void visit(Sum sum) {
        sum.getLhs().accept(this);
        sum.getRhs().accept(this);
    }
}

