/*
 * Decompiled with CFR 0.152.
 */
package com.jamesmurty.utils;

import com.jamesmurty.utils.NamespaceContextImpl;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.iharder.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLBuilder {
    private Document xmlDocument = null;
    private Node xmlNode = null;
    private static boolean isNamespaceAware = true;

    protected XMLBuilder(Document xmlDocument) {
        this.xmlDocument = xmlDocument;
        this.xmlNode = xmlDocument.getDocumentElement();
    }

    protected XMLBuilder(Node myNode, Node parentNode) {
        this.xmlNode = myNode;
        this.xmlDocument = myNode instanceof Document ? (Document)myNode : myNode.getOwnerDocument();
        if (parentNode != null) {
            parentNode.appendChild(myNode);
        }
    }

    public static XMLBuilder create(String name, String namespaceURI) throws ParserConfigurationException, FactoryConfigurationError {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(isNamespaceAware);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElement = null;
        rootElement = namespaceURI != null && namespaceURI.length() > 0 ? document.createElementNS(namespaceURI, name) : document.createElement(name);
        document.appendChild(rootElement);
        return new XMLBuilder(document);
    }

    public static XMLBuilder create(String name) throws ParserConfigurationException, FactoryConfigurationError {
        return XMLBuilder.create(name, null);
    }

    public static XMLBuilder parse(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(isNamespaceAware);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(inputSource);
        return new XMLBuilder(document);
    }

    public XMLBuilder importXMLBuilder(XMLBuilder builder) {
        this.assertElementHasNoTextNodes(this.xmlNode);
        Node importedNode = this.getDocument().importNode(builder.root().getElement(), true);
        this.xmlNode.appendChild(importedNode);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof XMLBuilder) {
            XMLBuilder other = (XMLBuilder)obj;
            return this.xmlDocument.equals(other.getDocument()) && this.xmlNode.equals(other.getElement());
        }
        return false;
    }

    public Element getElement() {
        if (this.xmlNode instanceof Element) {
            return (Element)this.xmlNode;
        }
        return null;
    }

    public XMLBuilder document() {
        return new XMLBuilder(this.getDocument(), null);
    }

    public XMLBuilder root() {
        return new XMLBuilder(this.getDocument());
    }

    public Document getDocument() {
        return this.xmlDocument;
    }

    public Object xpathQuery(String xpath, QName type, NamespaceContext nsContext) throws XPathExpressionException {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xPath = xpathFactory.newXPath();
        if (nsContext != null) {
            xPath.setNamespaceContext(nsContext);
        }
        XPathExpression xpathExp = xPath.compile(xpath);
        try {
            return xpathExp.evaluate(this.xmlNode, type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Object xpathQuery(String xpath, QName type) throws XPathExpressionException {
        return this.xpathQuery(xpath, type, null);
    }

    public XMLBuilder xpathFind(String xpath, NamespaceContext nsContext) throws XPathExpressionException {
        Node foundNode = (Node)this.xpathQuery(xpath, XPathConstants.NODE, nsContext);
        if (foundNode == null || foundNode.getNodeType() != 1) {
            throw new XPathExpressionException("XPath expression \"" + xpath + "\" does not resolve to an Element in context " + this.xmlNode + ": " + foundNode);
        }
        return new XMLBuilder(foundNode, null);
    }

    public XMLBuilder xpathFind(String xpath) throws XPathExpressionException {
        return this.xpathFind(xpath, null);
    }

    public XMLBuilder element(String name) {
        String prefix = this.getPrefixFromQualifiedName(name);
        String namespaceURI = this.xmlNode.lookupNamespaceURI(prefix);
        return this.element(name, namespaceURI);
    }

    public XMLBuilder elem(String name) {
        return this.element(name);
    }

    public XMLBuilder e(String name) {
        return this.element(name);
    }

    public XMLBuilder element(String name, String namespaceURI) {
        this.assertElementHasNoTextNodes(this.xmlNode);
        return new XMLBuilder(namespaceURI == null ? this.getDocument().createElement(name) : this.getDocument().createElementNS(namespaceURI, name), this.xmlNode);
    }

    public XMLBuilder elementBefore(String name) {
        String prefix = this.getPrefixFromQualifiedName(name);
        String namespaceURI = this.xmlNode.lookupNamespaceURI(prefix);
        return this.elementBefore(name, namespaceURI);
    }

    public XMLBuilder elementBefore(String name, String namespaceURI) {
        Node parentNode = this.xmlNode.getParentNode();
        this.assertElementHasNoTextNodes(parentNode);
        Element newElement = namespaceURI == null ? this.getDocument().createElement(name) : this.getDocument().createElementNS(namespaceURI, name);
        parentNode.insertBefore(newElement, this.xmlNode);
        return new XMLBuilder(newElement, null);
    }

    public XMLBuilder attribute(String name, String value) {
        if (!(this.xmlNode instanceof Element)) {
            throw new RuntimeException("Cannot add an attribute to non-Element underlying node: " + this.xmlNode);
        }
        ((Element)this.xmlNode).setAttribute(name, value);
        return this;
    }

    public XMLBuilder attr(String name, String value) {
        return this.attribute(name, value);
    }

    public XMLBuilder a(String name, String value) {
        return this.attribute(name, value);
    }

    public XMLBuilder text(String value, boolean replaceText) {
        if (value == null) {
            throw new IllegalArgumentException("Illegal null text value");
        }
        if (replaceText) {
            this.xmlNode.setTextContent(value);
        } else {
            this.xmlNode.appendChild(this.getDocument().createTextNode(value));
        }
        return this;
    }

    public XMLBuilder text(String value) {
        return this.text(value, false);
    }

    public XMLBuilder t(String value) {
        return this.text(value);
    }

    public XMLBuilder cdata(String data) {
        this.xmlNode.appendChild(this.getDocument().createCDATASection(data));
        return this;
    }

    public XMLBuilder data(String data) {
        return this.cdata(data);
    }

    public XMLBuilder d(String data) {
        return this.cdata(data);
    }

    public XMLBuilder cdata(byte[] data) {
        this.xmlNode.appendChild(this.getDocument().createCDATASection(Base64.encodeBytes(data)));
        return this;
    }

    public XMLBuilder data(byte[] data) {
        return this.cdata(data);
    }

    public XMLBuilder d(byte[] data) {
        return this.cdata(data);
    }

    public XMLBuilder comment(String comment) {
        this.xmlNode.appendChild(this.getDocument().createComment(comment));
        return this;
    }

    public XMLBuilder cmnt(String comment) {
        return this.comment(comment);
    }

    public XMLBuilder c(String comment) {
        return this.comment(comment);
    }

    public XMLBuilder instruction(String target, String data) {
        this.xmlNode.appendChild(this.getDocument().createProcessingInstruction(target, data));
        return this;
    }

    public XMLBuilder inst(String target, String data) {
        return this.instruction(target, data);
    }

    public XMLBuilder i(String target, String data) {
        return this.instruction(target, data);
    }

    public XMLBuilder insertInstruction(String target, String data) {
        this.getDocument().insertBefore(this.getDocument().createProcessingInstruction(target, data), this.xmlNode);
        return this;
    }

    public XMLBuilder reference(String name) {
        this.xmlNode.appendChild(this.getDocument().createEntityReference(name));
        return this;
    }

    public XMLBuilder ref(String name) {
        return this.reference(name);
    }

    public XMLBuilder r(String name) {
        return this.reference(name);
    }

    public XMLBuilder namespace(String prefix, String namespaceURI) {
        if (!(this.xmlNode instanceof Element)) {
            throw new RuntimeException("Cannot add an attribute to non-Element underlying node: " + this.xmlNode);
        }
        if (prefix != null && prefix.length() > 0) {
            ((Element)this.xmlNode).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespaceURI);
        } else {
            ((Element)this.xmlNode).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceURI);
        }
        return this;
    }

    public XMLBuilder ns(String prefix, String namespaceURI) {
        return this.attribute(prefix, namespaceURI);
    }

    public XMLBuilder namespace(String namespaceURI) {
        this.namespace(null, namespaceURI);
        return this;
    }

    public XMLBuilder ns(String namespaceURI) {
        return this.namespace(namespaceURI);
    }

    public XMLBuilder up(int steps) {
        Node currNode = this.xmlNode;
        for (int stepCount = 0; currNode.getParentNode() != null && stepCount < steps; ++stepCount) {
            currNode = currNode.getParentNode();
        }
        if (currNode instanceof Document) {
            return new XMLBuilder((Document)currNode);
        }
        return new XMLBuilder(currNode, null);
    }

    public XMLBuilder up() {
        return this.up(1);
    }

    protected void assertElementHasNoTextNodes(Node anXmlElement) {
        Node textNode = null;
        NodeList childNodes = anXmlElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (3 != childNodes.item(i).getNodeType()) continue;
            textNode = childNodes.item(i);
            break;
        }
        if (textNode != null) {
            throw new IllegalStateException("Cannot add sub-element to element <" + anXmlElement.getNodeName() + "> that already contains the Text node: " + textNode);
        }
    }

    public void toWriter(boolean wholeDocument, Writer writer, Properties outputProperties) throws TransformerException {
        StreamResult streamResult = new StreamResult(writer);
        DOMSource domSource = null;
        domSource = wholeDocument ? new DOMSource(this.getDocument()) : new DOMSource(this.getElement());
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        if (outputProperties != null) {
            for (Map.Entry<Object, Object> entry : outputProperties.entrySet()) {
                serializer.setOutputProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        serializer.transform(domSource, streamResult);
    }

    public void toWriter(Writer writer, Properties outputProperties) throws TransformerException {
        this.toWriter(true, writer, outputProperties);
    }

    public String asString(Properties outputProperties) throws TransformerException {
        StringWriter writer = new StringWriter();
        this.toWriter(writer, outputProperties);
        return writer.toString();
    }

    public String elementAsString(Properties outputProperties) throws TransformerException {
        StringWriter writer = new StringWriter();
        this.toWriter(false, writer, outputProperties);
        return writer.toString();
    }

    public String asString() throws TransformerException {
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        return this.asString(outputProperties);
    }

    public String elementAsString() throws TransformerException {
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        return this.elementAsString(outputProperties);
    }

    public NamespaceContextImpl buildDocumentNamespaceContext() {
        return new NamespaceContextImpl(this.root().getElement());
    }

    protected String getPrefixFromQualifiedName(String qualifiedName) {
        int colonPos = qualifiedName.indexOf(58);
        if (colonPos > 0) {
            return qualifiedName.substring(0, colonPos);
        }
        return null;
    }
}

