/*
 * Decompiled with CFR 0.152.
 */
package cli;

import bindead.analyses.Analysis;
import bindead.analyses.AnalysisFactory;
import bindead.analyses.algorithms.AnalysisProperties;
import bindead.analyses.algorithms.CallStringAnalysis;
import bindead.debug.DebugHelper;
import bindead.debug.StringHelpers;
import binparse.Binary;
import binparse.BinaryFileFormat;
import binparse.Segment;
import binparse.Symbol;
import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javalx.data.Option;
import rreil.lang.RReilAddr;

public class Bindead {
    public static final String defaultDomainHierarchy = "SegMem Processor Stack -Null Data -Heap Fields -Undef Predicates(F) -SupportSet PointsTo -Disjunction Wrapping DelayedWidening -DelayedWidening(Thresholds) -Phased ThresholdsWidening -Predicates(Z) RedundantAffine -Affine Congruences Intervals -IntervalSets -Apron(Polyhedra) -Apron(Octagons) -Apron(Intervals) ";

    private static Comparator<? super ParameterDescription> getParameterDeclarationOrderComparator(Class<?> parameterDeclaration) {
        final HashMap<Parameter, Integer> indexNumber = new HashMap<Parameter, Integer>();
        int i = 0;
        for (Field field : parameterDeclaration.getDeclaredFields()) {
            Parameter parameterAnnotation = field.getAnnotation(Parameter.class);
            if (parameterAnnotation == null) continue;
            indexNumber.put(parameterAnnotation, i);
            ++i;
        }
        Comparator<ParameterDescription> comparator = new Comparator<ParameterDescription>(){

            @Override
            public int compare(ParameterDescription p0, ParameterDescription p1) {
                if (indexNumber.containsKey(p0.getParameter().getParameter()) && indexNumber.containsKey(p1.getParameter().getParameter())) {
                    Integer p0Index = (Integer)indexNumber.get(p0.getParameter().getParameter());
                    Integer p1Index = (Integer)indexNumber.get(p1.getParameter().getParameter());
                    return p0Index.compareTo(p1Index);
                }
                return p0.getLongestName().compareTo(p1.getLongestName());
            }
        };
        return comparator;
    }

    public static void main(String[] args) {
        ClOptions options = new ClOptions();
        JCommander parser = new JCommander();
        parser.addObject(options);
        parser.setProgramName("bindead");
        parser.setColumnSize(Integer.MAX_VALUE);
        parser.setParameterDescriptionComparator(Bindead.getParameterDeclarationOrderComparator(options.getClass()));
        String usageMessage = Bindead.formatUsageMessage(parser);
        if (args.length == 0) {
            System.err.println(usageMessage);
            System.exit(1);
        }
        try {
            parser.parse(args);
        }
        catch (ParameterException e) {
            System.err.println("Error parsing command line:\n" + e);
            System.err.println(usageMessage);
        }
        if (options.help) {
            System.out.println(usageMessage);
            System.exit(0);
        }
        Bindead.process(usageMessage, options);
    }

    private static String formatUsageMessage(JCommander parser) {
        StringBuilder builder = new StringBuilder();
        parser.usage(builder);
        return builder.toString();
    }

    private static void process(String usageMessage, ClOptions options) {
        if (options.files.isEmpty()) {
            System.err.println("No file specified.");
            System.err.println(usageMessage);
            System.exit(1);
        }
        if (options.files.size() > 1) {
            System.err.println("Specified more than one file:\n" + options.files);
            System.err.println(usageMessage);
            System.exit(1);
        }
        for (String fileName : options.files) {
            Binary file = null;
            try {
                file = BinaryFileFormat.getBinary(fileName);
            }
            catch (IOException e) {
                System.err.println("Error reading file:\n" + fileName + "\n" + e);
                System.exit(1);
            }
            if (file == null) {
                System.err.println("Error reading file:\n" + fileName);
                System.exit(1);
            }
            Bindead.processFile(file, usageMessage, options);
        }
    }

    private static void processFile(Binary file, String usageMessage, ClOptions options) {
        if (options.printDefaultDomains) {
            Bindead.printDefaultDomains();
        }
        if (options.printFileInfo) {
            Bindead.printFileInfo(file);
        }
        if (options.printSections) {
            Bindead.printSections(file);
        }
        if (options.printSymbols) {
            Bindead.printSymbols(file);
        }
        if (options.printDynamicSymbols) {
            Bindead.printDynamicSymbols(file);
        }
        if (options.disassemble) {
            Bindead.disassemble(file, options);
        } else if (options.analyze) {
            Bindead.analyze(file, options);
        }
        System.exit(0);
    }

    private static void printDefaultDomains() {
        System.out.println(defaultDomainHierarchy);
        System.exit(0);
    }

    private static void printSections(Binary file) {
        System.out.println("Sections:");
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        ArrayList<String> header = new ArrayList<String>();
        header.add("Address");
        header.add("Name");
        header.add("Size");
        header.add("Permissions");
        table.add(header);
        for (Segment segment : file.getSegments()) {
            if (!segment.getName().isSome()) continue;
            ArrayList<String> row = new ArrayList<String>();
            row.add(Bindead.toHex(segment.getAddress()));
            if (segment.getName().isSome()) {
                row.add(segment.getName().get());
            } else {
                row.add("<no name>");
            }
            row.add(Long.toString(segment.getSize()));
            row.add(segment.getPermissions().toString());
            table.add(row);
        }
        StringBuilder builder = new StringBuilder();
        StringHelpers.printFormattedTable(table, null, null, true, builder);
        System.out.println(builder.toString());
        System.out.println();
    }

    private static void printSymbols(Binary file) {
        System.out.println("Symbols:");
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        ArrayList<String> header = new ArrayList<String>();
        header.add("Address");
        header.add("Name");
        header.add("Size");
        table.add(header);
        for (Symbol symbol : file.getExportedSymbols()) {
            if (!symbol.getName().isSome()) continue;
            ArrayList<String> row = new ArrayList<String>();
            row.add(Bindead.toHex(symbol.getAddress()));
            row.add(symbol.getName().get());
            row.add(Long.toString(symbol.getSize()));
            table.add(row);
        }
        StringBuilder builder = new StringBuilder();
        StringHelpers.printFormattedTable(table, null, null, true, builder);
        System.out.println(builder.toString());
        System.out.println();
    }

    private static void printDynamicSymbols(Binary file) {
        System.out.println("Dynamic Symbols:");
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        ArrayList<String> header = new ArrayList<String>();
        header.add("Address");
        header.add("Name");
        header.add("Size");
        table.add(header);
        for (Symbol symbol : file.getImportedSymbols()) {
            if (!symbol.getName().isSome()) continue;
            ArrayList<String> row = new ArrayList<String>();
            row.add(Bindead.toHex(symbol.getAddress()));
            row.add(symbol.getName().get());
            row.add(Long.toString(symbol.getSize()));
            table.add(row);
        }
        StringBuilder builder = new StringBuilder();
        StringHelpers.printFormattedTable(table, null, null, true, builder);
        System.out.println(builder.toString());
        System.out.println();
    }

    private static String toHex(long address) {
        return RReilAddr.valueOf(address).toShortStringWithHexPrefix();
    }

    private static void printFileInfo(Binary file) {
        System.out.println("Architecture name: " + file.getArchitectureName());
        System.out.println("Architecture size: " + file.getArchitectureSize() + " bit");
        System.out.println("Endianness: " + (Object)((Object)file.getEndianness()));
        System.out.println("Format: " + (Object)((Object)file.getFileFormat()));
        System.out.println("Type: " + (Object)((Object)file.getType()));
        System.out.println("Entry point: " + Bindead.toHex(file.getEntryAddress()));
        Option<Symbol> main = file.getMainFunction();
        if (main.isSome()) {
            System.out.println("Main function: " + main.get().getNameOrAddress() + " @ " + Bindead.toHex(main.get().getAddress()));
        }
        System.out.println("Debug Info: " + file.hasDebugInformation());
        System.out.println();
    }

    private static void analyze(Binary file, ClOptions options) {
        Analysis<?> analyzer;
        Bindead.commonSetup(options);
        AnalysisFactory.AnalysisDebugHooks debugger = null;
        if (options.debug >= 2) {
            debugger = DebugHelper.printers.domainDump();
            DebugHelper.analysisKnobs.printMemVarOnly();
            DebugHelper.analysisKnobs.printCompactDomain();
        }
        if (options.debug >= 3) {
            DebugHelper.analysisKnobs.printFullDomain();
        }
        if (options.debug >= 4) {
            DebugHelper.analysisKnobs.printMemVarAndNumVar();
        }
        if (options.analysisSummary) {
            DebugHelper.analysisKnobs.printSummary();
        }
        String domainHierarchy = defaultDomainHierarchy;
        if (options.abstractDomains != null && !options.abstractDomains.isEmpty()) {
            domainHierarchy = "";
            for (String domain : options.abstractDomains) {
                domainHierarchy = domainHierarchy + " " + domain;
            }
        }
        AnalysisFactory factory = new AnalysisFactory(domainHierarchy);
        if (options.interprocAnalyzer.toLowerCase().equals("callstring")) {
            analyzer = factory.getCallstringAnalysis(file);
        } else if (options.interprocAnalyzer.toLowerCase().equals("summarization")) {
            analyzer = factory.getFixpointAnalysis(file);
        } else {
            throw new ParameterException("Unimplemented functionality for parameter:" + options.interprocAnalyzer);
        }
        analyzer.setDebugHooks(debugger);
        RReilAddr startAddress = Bindead.getStartPoint(file, options);
        if (analyzer instanceof CallStringAnalysis) {
            ((CallStringAnalysis)analyzer).runFrom(startAddress, options.callstringLength);
        } else {
            analyzer.runFrom(startAddress);
        }
    }

    private static void disassemble(Binary file, ClOptions options) {
        Bindead.commonSetup(options);
        AnalysisProperties.INSTANCE.skipDisassembleErrors.setValue(true);
        AnalysisProperties.INSTANCE.ignoreNonExistentJumpTargets.setValue(true);
        AnalysisFactory factory = new AnalysisFactory(defaultDomainHierarchy);
        Analysis<?> disassembler = factory.getRecursiveDisassembler(file);
        RReilAddr startAddress = Bindead.getStartPoint(file, options);
        disassembler.runFrom(startAddress);
    }

    private static RReilAddr getStartPoint(Binary file, ClOptions options) {
        if (options.startPoint != null && !options.startPoint.isEmpty()) {
            Option<Symbol> symbol = file.getSymbol(options.startPoint);
            if (symbol.isSome()) {
                return RReilAddr.valueOf(symbol.get().getAddress());
            }
            if (options.startPoint.startsWith("0x")) {
                try {
                    Long.parseLong(options.startPoint.substring(2), 16);
                }
                catch (NumberFormatException e) {
                    throw new ParameterException("Could not find or parse startpoint: " + options.startPoint);
                }
            } else {
                throw new ParameterException("Could not find or parse startpoint: " + options.startPoint);
            }
        }
        RReilAddr startAddress = AnalysisFactory.getStartAddress(file);
        return startAddress;
    }

    private static void commonSetup(ClOptions options) {
        if (options.debug >= 1) {
            DebugHelper.analysisKnobs.printInstructions();
        }
        if (options.disFrontend.toLowerCase().equals("gdsl")) {
            AnalysisProperties.INSTANCE.useGDSLDisassembler.setValue(true);
            if (options.optimizeRREIL) {
                AnalysisProperties.INSTANCE.disassembleBlockWise.setValue(true);
            }
        } else if (options.disFrontend.toLowerCase().equals("builtin")) {
            AnalysisProperties.INSTANCE.useGDSLDisassembler.setValue(false);
        } else {
            throw new ParameterException("Unimplemented functionality for parameter:" + options.disFrontend);
        }
        if (options.printRReilCode) {
            DebugHelper.analysisKnobs.printRReilCodeListing();
        }
        if (options.printNativeCode) {
            DebugHelper.analysisKnobs.printNativeCodeListing();
        }
        if (options.printWarnings) {
            DebugHelper.analysisKnobs.printWarnings();
        }
    }

    @Parameters(separators="=")
    private static class ClOptions {
        @Parameter(description="file")
        private final List<String> files = new ArrayList<String>();
        @Parameter(names={"-h", "--help"}, help=true, description="Print the usage description of the tool.")
        private boolean help = false;
        @Parameter(names={"-s", "--start-point"}, description="Choose the start point of the disassembly/analysis. Can be either the name of a symbol or an address in hexadecimal with prefix \"0x\"")
        private String startPoint;
        @Parameter(names={"-d", "--disassemble"}, description="Disassemble but do not analyze the binary. Performs a recursive descent disassembly, following jump targets that can statically be resolved, that is, without a value analysis.")
        private boolean disassemble = false;
        @Parameter(names={"-a", "--analyze"}, description="Disassemble and analyze the binary. Performs a recursive descent disassembly, following jump targets inferred by the value analysis.")
        private boolean analyze = false;
        @Parameter(names={"-ss", "--analysis-summary"}, description="Print a summary of the analysis results.")
        private boolean analysisSummary = true;
        @Parameter(names={"-sr", "--show-rreil-code"}, description="Print the disassembled RREIL code.")
        private boolean printRReilCode = false;
        @Parameter(names={"-sn", "--show-native-code"}, description="Print the disassembled native code.")
        private boolean printNativeCode = true;
        @Parameter(names={"-sw", "--show-warnings"}, description="Print the warning messages in detail.")
        private boolean printWarnings = false;
        @Parameter(names={"-i", "--file-info"}, description="Display info about the binary.")
        private boolean printFileInfo = false;
        @Parameter(names={"-sym", "--show-symbols"}, description="Display the symbols in the binary.")
        private boolean printSymbols = false;
        @Parameter(names={"-dyn", "--show-dynamic-symbols"}, description="Display the dynamic symbols in the binary.")
        private boolean printDynamicSymbols = false;
        @Parameter(names={"-sec", "--show-sections"}, description="Display the sections in the binary.")
        private boolean printSections = false;
        @Parameter(names={"-df", "--diss-frontend"}, description="Choose the disassembler frontend. Can be the \"builtin\" Java disassembler or the newer GDSL disassembler (requires native libraries).", validateWith=DisFrontendValidator.class)
        private String disFrontend = "builtin";
        @Parameter(names={"-or", "--optimize-rreil"}, description="Optimize the RREIL code produced during thedisassembly process (requires the GDSL frontend). Optimizations to RREIL will result in less RREIL code that needs to be analyzed.")
        private boolean optimizeRREIL = false;
        @Parameter(names={"-ai", "--analyzer-interprocedural"}, description="Choose the interprocedural analyzer mode. Can be either \"callstring\" or \"summarization\".", validateWith=InterproceduralAnalyzerValidator.class)
        private String interprocAnalyzer = "callstring";
        @Parameter(names={"-cs", "--callstring-length"}, description="Maximum length of the callstring in interprocedural analyses.", validateWith=PositiveIntegerValidator.class)
        private Integer callstringLength = 5;
        @Parameter(names={"--debug"}, description="Show debug output of the disassembler/analyzer.\nThe output levels are:\n0:\t none\n1:\t print processed instruction\n2:\t print (a compact) analysis state at each instruction\n3:\t print (a full) analysis state at each instruction\n4:\t print (a full) analysis state (with internal variable ids) at each instruction", validateWith=PositiveIntegerValidator.class)
        private Integer debug = 0;
        @Parameter(names={"-pad", "--print-default-abstract-domains"}, description="Print the default abstract domain hierarchy used by the analyzer. Note that a '-' in front of a domain name means that the domain is disabled and 'Apron' domains require the native library.")
        private boolean printDefaultDomains = false;
        @Parameter(names={"-ad", "--abstract-domains"}, description="A list of abstract domains to be used in the analysis (see --print-default-abstract-domains for a list of available domains). Note that a '-' in front of a domain name means that the domain is disabled.", variableArity=true)
        private List<String> abstractDomains;

        private ClOptions() {
        }

        public static class PositiveIntegerValidator
        implements IParameterValidator {
            @Override
            public void validate(String name, String value) throws ParameterException {
                int n = Integer.parseInt(value);
                if (n < 0) {
                    throw new ParameterException("Parameter " + name + " should be positive (found " + value + ")");
                }
            }
        }

        public static class InterproceduralAnalyzerValidator
        implements IParameterValidator {
            @Override
            public void validate(String name, String value) throws ParameterException {
                if (!value.equals("callstring") && !value.equals("sumarization")) {
                    throw new ParameterException("Parameter " + name + " must be one of {callstring, sumarization} but was " + value + ".");
                }
            }
        }

        public static class DisFrontendValidator
        implements IParameterValidator {
            @Override
            public void validate(String name, String value) throws ParameterException {
                if (!value.equals("gdsl") && !value.equals("builtin")) {
                    throw new ParameterException("Parameter " + name + " must be one of {builtin, gdsl} but was " + value + ".");
                }
            }
        }
    }
}

