/*
 * Decompiled with CFR 0.152.
 */
package binparse.pe;

import binparse.AbstractBinary;
import binparse.Binary;
import binparse.BinaryFactory;
import binparse.BinaryFileFormat;
import binparse.BinaryType;
import binparse.Endianness;
import binparse.Permission;
import binparse.SegmentImpl;
import binparse.Symbol;
import binparse.UncheckedIOException;
import binparse.pe.PESymbol;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javalx.data.Option;
import javalx.numeric.FiniteRange;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.PE;

public class PEBinary
extends AbstractBinary {
    private final PE pe;
    private static final Map<String, String> cpuTranslation = new HashMap<String, String>();
    private static final Map<String, Integer> architectureSizeTranslation = new HashMap<String, Integer>();
    private static final BinaryFactory factory;

    public PEBinary(PE file) {
        this.pe = file;
    }

    public PEBinary(String file) throws IOException {
        this(new PE(file));
    }

    public static BinaryFactory getFactory() {
        return factory;
    }

    @Override
    public Option<File> getFile() {
        return Option.some(new File(this.pe.getFilename()));
    }

    @Override
    public String getFileName() {
        return new File(this.pe.getFilename()).getName();
    }

    @Override
    public String getArchitectureName() {
        try {
            return cpuTranslation.get(this.pe.getAttribute().getCPU());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Endianness getEndianness() {
        Endianness endianness;
        try {
            endianness = this.pe.getAttribute().isLittleEndian() ? Endianness.LITTLE : Endianness.BIG;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return endianness;
    }

    @Override
    public BinaryType getType() {
        try {
            return BinaryType.values()[this.pe.getAttribute().getType() - 1];
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public BinaryFileFormat getFileFormat() {
        return BinaryFileFormat.PE;
    }

    @Override
    public long getEntryAddress() {
        return (long)this.pe.getOptionalHeader().entry + (long)this.pe.getNTOptionalHeader().ImageBase;
    }

    @Override
    public Option<Symbol> getMainFunction() {
        return this.getSymbol("_main");
    }

    @Override
    public boolean hasDebugInformation() {
        try {
            return this.pe.getAttribute().hasDebug();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int getArchitectureSize() {
        return architectureSizeTranslation.get(this.getArchitectureName());
    }

    @Override
    protected void initSegments() {
        int IMAGE_SCN_MEM_EXECUTE = 0x20000000;
        int IMAGE_SCN_MEM_READ = 0x40000000;
        int IMAGE_SCN_MEM_WRITE = Integer.MIN_VALUE;
        ArrayList<SegmentImpl> segments = new ArrayList<SegmentImpl>();
        try {
            for (Coff.SectionHeader peSection : this.pe.getSectionHeaders()) {
                String name = new String(peSection.s_name).trim();
                long address = peSection.s_vaddr + this.pe.getNTOptionalHeader().ImageBase;
                long size = peSection.s_size;
                byte[] data = peSection.getRawData();
                EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
                if ((peSection.s_flags & IMAGE_SCN_MEM_READ) != 0) {
                    permissions.add(Permission.Read);
                }
                if ((peSection.s_flags & IMAGE_SCN_MEM_EXECUTE) != 0) {
                    permissions.add(Permission.Execute);
                }
                if ((peSection.s_flags & IMAGE_SCN_MEM_WRITE) != 0) {
                    permissions.add(Permission.Write);
                }
                SegmentImpl segment = new SegmentImpl(this.getFileName(), name, address, size, data, this.getEndianness(), permissions);
                segments.add(segment);
                this.segmentNames.put(name, segment);
                this.segmentAddresses = this.segmentAddresses.bind(FiniteRange.of(address, address + segment.getSize() - 1L), segment);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.segments = segments;
    }

    @Override
    protected void initExportedSymbols() {
        byte STORAGE_CLASS_EXTERNAL = 2;
        ArrayList<PESymbol> symbols = new ArrayList<PESymbol>();
        try {
            Coff.Symbol[] peSymbols = this.pe.getSymbols();
            for (int i = 0; i < peSymbols.length; ++i) {
                Coff.Symbol peSymbol = peSymbols[i];
                if (peSymbol.n_sclass != STORAGE_CLASS_EXTERNAL || !peSymbol.isFunction() || peSymbol.n_scnum <= 0) continue;
                String name = peSymbol.getName(this.pe.getStringTable());
                long address = peSymbol.n_value;
                long size = 0L;
                if (peSymbol.n_numaux == 1) {
                    peSymbol = peSymbols[++i];
                    size = ByteBuffer.wrap(peSymbol._n_name, 4, 4).getInt();
                }
                byte[] data = new byte[]{};
                PESymbol symbol = new PESymbol(name, address, size, data);
                symbols.add(symbol);
                this.symbolNames.put(name, symbol);
                this.symbolAddresses.put(address, symbol);
            }
            this.exportedSymbols = symbols;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void initImportedSymbols() {
        this.importedSymbols = new ArrayList();
    }

    public String toString() {
        return this.pe.getFilename();
    }

    static {
        cpuTranslation.put("x86", "x86-32");
        cpuTranslation.put("amd64", "x86-64");
        architectureSizeTranslation.put("x86-32", 32);
        architectureSizeTranslation.put("x86-64", 64);
        factory = new BinaryFactory(){

            @Override
            public Binary getBinary(String path) throws IOException {
                return new PEBinary(path);
            }
        };
    }
}

