/*
 * Decompiled with CFR 0.152.
 */
package binparse.elf;

import binparse.AbstractBinary;
import binparse.Binary;
import binparse.BinaryFactory;
import binparse.BinaryFileFormat;
import binparse.BinaryType;
import binparse.Endianness;
import binparse.Permission;
import binparse.Segment;
import binparse.SegmentImpl;
import binparse.Symbol;
import binparse.UncheckedIOException;
import binparse.elf.ElfSymbol;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javalx.data.Option;
import javalx.numeric.FiniteRange;
import org.eclipse.cdt.utils.elf.Elf;

public class ElfBinary
extends AbstractBinary {
    private final Elf elf;
    private static final Map<String, String> cpuTranslation = new HashMap<String, String>();
    private static final BinaryFactory factory;

    public ElfBinary(Elf file) {
        this.elf = file;
    }

    public ElfBinary(String file) throws IOException {
        this(new Elf(file));
    }

    public static BinaryFactory getFactory() {
        return factory;
    }

    @Override
    public Option<File> getFile() {
        return Option.some(new File(this.elf.getFilename()));
    }

    @Override
    public String getFileName() {
        return new File(this.elf.getFilename()).getName();
    }

    @Override
    public String getArchitectureName() {
        try {
            return cpuTranslation.get(this.elf.getAttributes().getCPU());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Endianness getEndianness() {
        Endianness endianness;
        try {
            endianness = this.elf.getAttributes().isLittleEndian() ? Endianness.LITTLE : Endianness.BIG;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return endianness;
    }

    @Override
    public int getArchitectureSize() {
        try {
            switch (this.elf.getELFhdr().e_ident[4]) {
                case 1: {
                    return 32;
                }
                case 2: {
                    return 64;
                }
            }
            return 0;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public BinaryType getType() {
        try {
            return BinaryType.values()[this.elf.getAttributes().getType() - 1];
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public BinaryFileFormat getFileFormat() {
        return BinaryFileFormat.ELF;
    }

    @Override
    public long getEntryAddress() {
        try {
            return this.elf.getELFhdr().e_entry.getValue().longValue();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Option<Symbol> getMainFunction() {
        return this.getSymbol("main");
    }

    @Override
    public boolean hasDebugInformation() {
        try {
            return this.elf.getAttributes().hasDebug();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void initExportedSymbols() {
        try {
            this.elf.loadSymbols();
            ArrayList<ElfSymbol> symbols = new ArrayList<ElfSymbol>();
            for (Elf.Symbol elfSymbol : this.elf.getSymtabSymbols()) {
                String name = elfSymbol.toString();
                long address = elfSymbol.st_value.getValue().longValue();
                long size = elfSymbol.st_size;
                byte[] data = null;
                try {
                    data = elfSymbol.loadSymbolData();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    data = new byte[]{};
                }
                ElfSymbol.Type type = ElfSymbol.Type.values()[elfSymbol.st_type()];
                ElfSymbol.BindingType bindingType = ElfSymbol.BindingType.values()[elfSymbol.st_bind()];
                ElfSymbol symbol = new ElfSymbol(name, address, size, data, type, bindingType);
                if (!ElfBinary.isUseful(symbol)) continue;
                symbols.add(symbol);
                this.symbolNames.put(name, symbol);
                this.symbolAddresses.put(address, symbol);
            }
            this.exportedSymbols = symbols;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void initImportedSymbols() {
        try {
            this.elf.loadSymbols();
            ArrayList<Symbol> symtabSymbols = new ArrayList<Symbol>();
            for (Elf.Symbol elfSymbol : this.elf.getDynamicSymbols()) {
                String name = elfSymbol.toString();
                long address = elfSymbol.st_value.getValue().longValue();
                long size = elfSymbol.st_size;
                byte[] data = null;
                try {
                    data = elfSymbol.loadSymbolData();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    data = new byte[]{};
                }
                ElfSymbol.Type type = ElfSymbol.Type.values()[elfSymbol.st_type()];
                ElfSymbol.BindingType bindingType = ElfSymbol.BindingType.values()[elfSymbol.st_bind()];
                ElfSymbol symbol = new ElfSymbol(name, address, size, data, type, bindingType);
                symtabSymbols.add(symbol);
            }
            ArrayList<Symbol> symbols = new ArrayList<Symbol>();
            for (Symbol symbol : this.getPLTSymbols(symtabSymbols)) {
                if (!ElfBinary.isUseful((ElfSymbol)symbol)) continue;
                symbols.add(symbol);
                this.symbolNames.put(symbol.getNameOrAddress(), symbol);
                this.symbolAddresses.put(symbol.getAddress(), symbol);
            }
            this.importedSymbols = symbols;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static boolean isUseful(ElfSymbol symbol) {
        if (!symbol.getType().equals((Object)ElfSymbol.Type.Function)) {
            return false;
        }
        if (symbol.getAddress() == 0L) {
            return false;
        }
        return !symbol.getName().isNone();
    }

    @Override
    protected void initSegments() {
        ArrayList<SegmentImpl> segments = new ArrayList<SegmentImpl>();
        try {
            for (Elf.Section elfSection : this.elf.getSections()) {
                if ((elfSection.sh_flags & 2L) == 0L || (elfSection.sh_flags & 0x400L) != 0L) continue;
                String name = elfSection.toString();
                long address = elfSection.sh_addr.getValue().longValue();
                long size = elfSection.sh_size;
                byte[] data = elfSection.loadSectionData();
                EnumSet<Permission> permissions = EnumSet.of(Permission.Read);
                if ((elfSection.sh_flags & 4L) != 0L) {
                    permissions.add(Permission.Execute);
                }
                if ((elfSection.sh_flags & 1L) != 0L) {
                    permissions.add(Permission.Write);
                }
                SegmentImpl segment = new SegmentImpl(this.getFileName(), name, address, size, data, this.getEndianness(), permissions);
                segments.add(segment);
                this.segmentNames.put(name, segment);
                this.segmentAddresses = this.segmentAddresses.bind(FiniteRange.of(address, address + segment.getSize() - 1L), segment);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.segments = segments;
    }

    public String toString() {
        return this.elf.getFilename();
    }

    private Option<Segment> getPLTRelocationSection() throws IOException {
        int DT_JMPREL = 23;
        Elf.Section dynamicSection = this.elf.getSectionByName(".dynamic");
        if (dynamicSection != null) {
            Elf.Dynamic[] dynamics;
            for (Elf.Dynamic dynamicEntry : dynamics = this.elf.getDynamicSections(dynamicSection)) {
                if (dynamicEntry.d_tag != (long)DT_JMPREL) continue;
                long pltRelocationSectionAddress = dynamicEntry.d_val;
                return this.getSegment(pltRelocationSectionAddress);
            }
        }
        return Option.none();
    }

    private List<Symbol> getPLTSymbols(List<Symbol> dynamicSymbols) throws IOException {
        String gotPltName = ".got.plt";
        Option<Segment> got = this.getSegment(gotPltName);
        if (got.isNone()) {
            return Collections.emptyList();
        }
        Option<Segment> relaSection = this.getPLTRelocationSection();
        if (relaSection.isNone()) {
            return Collections.emptyList();
        }
        long gotAddress = got.get().getAddress();
        Elf.Section gotSection = this.elf.getSectionByName(gotPltName);
        Elf.Section pltRelocationsSection = this.elf.getSectionByName(relaSection.get().getName().get());
        List<Elf.Rela_Relocation> relocations = this.elf.getPLTRelocations(pltRelocationsSection);
        ArrayList<Symbol> updatedDynamicSymbols = new ArrayList<Symbol>();
        for (Elf.Rela_Relocation relocationEntry : relocations) {
            if (relocationEntry.relocationType != 7) continue;
            ElfSymbol dynamicSymbol = (ElfSymbol)dynamicSymbols.get(relocationEntry.symbolTableIndex - 1);
            long addressInGOT = relocationEntry.r_offset;
            long offsetInGOT = addressInGOT - gotAddress;
            long symbolPltTrampolineAddress = gotSection.readChunkAtOffset(offsetInGOT) - 6L;
            String adjustedName = null;
            if (dynamicSymbol.getName().isSome()) {
                adjustedName = dynamicSymbol.getName().get() + "@plt";
            }
            ElfSymbol updatedDynamicSymbol = new ElfSymbol(adjustedName, symbolPltTrampolineAddress, dynamicSymbol.getSize(), dynamicSymbol.getData(), dynamicSymbol.getType(), dynamicSymbol.getBindingType());
            updatedDynamicSymbols.add(updatedDynamicSymbol);
        }
        return updatedDynamicSymbols;
    }

    static {
        cpuTranslation.put("x86", "x86-32");
        cpuTranslation.put("x86_64", "x86-64");
        factory = new BinaryFactory(){

            @Override
            public Binary getBinary(String path) throws IOException {
                return new ElfBinary(path);
            }
        };
    }
}

