/*
 * Decompiled with CFR 0.152.
 */
package binparse;

import binparse.Endianness;
import binparse.Permission;
import binparse.Segment;
import java.util.Set;
import javalx.data.Option;

public class SegmentImpl
implements Segment {
    private final String name;
    private final String fileName;
    private final long address;
    private final long size;
    private final byte[] data;
    private final Endianness endianness;
    private final Set<Permission> permissions;

    public SegmentImpl(String fileName, String name, long address, long size, byte[] data, Endianness endianness, Set<Permission> permissions) {
        this.name = name == null || name.isEmpty() ? null : name;
        this.fileName = fileName == null || fileName.isEmpty() ? null : fileName;
        this.address = address;
        this.size = size;
        this.data = data;
        this.endianness = endianness;
        this.permissions = permissions;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public Option<String> getName() {
        return Option.fromNullable(this.name);
    }

    @Override
    public String getNameOrAddress() {
        if (this.name == null) {
            return String.format("(unnamed)@0x%08X", this.address);
        }
        return this.name;
    }

    @Override
    public Option<String> getFileName() {
        return Option.fromNullable(this.fileName);
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public Endianness getEndianness() {
        return this.endianness;
    }

    @Override
    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getNameOrAddress());
        builder.append("(");
        builder.append("[" + Permission.unixStylePrettyPrint(this.permissions) + "]");
        builder.append(" ");
        builder.append(String.format("0x%x", this.address));
        builder.append("-");
        builder.append(String.format("0x%x", this.address + this.size));
        builder.append(")");
        return builder.toString();
    }
}

