/*
 * Decompiled with CFR 0.152.
 */
package binparse;

import binparse.Binary;
import binparse.Symbol;
import javalx.data.Option;

public abstract class AbstractSymbol
implements Symbol {
    protected final String name;
    protected final long address;
    protected final long size;
    protected final byte[] data;

    public AbstractSymbol(String name, long address, long size, byte[] data) {
        this.name = name == null || name.isEmpty() ? null : name;
        this.address = address;
        this.size = size;
        this.data = data;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public Option<String> getName() {
        return Option.fromNullable(this.name);
    }

    @Override
    public String getNameOrAddress() {
        if (this.name == null) {
            return AbstractSymbol.getUnnamedSymbolFor(this.address);
        }
        return this.name;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public static String getNameFor(long address, Binary file) {
        if (file == null) {
            return AbstractSymbol.getUnnamedSymbolFor(address);
        }
        Option<Symbol> symbol = file.getSymbol(address);
        if (symbol.isSome()) {
            return symbol.get().getNameOrAddress();
        }
        return AbstractSymbol.getUnnamedSymbolFor(address);
    }

    private static String getUnnamedSymbolFor(long address) {
        return String.format("(unnamed)@0x%08X", address);
    }

    public String toString() {
        return this.getNameOrAddress();
    }
}

