/*
 * Decompiled with CFR 0.152.
 */
package binparse;

import binparse.Binary;
import binparse.Segment;
import binparse.Symbol;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.FiniteRange;
import javalx.persistentcollections.tree.FiniteRangeTree;
import javalx.persistentcollections.tree.OverlappingRanges;

public abstract class AbstractBinary
implements Binary {
    private static final Logger logger = Logger.getLogger(AbstractBinary.class.getName());
    public static final String x86_32 = "x86-32";
    public static final String x86_64 = "x86-64";
    protected List<Symbol> importedSymbols;
    protected List<Symbol> exportedSymbols;
    protected List<Segment> segments;
    protected FiniteRangeTree<Segment> segmentAddresses = FiniteRangeTree.empty();
    protected final Map<String, Segment> segmentNames = new HashMap<String, Segment>();
    protected final Map<Long, Symbol> symbolAddresses = new HashMap<Long, Symbol>();
    protected final Map<String, Symbol> symbolNames = new HashMap<String, Symbol>();

    @Override
    public List<Segment> getSegments() {
        if (this.segments == null) {
            this.initSegments();
        }
        return this.segments;
    }

    @Override
    public Option<Segment> getSegment(String name) {
        if (this.segments == null) {
            this.initSegments();
        }
        return Option.fromNullable(this.segmentNames.get(name));
    }

    @Override
    public Option<Symbol> getSymbol(String name) {
        if (this.exportedSymbols == null) {
            this.initExportedSymbols();
        }
        if (this.importedSymbols == null) {
            this.initImportedSymbols();
        }
        return Option.fromNullable(this.symbolNames.get(name));
    }

    @Override
    public Option<Symbol> getSymbol(long address) {
        if (this.exportedSymbols == null) {
            this.initExportedSymbols();
        }
        if (this.importedSymbols == null) {
            this.initImportedSymbols();
        }
        return Option.fromNullable(this.symbolAddresses.get(address));
    }

    @Override
    public Segment getSegment(Symbol symbol) {
        return this.getSegment(symbol.getAddress()).getOrNull();
    }

    @Override
    public Option<Segment> getSegment(long address) {
        OverlappingRanges<Segment> overlappings;
        if (this.segments == null) {
            this.initSegments();
        }
        if ((overlappings = this.segmentAddresses.searchOverlaps(FiniteRange.of(address))).isEmpty()) {
            return Option.none();
        }
        if (overlappings.size() != 1) {
            for (P2<FiniteRange, Segment> p2 : overlappings) {
                if (!p2._2().getNameOrAddress().equals(".text")) continue;
                logger.log(Level.WARNING, "The binary \"" + this.getFileName() + "\" contains more than one section for the address: " + Long.toHexString(address) + ". Sections: " + overlappings + "\nThe .text section was returned for the address.");
                return Option.some(p2._2());
            }
            throw new IllegalStateException("The binary \"" + this.getFileName() + "\" contains more than one section for the address: " + Long.toHexString(address) + ". Sections: " + overlappings);
        }
        return Option.some(overlappings.getFirst()._2());
    }

    @Override
    public List<Symbol> getExportedSymbols() {
        if (this.exportedSymbols == null) {
            this.initExportedSymbols();
        }
        return this.exportedSymbols;
    }

    @Override
    public List<Symbol> getImportedSymbols() {
        if (this.importedSymbols == null) {
            this.initImportedSymbols();
        }
        return this.importedSymbols;
    }

    protected abstract void initSegments();

    protected abstract void initExportedSymbols();

    protected abstract void initImportedSymbols();
}

