/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.x86.common.X86ImmOpnd;
import bindis.x86.common.X86Instruction;
import bindis.x86.common.X86MemOpnd;
import bindis.x86.common.X86Operand;
import bindis.x86.common.X86OperandVisitor;
import bindis.x86.common.X86RegOpnd;
import java.util.LinkedList;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;

public final class X86InstructionTranslator
implements X86OperandVisitor<OperandTree.NodeBuilder, OperandTree.NodeBuilder> {
    private final Instruction.InstructionFactory factory;

    public X86InstructionTranslator(Instruction.InstructionFactory factory) {
        this.factory = factory;
    }

    public Instruction translate(X86Instruction insn) {
        String mnemonic = insn.mnemonic();
        LinkedList<OperandTree> opnds = new LinkedList<OperandTree>();
        for (int i = 0; i < insn.numberOfOperands(); ++i) {
            opnds.add(new OperandTree(this.translate((X86Operand)insn.operand(i))));
        }
        Instruction.InstructionBuilder builder = new Instruction.InstructionBuilder(this.factory);
        builder = builder.address(insn.address()).mnemonic(mnemonic).link(opnds).opcode(insn.opcode());
        return builder.build();
    }

    public OperandTree.Node translate(X86Operand opnd) {
        OperandTree.NodeBuilder root = new OperandTree.NodeBuilder();
        OperandTree.Node child = opnd.accept(this, new OperandTree.NodeBuilder()).build();
        return root.type(OperandTree.Type.Size).data(opnd.size()).link(child).build();
    }

    @Override
    public OperandTree.NodeBuilder visit(X86ImmOpnd opnd, OperandTree.NodeBuilder root) {
        return root.type(OperandTree.Type.Immi).data(opnd.imm());
    }

    @Override
    public OperandTree.NodeBuilder visit(X86RegOpnd opnd, OperandTree.NodeBuilder root) {
        return root.type(OperandTree.Type.Sym).data(opnd.name());
    }

    @Override
    public OperandTree.NodeBuilder visit(X86MemOpnd opnd, OperandTree.NodeBuilder root) {
        root.type(OperandTree.Type.Mem).data(opnd.ptrSize());
        OperandTree.NodeBuilder addressTree = new OperandTree.NodeBuilder().type(OperandTree.Type.Op).data("+");
        this.linkBase(opnd, addressTree);
        this.linkIndexAndScale(opnd, addressTree);
        this.linkDisplacement(opnd, addressTree);
        OperandTree.Node addressNode = addressTree.build();
        if (addressNode.getChildren().size() == 1) {
            return root.link(addressNode.getChildren().get(0));
        }
        return root.link(addressTree.build());
    }

    public OperandTree.NodeBuilder linkBase(X86MemOpnd opnd, OperandTree.NodeBuilder derefSubTree) {
        if (opnd.base() != null) {
            derefSubTree.link(opnd.base().accept(this, new OperandTree.NodeBuilder()).build());
        }
        return derefSubTree;
    }

    public OperandTree.NodeBuilder linkIndexAndScale(X86MemOpnd opnd, OperandTree.NodeBuilder derefSubTree) {
        if (opnd.index() != null) {
            OperandTree.Node idx = opnd.index().accept(this, new OperandTree.NodeBuilder()).build();
            if (opnd.scale() > 1) {
                OperandTree.Node scale = new OperandTree.NodeBuilder().type(OperandTree.Type.Immi).data(opnd.scale()).build();
                OperandTree.Node idxTree = new OperandTree.NodeBuilder().type(OperandTree.Type.Op).data("*").link(idx).link(scale).build();
                derefSubTree.link(idxTree);
            } else {
                derefSubTree.link(idx);
            }
        }
        return derefSubTree;
    }

    public OperandTree.NodeBuilder linkDisplacement(X86MemOpnd opnd, OperandTree.NodeBuilder derefSubTree) {
        if (opnd.disp() != null) {
            derefSubTree.link(opnd.disp().accept(this, new OperandTree.NodeBuilder()).build());
        }
        return derefSubTree;
    }
}

