/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.x86.common.X86DecodeCtx;
import bindis.x86.common.X86Instruction;
import bindis.x86.common.X86Operand;
import bindis.x86.common.X86Prefixes;

public abstract class X86InstructionFactory {
    public abstract X86Instruction make(String var1, X86DecodeCtx var2);

    public abstract X86Instruction make(String var1, X86Operand var2, X86DecodeCtx var3);

    public abstract X86Instruction make(String var1, X86Operand var2, X86Operand var3, X86DecodeCtx var4);

    public abstract X86Instruction make(String var1, X86Operand var2, X86Operand var3, X86Operand var4, X86DecodeCtx var5);

    protected String applyMnemonicMacros(String pattern, X86Prefixes prefixes) {
        assert (pattern != null) : "null pattern";
        if (pattern.indexOf(124) != -1) {
            return X86InstructionFactory.applyOrPattern(pattern, prefixes);
        }
        String mnemonic = pattern;
        mnemonic = X86InstructionFactory.applySizeMacro(prefixes, mnemonic);
        mnemonic = X86InstructionFactory.applyJccMacro(prefixes, mnemonic);
        mnemonic = X86InstructionFactory.applyFwaitMacro(prefixes, mnemonic);
        mnemonic = X86InstructionFactory.applyRepLockMacro(prefixes, mnemonic);
        if (prefixes.contains(X86Prefixes.Prefix.LOCK)) {
            mnemonic = "lock " + mnemonic;
        }
        return mnemonic;
    }

    private static String applySizeMacro(X86Prefixes prefixes, String mnemonic) {
        if (mnemonic.lastIndexOf(83) == -1) {
            return mnemonic;
        }
        char replacement = prefixes.contains(X86Prefixes.Prefix.REXW) ? (char)'q' : (prefixes.contains(X86Prefixes.Prefix.OPNDSZ) ? (char)'w' : 'd');
        return mnemonic.replace('S', replacement);
    }

    private static String applyJccMacro(X86Prefixes prefixes, String mnemonic) {
        String replacement32 = prefixes.contains(X86Prefixes.Prefix.ADDRSZ) ? "" : "e";
        String replacement64 = prefixes.contains(X86Prefixes.Prefix.ADDRSZ) ? "" : "r";
        mnemonic = mnemonic.replace("C32", replacement32);
        mnemonic = mnemonic.replace("C64", replacement64);
        return mnemonic;
    }

    private static String applyRepLockMacro(X86Prefixes prefixes, String mnemonic) {
        String replacement = "";
        if (prefixes.contains(X86Prefixes.Prefix.REPZ)) {
            replacement = "repz ";
        } else if (prefixes.contains(X86Prefixes.Prefix.REPNZ)) {
            replacement = "repnz ";
        }
        return mnemonic.replace("R", replacement);
    }

    private static String applyFwaitMacro(X86Prefixes prefixes, String mnemonic) {
        String replacement = "n";
        return mnemonic.replace("N", replacement);
    }

    private static String applyOrPattern(String pattern, X86Prefixes prefixes) {
        String[] names = pattern.split("\\|");
        assert (names.length == 2 || names.length == 3) : "Invalid pattern for mnemonic fixup";
        if (names.length == 2) {
            if (prefixes.contains(X86Prefixes.Prefix.OPNDSZ)) {
                return names[1];
            }
            return names[0];
        }
        if (names.length == 3) {
            if (prefixes.contains(X86Prefixes.Prefix.REXW)) {
                return names[2];
            }
            if (prefixes.contains(X86Prefixes.Prefix.OPNDSZ)) {
                return names[1];
            }
            return names[0];
        }
        throw new UnsupportedOperationException("Invalid or-pattern as mnemonic");
    }
}

