/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.DecodeException;
import bindis.DecodeStream;
import bindis.NativeInstruction;
import bindis.x86.common.X86DecodeCtx;
import bindis.x86.common.X86InstructionDecoder;
import bindis.x86.common.X86InstructionFactory;
import bindis.x86.common.X86ModRM;
import bindis.x86.common.X86NestedInstructionDecoder;
import bindis.x86.common.X86Operand;
import bindis.x86.common.X86OperandDecoders;

public class X86DecodeTable {
    protected final X86InstructionFactory factory;
    protected final X86OperandDecoders Mode;
    public final X86InstructionDecoder[] oneByteOpcodeTable;
    public final X86InstructionDecoder[] twoByteOpcodeTable;
    public final X86InstructionDecoder[][] floatOpcodeGroupTable;
    public final X86InstructionDecoder[][] floatOpcodeTableOne;
    public final X86InstructionDecoder[][] floatOpcodeTableTwo;
    public final X86InstructionDecoder[][] twoByteOpcodeGroupTable;
    public final X86InstructionDecoder[] twoByteOpcodePrefix66Table;
    public final X86InstructionDecoder[] twoByteOpcodePrefixF2Table;
    public final X86InstructionDecoder[] twoByteOpcodePrefixF3Table;
    public final X86InstructionDecoder[] threeByteOpcode38Table;
    public final X86InstructionDecoder[] threeByteOpcode3ATable;
    public final X86InstructionDecoder[] threeByteOpcode38Prefix66Table;
    public final X86InstructionDecoder[] threeByteOpcode3APrefix66Table;
    public final X86InstructionDecoder[] threeByteOpcode38PrefixF2Table;
    public final X86InstructionDecoder[] threeByteOpcode38PrefixF3Table;
    public final X86InstructionDecoder[][] opcodeGroupTable0F01;
    private final X86InstructionDecoder[][] opcodeGroupTable0FAE;

    public X86DecodeTable(X86OperandDecoders decoders, X86InstructionFactory factory) {
        this.Mode = decoders;
        this.opcodeGroupTable0F01 = this.create0F01OpcodeGroupTable();
        this.opcodeGroupTable0FAE = this.create0FAEOpcodeGroupTable();
        this.threeByteOpcode38Table = this.createThreeByteOpcodeTable();
        this.threeByteOpcode38Prefix66Table = this.createThreeByteOpcodePrefix66Table();
        this.threeByteOpcode38PrefixF2Table = this.createThreeByteOpcodePrefixF2Table();
        this.threeByteOpcode38PrefixF3Table = X86DecodeTable.createThreeByteOpcodePrefixF3Table();
        this.threeByteOpcode3ATable = this.createThreeByteOpcode3ATable();
        this.threeByteOpcode3APrefix66Table = this.createThreeByteOpcode3APrefix66Table();
        this.oneByteOpcodeTable = this.createOneByteOpcodeTable();
        this.twoByteOpcodeGroupTable = this.createTwoByteOpcodeGroupTable();
        this.twoByteOpcodePrefix66Table = this.createTwoByteOpcodePrefix66Table();
        this.twoByteOpcodePrefixF2Table = this.createTwoByteOpcodePrefixF2Table();
        this.twoByteOpcodePrefixF3Table = this.createTwoByteOpcodePrefixF3Table();
        this.twoByteOpcodeTable = this.createTwoByteOpcodeTable();
        this.floatOpcodeGroupTable = this.createFloatOpcodeGroupTable();
        this.floatOpcodeTableOne = this.createFloatOpcodeTableOne();
        this.floatOpcodeTableTwo = this.createFloatOpcodeTableTwo();
        this.factory = factory;
    }

    public X86InstructionDecoder decode(String name) {
        return new X86InstructionDecoder(name){

            @Override
            protected NativeInstruction decodeInstruction(X86DecodeCtx ctx) {
                return X86DecodeTable.this.factory.make(this.name, ctx);
            }
        };
    }

    public X86InstructionDecoder decode(String name, X86OperandDecoders.AddrMode addrMode1, int operandType1) {
        return new X86InstructionDecoder(name, addrMode1, operandType1){

            @Override
            public NativeInstruction decodeInstruction(X86DecodeCtx ctx) {
                X86Operand op1 = this.decodeOpnd1(ctx);
                return X86DecodeTable.this.factory.make(this.name, op1, ctx);
            }
        };
    }

    public X86InstructionDecoder decode(String name, X86OperandDecoders.AddrMode addrMode1, int operandType1, X86OperandDecoders.AddrMode addrMode2, int operandType2) {
        return new X86InstructionDecoder(name, addrMode1, operandType1, addrMode2, operandType2){

            @Override
            protected NativeInstruction decodeInstruction(X86DecodeCtx ctx) {
                X86Operand op1 = this.decodeOpnd1(ctx);
                X86Operand op2 = this.decodeOpnd2(ctx);
                return X86DecodeTable.this.factory.make(this.name, op1, op2, ctx);
            }
        };
    }

    public X86InstructionDecoder decode(String name, X86OperandDecoders.AddrMode addrMode1, int operandType1, X86OperandDecoders.AddrMode addrMode2, int operandType2, X86OperandDecoders.AddrMode addrMode3, int operandType3) {
        return new X86InstructionDecoder(name, addrMode1, operandType1, addrMode2, operandType2, addrMode3, operandType3){

            @Override
            protected NativeInstruction decodeInstruction(X86DecodeCtx ctx) {
                X86Operand op1 = this.decodeOpnd1(ctx);
                X86Operand op2 = this.decodeOpnd2(ctx);
                X86Operand op3 = this.decodeOpnd3(ctx);
                return X86DecodeTable.this.factory.make(this.name, op1, op2, op3, ctx);
            }
        };
    }

    public X86InstructionDecoder decodeGroup(final int number) {
        return new X86NestedInstructionDecoder(null){

            @Override
            public X86InstructionDecoder lookupDecoder(X86DecodeCtx ctx) {
                X86ModRM ModRM = ctx.getModRM();
                return X86DecodeTable.this.twoByteOpcodeGroupTable[number][ModRM.getRegOrOpcode()];
            }
        };
    }

    public X86InstructionDecoder decodeFloat() {
        return new X86NestedInstructionDecoder(null){

            @Override
            protected X86InstructionDecoder lookupDecoder(X86DecodeCtx ctx) {
                DecodeStream in = ctx.getDecodeStream();
                int floatOpcode = in.previous8();
                X86ModRM ModRM = ctx.getModRM();
                return this.lookupDecoder(ModRM, floatOpcode);
            }

            private X86InstructionDecoder lookupDecoder(X86ModRM ModRM, int floatOpcode) {
                int opcode = ModRM.getRegOrOpcode();
                if (ModRM.getModRM() < 191) {
                    return X86DecodeTable.this.floatOpcodeTableOne[floatOpcode - 216][opcode];
                }
                return X86DecodeTable.this.floatOpcodeTableTwo[floatOpcode - 216][opcode];
            }
        };
    }

    public X86InstructionDecoder decodeFloatGroup(final int number) {
        return new X86NestedInstructionDecoder(null){

            @Override
            protected X86InstructionDecoder lookupDecoder(X86DecodeCtx ctx) {
                X86ModRM ModRM = ctx.getModRM();
                return X86DecodeTable.this.floatOpcodeGroupTable[number][ModRM.getRm()];
            }
        };
    }

    public X86InstructionDecoder decode(final X86InstructionDecoder[] decoders) {
        return new X86NestedInstructionDecoder(null){

            @Override
            protected X86InstructionDecoder lookupDecoder(X86DecodeCtx ctx) {
                int opcode = ctx.getDecodeStream().read8();
                if (opcode >= 0 && opcode < decoders.length) {
                    return decoders[opcode];
                }
                throw DecodeException.unknownOpcode(ctx);
            }
        };
    }

    public X86InstructionDecoder decodeOrGroup(final X86InstructionDecoder[][] group, final X86InstructionDecoder[] groupTable) {
        return new X86NestedInstructionDecoder(null){

            @Override
            public X86InstructionDecoder lookupDecoder(X86DecodeCtx ctx) {
                X86ModRM ModRM = ctx.getModRM();
                X86InstructionDecoder decoder = null;
                int Mod67 = ModRM.getModRM() >> 6 & 3;
                if (Mod67 == 3) {
                    decoder = group[ModRM.getRegOrOpcode()][ModRM.getRm()];
                }
                if (decoder == null) {
                    decoder = groupTable[ModRM.getRegOrOpcode()];
                }
                return decoder;
            }
        };
    }

    private X86InstructionDecoder[] createOneByteOpcodeTable() {
        return new X86InstructionDecoder[]{this.decode("add", this.Mode.ADDR_E, 2, this.Mode.ADDR_G, 2), this.decode("add", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("add", this.Mode.ADDR_G, 2, this.Mode.ADDR_E, 2), this.decode("add", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("add", this.Mode.ADDR_REG, 16, this.Mode.ADDR_I, 2), this.decode("add", this.Mode.ADDR_REG, 0, this.Mode.ADDR_I, 15), this.decode("push", this.Mode.ADDR_REG, 24), this.decode("pop", this.Mode.ADDR_REG, 24), this.decode("or", this.Mode.ADDR_E, 2, this.Mode.ADDR_G, 2), this.decode("or", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("or", this.Mode.ADDR_G, 2, this.Mode.ADDR_E, 2), this.decode("or", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("or", this.Mode.ADDR_REG, 16, this.Mode.ADDR_I, 2), this.decode("or", this.Mode.ADDR_REG, 0, this.Mode.ADDR_I, 15), this.decode("push", this.Mode.ADDR_REG, 25), null, this.decode("adc", this.Mode.ADDR_E, 2, this.Mode.ADDR_G, 2), this.decode("adc", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("adc", this.Mode.ADDR_G, 2, this.Mode.ADDR_E, 2), this.decode("adc", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("adc", this.Mode.ADDR_REG, 16, this.Mode.ADDR_I, 2), this.decode("adc", this.Mode.ADDR_REG, 0, this.Mode.ADDR_I, 15), this.decode("push", this.Mode.ADDR_REG, 26), this.decode("pop", this.Mode.ADDR_REG, 26), this.decode("sbb", this.Mode.ADDR_E, 2, this.Mode.ADDR_G, 2), this.decode("sbb", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("sbb", this.Mode.ADDR_G, 2, this.Mode.ADDR_E, 2), this.decode("sbb", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("sbb", this.Mode.ADDR_REG, 16, this.Mode.ADDR_I, 2), this.decode("sbb", this.Mode.ADDR_REG, 0, this.Mode.ADDR_I, 15), this.decode("push", this.Mode.ADDR_REG, 27), this.decode("pop", this.Mode.ADDR_REG, 27), this.decode("and", this.Mode.ADDR_E, 2, this.Mode.ADDR_G, 2), this.decode("and", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("and", this.Mode.ADDR_G, 2, this.Mode.ADDR_E, 2), this.decode("and", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("and", this.Mode.ADDR_REG, 16, this.Mode.ADDR_I, 2), this.decode("and", this.Mode.ADDR_REG, 0, this.Mode.ADDR_I, 15), null, this.decode("daa"), this.decode("sub", this.Mode.ADDR_E, 2, this.Mode.ADDR_G, 2), this.decode("sub", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("sub", this.Mode.ADDR_G, 2, this.Mode.ADDR_E, 2), this.decode("sub", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("sub", this.Mode.ADDR_REG, 16, this.Mode.ADDR_I, 2), this.decode("sub", this.Mode.ADDR_REG, 0, this.Mode.ADDR_I, 15), null, this.decode("das"), this.decode("xor", this.Mode.ADDR_E, 2, this.Mode.ADDR_G, 2), this.decode("xor", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("xor", this.Mode.ADDR_G, 2, this.Mode.ADDR_E, 2), this.decode("xor", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("xor", this.Mode.ADDR_REG, 16, this.Mode.ADDR_I, 2), this.decode("xor", this.Mode.ADDR_REG, 0, this.Mode.ADDR_I, 15), null, this.decode("aaa"), this.decode("cmp", this.Mode.ADDR_E, 2, this.Mode.ADDR_G, 2), this.decode("cmp", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("cmp", this.Mode.ADDR_G, 2, this.Mode.ADDR_E, 2), this.decode("cmp", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmp", this.Mode.ADDR_REG, 16, this.Mode.ADDR_I, 2), this.decode("cmp", this.Mode.ADDR_REG, 0, this.Mode.ADDR_I, 15), null, this.decode("aas"), this.decode("inc", this.Mode.ADDR_REG, 30), this.decode("inc", this.Mode.ADDR_REG, 31), this.decode("inc", this.Mode.ADDR_REG, 32), this.decode("inc", this.Mode.ADDR_REG, 33), this.decode("inc", this.Mode.ADDR_REG, 34), this.decode("inc", this.Mode.ADDR_REG, 35), this.decode("inc", this.Mode.ADDR_REG, 36), this.decode("inc", this.Mode.ADDR_REG, 37), this.decode("dec", this.Mode.ADDR_REG, 30), this.decode("dec", this.Mode.ADDR_REG, 31), this.decode("dec", this.Mode.ADDR_REG, 32), this.decode("dec", this.Mode.ADDR_REG, 33), this.decode("dec", this.Mode.ADDR_REG, 34), this.decode("dec", this.Mode.ADDR_REG, 35), this.decode("dec", this.Mode.ADDR_REG, 36), this.decode("dec", this.Mode.ADDR_REG, 37), this.decode("push", this.Mode.ADDR_REG, 30), this.decode("push", this.Mode.ADDR_REG, 31), this.decode("push", this.Mode.ADDR_REG, 32), this.decode("push", this.Mode.ADDR_REG, 33), this.decode("push", this.Mode.ADDR_REG, 34), this.decode("push", this.Mode.ADDR_REG, 35), this.decode("push", this.Mode.ADDR_REG, 36), this.decode("push", this.Mode.ADDR_REG, 37), this.decode("pop", this.Mode.ADDR_REG, 30), this.decode("pop", this.Mode.ADDR_REG, 31), this.decode("pop", this.Mode.ADDR_REG, 32), this.decode("pop", this.Mode.ADDR_REG, 33), this.decode("pop", this.Mode.ADDR_REG, 34), this.decode("pop", this.Mode.ADDR_REG, 35), this.decode("pop", this.Mode.ADDR_REG, 36), this.decode("pop", this.Mode.ADDR_REG, 37), this.decode("pushad|pusha"), this.decode("popad|popa"), this.decode("bound", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("movsxd", this.Mode.ADDR_G, 15, this.Mode.ADDR_R, 4), null, null, null, null, this.decode("push", this.Mode.ADDR_I, 15), this.decode("imul", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 15), this.decode("push", this.Mode.ADDR_I, 2), this.decode("imul", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("insb", this.Mode.ADDR_Y, 2, this.Mode.ADDR_REG, 10), this.decode("insS", this.Mode.ADDR_Y, 1, this.Mode.ADDR_REG, 10), this.decode("outsb", this.Mode.ADDR_REG, 10, this.Mode.ADDR_X, 2), this.decode("outsS", this.Mode.ADDR_REG, 10, this.Mode.ADDR_X, 1), this.decode("jo", this.Mode.ADDR_J, 2), this.decode("jno", this.Mode.ADDR_J, 2), this.decode("jb", this.Mode.ADDR_J, 2), this.decode("jnb", this.Mode.ADDR_J, 2), this.decode("jz", this.Mode.ADDR_J, 2), this.decode("jnz", this.Mode.ADDR_J, 2), this.decode("jbe", this.Mode.ADDR_J, 2), this.decode("ja", this.Mode.ADDR_J, 2), this.decode("js", this.Mode.ADDR_J, 2), this.decode("jns", this.Mode.ADDR_J, 2), this.decode("jp", this.Mode.ADDR_J, 2), this.decode("jnp", this.Mode.ADDR_J, 2), this.decode("jl", this.Mode.ADDR_J, 2), this.decode("jnl", this.Mode.ADDR_J, 2), this.decode("jle", this.Mode.ADDR_J, 2), this.decode("jnle", this.Mode.ADDR_J, 2), this.decodeGroup(0), this.decodeGroup(1), null, this.decodeGroup(2), this.decode("test", this.Mode.ADDR_E, 2, this.Mode.ADDR_G, 2), this.decode("test", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("xchg", this.Mode.ADDR_E, 2, this.Mode.ADDR_G, 2), this.decode("xchg", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("mov", this.Mode.ADDR_E, 2, this.Mode.ADDR_G, 2), this.decode("mov", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("mov", this.Mode.ADDR_G, 2, this.Mode.ADDR_E, 2), this.decode("mov", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("mov", this.Mode.ADDR_E, 16, this.Mode.ADDR_S, 16), this.decode("lea", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("mov", this.Mode.ADDR_S, 16, this.Mode.ADDR_E, 16), this.decode("pop", this.Mode.ADDR_E, 15), this.decode("nop"), this.decode("xchg", this.Mode.ADDR_REG, 1, this.Mode.ADDR_REG, 0), this.decode("xchg", this.Mode.ADDR_REG, 2, this.Mode.ADDR_REG, 0), this.decode("xchg", this.Mode.ADDR_REG, 3, this.Mode.ADDR_REG, 0), this.decode("xchg", this.Mode.ADDR_REG, 4, this.Mode.ADDR_REG, 0), this.decode("xchg", this.Mode.ADDR_REG, 5, this.Mode.ADDR_REG, 0), this.decode("xchg", this.Mode.ADDR_REG, 6, this.Mode.ADDR_REG, 0), this.decode("xchg", this.Mode.ADDR_REG, 7, this.Mode.ADDR_REG, 0), this.decode("cwde|cbw|cdqe"), this.decode("cdq|cwd|cqo"), this.decode("call", this.Mode.ADDR_A, 6), this.decode("fwait"), this.decode("pushfd|pushf"), this.decode("popfd|popf"), this.decode("sahf"), this.decode("lahf"), this.decode("mov", this.Mode.ADDR_REG, 16, this.Mode.ADDR_O, 2), this.decode("mov", this.Mode.ADDR_REG, 0, this.Mode.ADDR_O, 15), this.decode("mov", this.Mode.ADDR_O, 2, this.Mode.ADDR_REG, 16), this.decode("mov", this.Mode.ADDR_O, 15, this.Mode.ADDR_REG, 0), this.decode("movsb", this.Mode.ADDR_Y, 2, this.Mode.ADDR_X, 2), this.decode("movsS", this.Mode.ADDR_Y, 1, this.Mode.ADDR_X, 1), this.decode("Rcmpsb", this.Mode.ADDR_X, 2, this.Mode.ADDR_Y, 2), this.decode("RcmpsS", this.Mode.ADDR_X, 1, this.Mode.ADDR_Y, 1), this.decode("test", this.Mode.ADDR_REG, 16, this.Mode.ADDR_I, 2), this.decode("test", this.Mode.ADDR_REG, 0, this.Mode.ADDR_I, 15), this.decode("stosb", this.Mode.ADDR_Y, 2, this.Mode.ADDR_REG, 16), this.decode("stosS", this.Mode.ADDR_Y, 1, this.Mode.ADDR_REG, 0), this.decode("lodsb", this.Mode.ADDR_REG, 16, this.Mode.ADDR_X, 2), this.decode("lodsS", this.Mode.ADDR_REG, 0, this.Mode.ADDR_X, 1), this.decode("scasb", this.Mode.ADDR_REG, 16, this.Mode.ADDR_Y, 2), this.decode("scasS", this.Mode.ADDR_REG, 0, this.Mode.ADDR_Y, 1), this.decode("mov", this.Mode.ADDR_REG, 16, this.Mode.ADDR_I, 2), this.decode("mov", this.Mode.ADDR_REG, 17, this.Mode.ADDR_I, 2), this.decode("mov", this.Mode.ADDR_REG, 18, this.Mode.ADDR_I, 2), this.decode("mov", this.Mode.ADDR_REG, 19, this.Mode.ADDR_I, 2), this.decode("mov", this.Mode.ADDR_REG, 20, this.Mode.ADDR_I, 2), this.decode("mov", this.Mode.ADDR_REG, 21, this.Mode.ADDR_I, 2), this.decode("mov", this.Mode.ADDR_REG, 22, this.Mode.ADDR_I, 2), this.decode("mov", this.Mode.ADDR_REG, 23, this.Mode.ADDR_I, 2), this.decode("mov", this.Mode.ADDR_REG, 0, this.Mode.ADDR_I64, 15), this.decode("mov", this.Mode.ADDR_REG, 1, this.Mode.ADDR_I64, 15), this.decode("mov", this.Mode.ADDR_REG, 2, this.Mode.ADDR_I64, 15), this.decode("mov", this.Mode.ADDR_REG, 3, this.Mode.ADDR_I64, 15), this.decode("mov", this.Mode.ADDR_REG, 4, this.Mode.ADDR_I64, 15), this.decode("mov", this.Mode.ADDR_REG, 5, this.Mode.ADDR_I64, 15), this.decode("mov", this.Mode.ADDR_REG, 6, this.Mode.ADDR_I64, 15), this.decode("mov", this.Mode.ADDR_REG, 7, this.Mode.ADDR_I64, 15), this.decodeGroup(3), this.decodeGroup(4), this.decode("ret", this.Mode.ADDR_I, 16), this.decode("ret"), this.decode("les", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 6), this.decode("lds", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 6), this.decode("mov", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2), this.decode("mov", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 15), this.decode("enter", this.Mode.ADDR_I, 16, this.Mode.ADDR_I, 2), this.decode("leave"), this.decode("ret", this.Mode.ADDR_I, 16), this.decode("ret"), this.decode("int3"), this.decode("int", this.Mode.ADDR_I, 2), this.decode("into"), this.decode("iretd|iret"), this.decodeGroup(5), this.decodeGroup(6), this.decodeGroup(7), this.decodeGroup(8), this.decode("aam", this.Mode.ADDR_I, 2), this.decode("aad", this.Mode.ADDR_I, 2), this.decode("salc"), this.decode("xlat"), this.decodeFloat(), this.decodeFloat(), this.decodeFloat(), this.decodeFloat(), this.decodeFloat(), this.decodeFloat(), this.decodeFloat(), this.decodeFloat(), this.decode("loopne", this.Mode.ADDR_J, 2), this.decode("loope", this.Mode.ADDR_J, 2), this.decode("loop", this.Mode.ADDR_J, 2), this.decode("jC64cxz", this.Mode.ADDR_J, 2), this.decode("in", this.Mode.ADDR_REG, 16, this.Mode.ADDR_I, 2), this.decode("in", this.Mode.ADDR_REG, 0, this.Mode.ADDR_I, 2), this.decode("out", this.Mode.ADDR_I, 2, this.Mode.ADDR_REG, 16), this.decode("out", this.Mode.ADDR_I, 2, this.Mode.ADDR_REG, 0), this.decode("call", this.Mode.ADDR_J, 15), this.decode("jmp", this.Mode.ADDR_J, 15), this.decode("jmp", this.Mode.ADDR_A, 6), this.decode("jmp", this.Mode.ADDR_J, 2), this.decode("in", this.Mode.ADDR_REG, 16, this.Mode.ADDR_REG, 10), this.decode("in", this.Mode.ADDR_REG, 0, this.Mode.ADDR_REG, 10), this.decode("out", this.Mode.ADDR_REG, 10, this.Mode.ADDR_REG, 16), this.decode("out", this.Mode.ADDR_REG, 10, this.Mode.ADDR_REG, 0), this.decode("lock"), this.decode("int1"), this.decode("repne"), this.decode("rep"), this.decode("hlt"), this.decode("cmc"), this.decodeGroup(9), this.decodeGroup(10), this.decode("clc"), this.decode("stc"), this.decode("cli"), this.decode("sti"), this.decode("cld"), this.decode("std"), this.decodeGroup(11), this.decodeGroup(12)};
    }

    private X86InstructionDecoder[] createTwoByteOpcodeTable() {
        return new X86InstructionDecoder[]{this.decodeGroup(13), this.decodeOrGroup(this.opcodeGroupTable0F01, this.twoByteOpcodeGroupTable[14]), this.decode("lar", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 16), this.decode("lsl", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 16), null, this.decode("syscall"), this.decode("clts"), this.decode("sysret"), this.decode("invd"), this.decode("wbinvd"), null, this.decode("ud2"), null, this.decode("prefetch_exclusive", this.Mode.ADDR_M, 2), this.decode("femms"), null, this.decode("movups", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("movups", this.Mode.ADDR_W, 9, this.Mode.ADDR_V, 9), this.decode("movlps", this.Mode.ADDR_W, 10, this.Mode.ADDR_V, 10), this.decode("movlps", this.Mode.ADDR_V, 10, this.Mode.ADDR_W, 10), this.decode("unpcklps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 10), this.decode("unpckhps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 10), this.decode("movhps", this.Mode.ADDR_V, 10, this.Mode.ADDR_W, 10), this.decode("movhps", this.Mode.ADDR_W, 10, this.Mode.ADDR_V, 10), this.decodeGroup(21), null, null, null, null, null, null, this.decode("nop", this.Mode.ADDR_E, 15), this.decode("mov", this.Mode.ADDR_R, 4, this.Mode.ADDR_C, 4), this.decode("mov", this.Mode.ADDR_R, 4, this.Mode.ADDR_D, 4), this.decode("mov", this.Mode.ADDR_C, 4, this.Mode.ADDR_R, 4), this.decode("mov", this.Mode.ADDR_D, 4, this.Mode.ADDR_R, 4), this.decode("mov", this.Mode.ADDR_R, 4, this.Mode.ADDR_T, 4), null, this.decode("mov", this.Mode.ADDR_T, 4, this.Mode.ADDR_R, 4), null, this.decode("movaps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("movaps", this.Mode.ADDR_W, 9, this.Mode.ADDR_V, 9), this.decode("cvtpi2ps", this.Mode.ADDR_V, 9, this.Mode.ADDR_Q, 10), this.decode("movntps", this.Mode.ADDR_W, 9, this.Mode.ADDR_V, 9), this.decode("cvttps2pi", this.Mode.ADDR_Q, 10, this.Mode.ADDR_W, 9), this.decode("cvtps2pi", this.Mode.ADDR_Q, 10, this.Mode.ADDR_W, 9), this.decode("ucomiss", this.Mode.ADDR_V, 14, this.Mode.ADDR_W, 14), this.decode("comiss", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("wrmsr"), this.decode("rdtsc"), this.decode("rdmsr"), this.decode("rdpmc"), this.decode("sysenter"), this.decode("sysexit"), null, this.decode("getsec"), this.decode(this.threeByteOpcode38Table), null, this.decode(this.threeByteOpcode3ATable), null, this.decode("movnti", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), null, null, null, this.decode("cmovo", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmovno", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmovb", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmovnb", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmovz", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmovnz", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmovbe", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmovnbe", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmovs", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmovns", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmovp", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmovnp", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmovl", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmovnl", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmovle", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmovnle", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("movmskps", this.Mode.ADDR_E, 4, this.Mode.ADDR_V, 9), this.decode("sqrtps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("rsqrtps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("rcpps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("andps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("andnps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("orps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("xorps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("addps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("mulps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("cvtps2pd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 9), this.decode("cvtdq2ps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 5), this.decode("subps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("minps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("divps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("maxps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("punpcklbw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 4), this.decode("punpcklwd", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 4), this.decode("punpckldq", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 4), this.decode("packsswb", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pcmpgtb", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pcmpgtw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pcmpgtd", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("packuswb", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("punpckhbw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 4), this.decode("punpckhwd", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 4), this.decode("punpckhdq", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 4), this.decode("packssdw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 4), null, null, this.decode("movd", this.Mode.ADDR_P, 4, this.Mode.ADDR_E, 4), this.decode("movq", this.Mode.ADDR_P, 10, this.Mode.ADDR_E, 10), this.decode("pshufw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10, this.Mode.ADDR_I, 2), this.decodeGroup(17), this.decodeGroup(18), this.decodeGroup(19), this.decode("pcmpeqb", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pcmpeqw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pcmpeqd", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("emms"), this.decode("vmread", this.Mode.ADDR_M, 4, this.Mode.ADDR_G, 4), this.decode("vmwrite", this.Mode.ADDR_G, 4, this.Mode.ADDR_M, 4), null, null, null, null, this.decode("movd", this.Mode.ADDR_E, 4, this.Mode.ADDR_P, 4), this.decode("movq", this.Mode.ADDR_Q, 10, this.Mode.ADDR_P, 10), this.decode("jo", this.Mode.ADDR_J, 15), this.decode("jno", this.Mode.ADDR_J, 15), this.decode("jb", this.Mode.ADDR_J, 15), this.decode("jnb", this.Mode.ADDR_J, 15), this.decode("jz", this.Mode.ADDR_J, 15), this.decode("jnz", this.Mode.ADDR_J, 15), this.decode("jbe", this.Mode.ADDR_J, 15), this.decode("ja", this.Mode.ADDR_J, 15), this.decode("js", this.Mode.ADDR_J, 15), this.decode("jns", this.Mode.ADDR_J, 15), this.decode("jp", this.Mode.ADDR_J, 15), this.decode("jnp", this.Mode.ADDR_J, 15), this.decode("jl", this.Mode.ADDR_J, 15), this.decode("jnl", this.Mode.ADDR_J, 15), this.decode("jle", this.Mode.ADDR_J, 15), this.decode("jnle", this.Mode.ADDR_J, 15), this.decode("seto", this.Mode.ADDR_E, 2), this.decode("setno", this.Mode.ADDR_E, 2), this.decode("setb", this.Mode.ADDR_E, 2), this.decode("setnb", this.Mode.ADDR_E, 2), this.decode("setz", this.Mode.ADDR_E, 2), this.decode("setnz", this.Mode.ADDR_E, 2), this.decode("setbe", this.Mode.ADDR_E, 2), this.decode("setnbe", this.Mode.ADDR_E, 2), this.decode("sets", this.Mode.ADDR_E, 2), this.decode("setns", this.Mode.ADDR_E, 2), this.decode("setp", this.Mode.ADDR_E, 2), this.decode("setnp", this.Mode.ADDR_E, 2), this.decode("setl", this.Mode.ADDR_E, 2), this.decode("setnl", this.Mode.ADDR_E, 2), this.decode("setle", this.Mode.ADDR_E, 2), this.decode("setnle", this.Mode.ADDR_E, 2), this.decode("push", this.Mode.ADDR_REG, 28), this.decode("pop", this.Mode.ADDR_REG, 28), this.decode("cpuid"), this.decode("bt", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("shld", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15, this.Mode.ADDR_I, 2), this.decode("shld", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15, this.Mode.ADDR_REG, 17), null, null, this.decode("push", this.Mode.ADDR_REG, 29), this.decode("pop", this.Mode.ADDR_REG, 29), this.decode("rsm"), this.decode("bts", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("shrd", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15, this.Mode.ADDR_I, 2), this.decode("shrd", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15, this.Mode.ADDR_REG, 17), this.decodeOrGroup(this.opcodeGroupTable0FAE, this.twoByteOpcodeGroupTable[20]), this.decode("imul", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("cmpxchg", this.Mode.ADDR_E, 2, this.Mode.ADDR_G, 2), this.decode("cmpxchg", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("lss", this.Mode.ADDR_G, 15, this.Mode.ADDR_M, 6), this.decode("btr", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("lfs", this.Mode.ADDR_G, 15, this.Mode.ADDR_M, 6), this.decode("lgs", this.Mode.ADDR_G, 15, this.Mode.ADDR_M, 6), this.decode("movzx", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 2), this.decode("movzx", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 16), null, null, this.decodeGroup(15), this.decode("btc", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("bsf", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("bsr", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15), this.decode("movsx", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 2), this.decode("movsx", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 16), this.decode("xadd", this.Mode.ADDR_E, 2, this.Mode.ADDR_G, 2), this.decode("xadd", this.Mode.ADDR_E, 15, this.Mode.ADDR_G, 15), this.decode("cmpps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9, this.Mode.ADDR_I, 2), this.decode("movnti", this.Mode.ADDR_E, 4, this.Mode.ADDR_G, 4), this.decode("pinsrw", this.Mode.ADDR_P, 10, this.Mode.ADDR_E, 4, this.Mode.ADDR_I, 2), this.decode("pextrw", this.Mode.ADDR_G, 4, this.Mode.ADDR_P, 10, this.Mode.ADDR_I, 2), this.decode("shufps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9, this.Mode.ADDR_I, 2), this.decodeGroup(16), this.decode("bswap", this.Mode.ADDR_REG, 0), this.decode("bswap", this.Mode.ADDR_REG, 1), this.decode("bswap", this.Mode.ADDR_REG, 2), this.decode("bswap", this.Mode.ADDR_REG, 3), this.decode("bswap", this.Mode.ADDR_REG, 4), this.decode("bswap", this.Mode.ADDR_REG, 5), this.decode("bswap", this.Mode.ADDR_REG, 6), this.decode("bswap", this.Mode.ADDR_REG, 7), null, this.decode("psrlw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("psrld", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("psrlq", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("paddq", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pmullw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), null, this.decode("pmovmskb", this.Mode.ADDR_G, 4, this.Mode.ADDR_P, 10), this.decode("psubusb", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("psubusw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pminub", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pand", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("paddusb", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("paddusw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pmaxub", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pandn", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pavgb", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("psraw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("psrad", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pavgw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pmulhuw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pmulhw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), null, this.decode("movntq", this.Mode.ADDR_W, 10, this.Mode.ADDR_V, 10), this.decode("psubsb", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("psubsw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pminsw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("por", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("paddsb", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("paddsw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pmaxsw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pxor", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), null, this.decode("psllw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pslld", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("psllq", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pmuludq", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("pmaddwd", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("psadbw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("maskmoveq", this.Mode.ADDR_P, 8, this.Mode.ADDR_Q, 8), this.decode("psubb", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("psubw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("psubd", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("psubq", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("paddb", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("paddw", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), this.decode("paddd", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10), null};
    }

    private X86InstructionDecoder[] createTwoByteOpcodePrefix66Table() {
        return new X86InstructionDecoder[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("movupd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), this.decode("movupd", this.Mode.ADDR_W, 7, this.Mode.ADDR_V, 7), this.decode("movlpd", this.Mode.ADDR_V, 10, this.Mode.ADDR_W, 10), this.decode("movlpd", this.Mode.ADDR_W, 10, this.Mode.ADDR_V, 10), this.decode("unpcklpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 10), this.decode("unpckhpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 10), this.decode("movhpd", this.Mode.ADDR_V, 10, this.Mode.ADDR_W, 10), this.decode("movhpd", this.Mode.ADDR_W, 10, this.Mode.ADDR_V, 10), null, null, null, null, null, null, null, this.decode("nop", this.Mode.ADDR_E, 15), null, null, null, null, null, null, null, null, this.decode("movapd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), this.decode("movapd", this.Mode.ADDR_W, 7, this.Mode.ADDR_V, 7), this.decode("cvtpi2pd", this.Mode.ADDR_V, 7, this.Mode.ADDR_Q, 5), this.decode("movntpd", this.Mode.ADDR_W, 7, this.Mode.ADDR_V, 7), this.decode("cvttpd2pi", this.Mode.ADDR_Q, 5, this.Mode.ADDR_W, 7), this.decode("cvtpd2pi", this.Mode.ADDR_Q, 5, this.Mode.ADDR_W, 7), this.decode("ucomisd", this.Mode.ADDR_V, 12, this.Mode.ADDR_W, 12), this.decode("comisd", this.Mode.ADDR_V, 12, this.Mode.ADDR_W, 12), null, null, null, null, null, null, null, null, this.decode(this.threeByteOpcode38Prefix66Table), null, this.decode(this.threeByteOpcode3APrefix66Table), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("movmskpd", this.Mode.ADDR_E, 4, this.Mode.ADDR_V, 7), this.decode("sqrtpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), null, null, this.decode("andpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), this.decode("andnpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), this.decode("orpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), this.decode("xorpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), this.decode("addpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), this.decode("mulpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), this.decode("cvtpd2ps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 7), this.decode("cvtps2dq", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 9), this.decode("subpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), this.decode("minpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), this.decode("divpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), this.decode("maxpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), this.decode("punpcklbw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("punpcklwd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("punpckldq", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("packsswb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pcmpgtb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pcmpgtw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pcmpgtd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("packuswb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("punpckhbw", this.Mode.ADDR_P, 5, this.Mode.ADDR_Q, 5), this.decode("punpckhwd", this.Mode.ADDR_P, 5, this.Mode.ADDR_Q, 5), this.decode("punpckhdq", this.Mode.ADDR_P, 5, this.Mode.ADDR_Q, 5), this.decode("packssdw", this.Mode.ADDR_P, 5, this.Mode.ADDR_Q, 5), this.decode("punpcklqdq", this.Mode.ADDR_P, 5, this.Mode.ADDR_Q, 5), this.decode("punpckhqdq", this.Mode.ADDR_P, 5, this.Mode.ADDR_Q, 5), this.decode("movd", this.Mode.ADDR_V, 5, this.Mode.ADDR_E, 4), this.decode("movdqa", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pshufd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2), this.decodeGroup(22), this.decodeGroup(23), this.decodeGroup(24), this.decode("pcmpeqb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pcmpeqw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pcmpeqd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), null, this.decode("extrq", this.Mode.ADDR_V, 5, this.Mode.ADDR_I, 2, this.Mode.ADDR_I, 2), this.decode("extrq", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 10), null, null, this.decode("haddpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), this.decode("hsubpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), this.decode("movd", this.Mode.ADDR_E, 4, this.Mode.ADDR_V, 5), this.decode("movdqa", this.Mode.ADDR_W, 5, this.Mode.ADDR_V, 5), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("cmppd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7, this.Mode.ADDR_I, 2), null, this.decode("pinsrw", this.Mode.ADDR_V, 5, this.Mode.ADDR_E, 4, this.Mode.ADDR_I, 2), this.decode("pextrw", this.Mode.ADDR_G, 4, this.Mode.ADDR_V, 5, this.Mode.ADDR_I, 2), this.decode("shufpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7, this.Mode.ADDR_I, 2), null, this.decode("bswap", this.Mode.ADDR_REG, 0), this.decode("bswap", this.Mode.ADDR_REG, 1), this.decode("bswap", this.Mode.ADDR_REG, 2), this.decode("bswap", this.Mode.ADDR_REG, 3), this.decode("bswap", this.Mode.ADDR_REG, 4), this.decode("bswap", this.Mode.ADDR_REG, 5), this.decode("bswap", this.Mode.ADDR_REG, 6), this.decode("bswap", this.Mode.ADDR_REG, 7), this.decode("addsubpd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 7), this.decode("psrlw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("psrld", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("psrlq", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("paddq", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pmullw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("movq", this.Mode.ADDR_W, 10, this.Mode.ADDR_V, 10), this.decode("pmovmskb", this.Mode.ADDR_G, 4, this.Mode.ADDR_V, 5), this.decode("psubusb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("psubusw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pminub", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pand", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("paddusb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("paddusw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pmaxub", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pandn", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pavgb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("psraw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("psrad", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pavgw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pmulhuw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pmulhw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("cvttpd2dq", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 7), this.decode("movntdq", this.Mode.ADDR_W, 5, this.Mode.ADDR_V, 5), this.decode("psubsb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("psubsw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pminsw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("por", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("paddsb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("paddsw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pmaxsw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pxor", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), null, this.decode("psllw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pslld", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("psllq", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pmuludq", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pmaddwd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("psadbw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("maskmovdqu", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("psubb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("psubw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("psubd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("psubq", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("paddb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("paddw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("paddd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), null};
    }

    private X86InstructionDecoder[] createTwoByteOpcodePrefixF2Table() {
        return new X86InstructionDecoder[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("movsd", this.Mode.ADDR_V, 12, this.Mode.ADDR_W, 12), this.decode("movsd", this.Mode.ADDR_W, 12, this.Mode.ADDR_V, 12), this.decode("movddup", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 9), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("cvtsi2sd", this.Mode.ADDR_V, 12, this.Mode.ADDR_E, 4), this.decode("movntsd", this.Mode.ADDR_M, 10, this.Mode.ADDR_V, 12), this.decode("cvttsd2si", this.Mode.ADDR_G, 4, this.Mode.ADDR_W, 12), this.decode("cvtsd2si", this.Mode.ADDR_G, 4, this.Mode.ADDR_W, 12), null, null, null, null, null, null, null, null, null, null, this.decode(this.threeByteOpcode38PrefixF2Table), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("sqrtsd", this.Mode.ADDR_V, 12, this.Mode.ADDR_W, 12), null, null, null, null, null, null, this.decode("addsd", this.Mode.ADDR_V, 12, this.Mode.ADDR_W, 12), this.decode("mulsd", this.Mode.ADDR_V, 12, this.Mode.ADDR_W, 12), this.decode("cvtsd2ss", this.Mode.ADDR_V, 12, this.Mode.ADDR_W, 12), null, this.decode("subsd", this.Mode.ADDR_V, 12, this.Mode.ADDR_W, 12), this.decode("minsd", this.Mode.ADDR_V, 12, this.Mode.ADDR_W, 12), this.decode("divsd", this.Mode.ADDR_V, 12, this.Mode.ADDR_W, 12), this.decode("maxsd", this.Mode.ADDR_V, 12, this.Mode.ADDR_W, 12), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("pshuflw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2), null, null, null, null, null, null, null, null, null, null, null, this.decode("haddps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), this.decode("hsubps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("cmpsd_xmm", this.Mode.ADDR_V, 12, this.Mode.ADDR_W, 12, this.Mode.ADDR_I, 2), null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("addsubps", this.Mode.ADDR_V, 9, this.Mode.ADDR_W, 9), null, null, null, null, null, this.decode("movdq2q", this.Mode.ADDR_P, 10, this.Mode.ADDR_W, 10), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("cvtpd2dq", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 7), null, null, null, null, null, null, null, null, null, this.decode("lddqu", this.Mode.ADDR_V, 10, this.Mode.ADDR_M, 15), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    }

    private X86InstructionDecoder[] createTwoByteOpcodePrefixF3Table() {
        return new X86InstructionDecoder[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("movss", this.Mode.ADDR_V, 14, this.Mode.ADDR_W, 14), this.decode("movss", this.Mode.ADDR_W, 14, this.Mode.ADDR_V, 14), this.decode("movsldup", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 9), null, null, null, this.decode("movshdup", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 9), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("cvtsi2ss", this.Mode.ADDR_V, 14, this.Mode.ADDR_E, 4), this.decode("movntss", this.Mode.ADDR_M, 4, this.Mode.ADDR_V, 14), this.decode("cvttss2si", this.Mode.ADDR_G, 4, this.Mode.ADDR_W, 14), this.decode("cvtss2si", this.Mode.ADDR_G, 4, this.Mode.ADDR_W, 14), null, null, null, null, null, null, null, null, null, null, this.decode(this.threeByteOpcode38PrefixF3Table), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("sqrtss", this.Mode.ADDR_V, 14, this.Mode.ADDR_W, 14), this.decode("rsqrtss", this.Mode.ADDR_V, 14, this.Mode.ADDR_W, 14), this.decode("rcpss", this.Mode.ADDR_V, 14, this.Mode.ADDR_W, 14), null, null, null, null, this.decode("addss", this.Mode.ADDR_V, 14, this.Mode.ADDR_W, 14), this.decode("mulss", this.Mode.ADDR_V, 14, this.Mode.ADDR_W, 14), this.decode("cvtss2sd", this.Mode.ADDR_V, 14, this.Mode.ADDR_W, 14), this.decode("cvttps2dq", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 9), this.decode("subss", this.Mode.ADDR_V, 14, this.Mode.ADDR_W, 14), this.decode("minss", this.Mode.ADDR_V, 14, this.Mode.ADDR_W, 14), this.decode("divss", this.Mode.ADDR_V, 14, this.Mode.ADDR_W, 14), this.decode("maxss", this.Mode.ADDR_V, 14, this.Mode.ADDR_W, 14), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("movdqu", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5), this.decode("pshufhw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2), null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("movq", this.Mode.ADDR_V, 10, this.Mode.ADDR_W, 10), this.decode("movdqu", this.Mode.ADDR_W, 5, this.Mode.ADDR_V, 5), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("pause"), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("RstosS", this.Mode.ADDR_Y, 1, this.Mode.ADDR_REG, 0), null, null, null, null, null, null, null, null, null, null, null, null, this.decode("popcnt", this.Mode.ADDR_R, 15, this.Mode.ADDR_E, 15), null, null, null, null, this.decode("lzcnt", this.Mode.ADDR_R, 15, this.Mode.ADDR_E, 15), null, null, null, null, this.decode("cmpss", this.Mode.ADDR_V, 14, this.Mode.ADDR_W, 14, this.Mode.ADDR_I, 2), this.decode("ret"), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("movq2dq", this.Mode.ADDR_V, 5, this.Mode.ADDR_Q, 10), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, this.decode("cvtdq2pd", this.Mode.ADDR_V, 7, this.Mode.ADDR_W, 5), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    }

    private X86InstructionDecoder[][] createFloatOpcodeGroupTable() {
        return new X86InstructionDecoder[][]{{this.decode("fnop"), null, null, null, null, null, null, null}, {this.decode("fchs"), this.decode("fabs"), null, null, this.decode("ftst"), this.decode("fxam"), null, null}, {this.decode("fld1"), this.decode("fldl2t"), this.decode("fldl2e"), this.decode("fldpi"), this.decode("fldlg2"), this.decode("fldln2"), this.decode("fldz"), null}, {this.decode("f2xm1"), this.decode("fyl2x"), this.decode("fptan"), this.decode("fpatan"), this.decode("fxtract"), this.decode("fprem1"), this.decode("fdecstp"), this.decode("fincstp")}, {this.decode("fprem"), this.decode("fyl2xp1"), this.decode("fsqrt"), this.decode("fsincos"), this.decode("frndint"), this.decode("fscale"), this.decode("fsin"), this.decode("fcos")}, {null, this.decode("fucompp"), null, null, null, null, null, null}, {this.decode("feni(287 only)"), this.decode("fdisi(287 only)"), this.decode("fNclex"), this.decode("fNinit"), this.decode("fNsetpm(287 only)"), null, null, null}, {null, this.decode("fcompp"), null, null, null, null, null, null}, {this.decode("fNstsw"), null, null, null, null, null, null, null}};
    }

    private X86InstructionDecoder[][] createTwoByteOpcodeGroupTable() {
        return new X86InstructionDecoder[][]{{this.decode("add", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2), this.decode("or", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2), this.decode("adc", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2), this.decode("sbb", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2), this.decode("and", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2), this.decode("sub", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2), this.decode("xor", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2), this.decode("cmp", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2)}, {this.decode("add", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 15), this.decode("or", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 15), this.decode("adc", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 15), this.decode("sbb", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 15), this.decode("and", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 15), this.decode("sub", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 15), this.decode("xor", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 15), this.decode("cmp", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 15)}, {this.decode("add", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("or", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("adc", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("sbb", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("and", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("sub", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("xor", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("cmp", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2)}, {this.decode("rol", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2), this.decode("ror", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2), this.decode("rcl", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2), this.decode("rcr", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2), this.decode("shl", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2), this.decode("shr", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2), null, this.decode("sar", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2)}, {this.decode("rol", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("ror", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("rcl", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("rcr", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("shl", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("shr", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), null, this.decode("sar", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2)}, {this.decode("rol", this.Mode.ADDR_E, 2, this.Mode.ADDR_IMM, 1), this.decode("ror", this.Mode.ADDR_E, 2, this.Mode.ADDR_IMM, 1), this.decode("rcl", this.Mode.ADDR_E, 2, this.Mode.ADDR_IMM, 1), this.decode("rcr", this.Mode.ADDR_E, 2, this.Mode.ADDR_IMM, 1), this.decode("shl", this.Mode.ADDR_E, 2, this.Mode.ADDR_IMM, 1), this.decode("shr", this.Mode.ADDR_E, 2, this.Mode.ADDR_IMM, 1), null, this.decode("sar", this.Mode.ADDR_E, 2, this.Mode.ADDR_IMM, 1)}, {this.decode("rol", this.Mode.ADDR_E, 15, this.Mode.ADDR_IMM, 1), this.decode("ror", this.Mode.ADDR_E, 15, this.Mode.ADDR_IMM, 1), this.decode("rcl", this.Mode.ADDR_E, 15, this.Mode.ADDR_IMM, 1), this.decode("rcr", this.Mode.ADDR_E, 15, this.Mode.ADDR_IMM, 1), this.decode("shl", this.Mode.ADDR_E, 15, this.Mode.ADDR_IMM, 1), this.decode("shr", this.Mode.ADDR_E, 15, this.Mode.ADDR_IMM, 1), null, this.decode("sar", this.Mode.ADDR_E, 15, this.Mode.ADDR_IMM, 1)}, {this.decode("rol", this.Mode.ADDR_E, 2, this.Mode.ADDR_REG, 17), this.decode("ror", this.Mode.ADDR_E, 2, this.Mode.ADDR_REG, 17), this.decode("rcl", this.Mode.ADDR_E, 2, this.Mode.ADDR_REG, 17), this.decode("rcr", this.Mode.ADDR_E, 2, this.Mode.ADDR_REG, 17), this.decode("shl", this.Mode.ADDR_E, 2, this.Mode.ADDR_REG, 17), this.decode("shr", this.Mode.ADDR_E, 2, this.Mode.ADDR_REG, 17), null, this.decode("sar", this.Mode.ADDR_E, 2, this.Mode.ADDR_REG, 17)}, {this.decode("rol", this.Mode.ADDR_E, 15, this.Mode.ADDR_REG, 17), this.decode("ror", this.Mode.ADDR_E, 15, this.Mode.ADDR_REG, 17), this.decode("rcl", this.Mode.ADDR_E, 15, this.Mode.ADDR_REG, 17), this.decode("rcr", this.Mode.ADDR_E, 15, this.Mode.ADDR_REG, 17), this.decode("shl", this.Mode.ADDR_E, 15, this.Mode.ADDR_REG, 17), this.decode("shr", this.Mode.ADDR_E, 15, this.Mode.ADDR_REG, 17), null, this.decode("sar", this.Mode.ADDR_E, 15, this.Mode.ADDR_REG, 17)}, {this.decode("test", this.Mode.ADDR_E, 2, this.Mode.ADDR_I, 2), null, this.decode("not", this.Mode.ADDR_E, 2), this.decode("neg", this.Mode.ADDR_E, 2), this.decode("mul", this.Mode.ADDR_REG, 16, this.Mode.ADDR_E, 2), this.decode("imul", this.Mode.ADDR_REG, 16, this.Mode.ADDR_E, 2), this.decode("div", this.Mode.ADDR_REG, 16, this.Mode.ADDR_E, 2), this.decode("idiv", this.Mode.ADDR_REG, 16, this.Mode.ADDR_E, 2)}, {this.decode("test", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 15), null, this.decode("not", this.Mode.ADDR_E, 15), this.decode("neg", this.Mode.ADDR_E, 15), this.decode("mul", this.Mode.ADDR_REG, 0, this.Mode.ADDR_E, 15), this.decode("imul", this.Mode.ADDR_REG, 0, this.Mode.ADDR_E, 15), this.decode("div", this.Mode.ADDR_REG, 0, this.Mode.ADDR_E, 15), this.decode("idiv", this.Mode.ADDR_REG, 0, this.Mode.ADDR_E, 15)}, {this.decode("inc", this.Mode.ADDR_E, 2), this.decode("dec", this.Mode.ADDR_E, 2), null, null, null, null, null, null}, {this.decode("inc", this.Mode.ADDR_E, 15), this.decode("dec", this.Mode.ADDR_E, 15), this.decode("call", this.Mode.ADDR_E, 10), this.decode("call", this.Mode.ADDR_E, 6), this.decode("jmp", this.Mode.ADDR_E, 10), this.decode("jmp", this.Mode.ADDR_E, 6), this.decode("push", this.Mode.ADDR_E, 15), null}, {this.decode("sldt", this.Mode.ADDR_E, 16), this.decode("str", this.Mode.ADDR_E, 16), this.decode("lldt", this.Mode.ADDR_E, 16), this.decode("ltr", this.Mode.ADDR_E, 16), this.decode("verr", this.Mode.ADDR_E, 16), this.decode("verw", this.Mode.ADDR_E, 16), null, null}, {this.decode("sgdt", this.Mode.ADDR_E, 16), this.decode("sidt", this.Mode.ADDR_E, 16), this.decode("lgdt", this.Mode.ADDR_E, 16), this.decode("lidt", this.Mode.ADDR_E, 16), this.decode("smsw", this.Mode.ADDR_E, 16), null, this.decode("lmsw", this.Mode.ADDR_E, 16), this.decode("invlpg", this.Mode.ADDR_E, 16)}, {null, null, null, null, this.decode("btS", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("btsS", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("btrS", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2), this.decode("btcS", this.Mode.ADDR_E, 15, this.Mode.ADDR_I, 2)}, {null, this.decode("cmpxch8b", this.Mode.ADDR_W, 10), null, null, null, null, null, null}, {null, null, this.decode("psrlw", this.Mode.ADDR_P, 10, this.Mode.ADDR_I, 2), null, this.decode("psraw", this.Mode.ADDR_P, 10, this.Mode.ADDR_I, 2), null, this.decode("psllw", this.Mode.ADDR_P, 10, this.Mode.ADDR_I, 2), null}, {null, null, this.decode("psrld", this.Mode.ADDR_P, 10, this.Mode.ADDR_I, 2), null, this.decode("psrad", this.Mode.ADDR_P, 10, this.Mode.ADDR_I, 2), null, this.decode("pslld", this.Mode.ADDR_P, 10, this.Mode.ADDR_I, 2), null}, {null, null, this.decode("psrlq", this.Mode.ADDR_P, 10, this.Mode.ADDR_I, 2), null, null, null, this.decode("psllq", this.Mode.ADDR_P, 10, this.Mode.ADDR_I, 2), null}, {this.decode("fxsave", this.Mode.ADDR_M, 15), this.decode("fxrstor", this.Mode.ADDR_M, 15), this.decode("ldmxcsr"), this.decode("stmxcsr"), this.decode("xsave", this.Mode.ADDR_M, 15), this.decode("xrstor", this.Mode.ADDR_M, 15), null, this.decode("clflush")}, {this.decode("prefetchnta", this.Mode.ADDR_M, 15), this.decode("prefetcht0"), this.decode("prefetcht1"), this.decode("prefetcht2"), null, null, null, null}, {null, null, this.decode("psrlw", this.Mode.ADDR_P, 5, this.Mode.ADDR_I, 2), null, this.decode("psraw", this.Mode.ADDR_P, 5, this.Mode.ADDR_I, 2), null, this.decode("psllw", this.Mode.ADDR_P, 5, this.Mode.ADDR_I, 2), null}, {null, null, this.decode("psrld", this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2), null, this.decode("psrad", this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2), null, this.decode("pslld", this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2), null}, {null, null, this.decode("psrlq", this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2), this.decode("psrldq", this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2), null, null, this.decode("psllq", this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2), this.decode("psllq", this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2)}};
    }

    private X86InstructionDecoder[][] create0F01OpcodeGroupTable() {
        return new X86InstructionDecoder[][]{{null, this.decode("vmcall"), this.decode("vmlaunch"), this.decode("vmresume"), this.decode("vmxoff"), null, null, null}, {this.decode("monitor"), this.decode("mwait"), null, null, null, null, null, null}, {this.decode("xgetbv"), this.decode("xsetbv"), null, null, null, null, null, null}, {this.decode("vmrun"), this.decode("vmmcall"), this.decode("vmload"), this.decode("vmsave"), this.decode("stgi"), this.decode("clgi"), this.decode("skinit"), this.decode("invlpga")}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {this.decode("swapgs"), this.decode("rdtscp"), null, null, null, null, null, null}};
    }

    private X86InstructionDecoder[][] create0FAEOpcodeGroupTable() {
        return new X86InstructionDecoder[][]{{null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {this.decode("lfence"), this.decode("lfence"), this.decode("lfence"), this.decode("lfence"), this.decode("lfence"), this.decode("lfence"), this.decode("lfence"), this.decode("lfence")}, {this.decode("mfence"), this.decode("mfence"), this.decode("mfence"), this.decode("mfence"), this.decode("mfence"), this.decode("mfence"), this.decode("mfence"), this.decode("mfence")}, {this.decode("sfence"), this.decode("sfence"), this.decode("sfence"), this.decode("sfence"), this.decode("sfence"), this.decode("sfence"), this.decode("sfence"), this.decode("sfence")}};
    }

    private X86InstructionDecoder[][] createFloatOpcodeTableOne() {
        return new X86InstructionDecoder[][]{{this.decode("fadd", this.Mode.ADDR_E, 15), this.decode("fmul", this.Mode.ADDR_E, 15), this.decode("fcom", this.Mode.ADDR_E, 15), this.decode("fcomp", this.Mode.ADDR_E, 15), this.decode("fsub", this.Mode.ADDR_E, 15), this.decode("fsubr", this.Mode.ADDR_E, 15), this.decode("fdiv", this.Mode.ADDR_E, 15), this.decode("fdivr", this.Mode.ADDR_E, 15)}, {this.decode("fld", this.Mode.ADDR_E, 15), null, this.decode("fst", this.Mode.ADDR_E, 15), this.decode("fstp", this.Mode.ADDR_E, 15), this.decode("fldenv", this.Mode.ADDR_E, 15), this.decode("fldcw", this.Mode.ADDR_E, 15), this.decode("fNstenv", this.Mode.ADDR_E, 15), this.decode("fNstcw", this.Mode.ADDR_E, 15)}, {this.decode("fiadd", this.Mode.ADDR_E, 15), this.decode("fimul", this.Mode.ADDR_E, 15), this.decode("ficom", this.Mode.ADDR_E, 15), this.decode("ficomp", this.Mode.ADDR_E, 15), this.decode("fisub", this.Mode.ADDR_E, 15), this.decode("fisubr", this.Mode.ADDR_E, 15), this.decode("fidiv", this.Mode.ADDR_E, 15), this.decode("fidivr", this.Mode.ADDR_E, 15)}, {this.decode("fild", this.Mode.ADDR_E, 15), null, this.decode("fist", this.Mode.ADDR_E, 15), this.decode("fistp", this.Mode.ADDR_E, 15), null, this.decode("fld", this.Mode.ADDR_E, 15), null, this.decode("fstpt", this.Mode.ADDR_E, 15)}, {this.decode("fadd", this.Mode.ADDR_E, 15), this.decode("fmul", this.Mode.ADDR_E, 15), this.decode("fcom", this.Mode.ADDR_E, 15), this.decode("fcomp", this.Mode.ADDR_E, 15), this.decode("fsub", this.Mode.ADDR_E, 15), this.decode("fsubr", this.Mode.ADDR_E, 15), this.decode("fdiv", this.Mode.ADDR_E, 15), this.decode("fdivr", this.Mode.ADDR_E, 15)}, {this.decode("fld", this.Mode.ADDR_E, 15), null, this.decode("fst", this.Mode.ADDR_E, 15), this.decode("fstp", this.Mode.ADDR_E, 15), this.decode("frstor", this.Mode.ADDR_E, 15), null, this.decode("fNsave", this.Mode.ADDR_E, 15), this.decode("fNstsw", this.Mode.ADDR_E, 15)}, {this.decode("fiadd", this.Mode.ADDR_E, 15), this.decode("fimul", this.Mode.ADDR_E, 15), this.decode("ficom", this.Mode.ADDR_E, 15), this.decode("ficomp", this.Mode.ADDR_E, 15), this.decode("fisub", this.Mode.ADDR_E, 15), this.decode("fisubr", this.Mode.ADDR_E, 15), this.decode("fidiv", this.Mode.ADDR_E, 15), this.decode("fidivr", this.Mode.ADDR_E, 15)}, {this.decode("fild", this.Mode.ADDR_E, 15), null, this.decode("fist", this.Mode.ADDR_E, 15), this.decode("fistp", this.Mode.ADDR_E, 15), this.decode("fbld", this.Mode.ADDR_E, 15), this.decode("fild", this.Mode.ADDR_E, 15), this.decode("fbstp", this.Mode.ADDR_E, 15), this.decode("fistp", this.Mode.ADDR_E, 15)}};
    }

    private X86InstructionDecoder[][] createFloatOpcodeTableTwo() {
        return new X86InstructionDecoder[][]{{this.decode("fadd", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), this.decode("fmul", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), this.decode("fcom", this.Mode.ADDR_FREG, 1), this.decode("fcomp", this.Mode.ADDR_FREG, 1), this.decode("fsub", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), this.decode("fsubr", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), this.decode("fdiv", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), this.decode("fdivr", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1)}, {this.decode("fld", this.Mode.ADDR_FREG, 1), this.decode("fxch", this.Mode.ADDR_FREG, 1), this.decodeFloatGroup(0), null, this.decodeFloatGroup(1), this.decodeFloatGroup(2), this.decodeFloatGroup(3), this.decodeFloatGroup(4)}, {this.decode("fcmovb", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), this.decode("fcmove", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), this.decode("fcmovbe", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), this.decode("fcmovu", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), null, this.decodeFloatGroup(5), null, null}, {this.decode("fcmovnb", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), this.decode("fcmovne", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), this.decode("fcmovnbe", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), this.decode("fcmovnu", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), this.decodeFloatGroup(6), this.decode("fucomi", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), this.decode("fcomi", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), null}, {this.decode("fadd", this.Mode.ADDR_FREG, 1, this.Mode.ADDR_FREG, 0), this.decode("fmul", this.Mode.ADDR_FREG, 1, this.Mode.ADDR_FREG, 0), null, null, this.decode("fsub", this.Mode.ADDR_FREG, 1, this.Mode.ADDR_FREG, 0), this.decode("fsubr", this.Mode.ADDR_FREG, 1, this.Mode.ADDR_FREG, 0), this.decode("fdiv", this.Mode.ADDR_FREG, 1, this.Mode.ADDR_FREG, 0), this.decode("fdivr", this.Mode.ADDR_FREG, 1, this.Mode.ADDR_FREG, 0)}, {this.decode("ffree", this.Mode.ADDR_FREG, 1), null, this.decode("fst", this.Mode.ADDR_FREG, 1), this.decode("fstp", this.Mode.ADDR_FREG, 1), this.decode("fucom", this.Mode.ADDR_FREG, 1), this.decode("fucomp", this.Mode.ADDR_FREG, 1), null, null}, {this.decode("faddp", this.Mode.ADDR_FREG, 1, this.Mode.ADDR_FREG, 0), this.decode("fmulp", this.Mode.ADDR_FREG, 1, this.Mode.ADDR_FREG, 0), null, this.decodeFloatGroup(7), this.decode("fsubrp", this.Mode.ADDR_FREG, 1, this.Mode.ADDR_FREG, 0), this.decode("fsubp", this.Mode.ADDR_FREG, 1, this.Mode.ADDR_FREG, 0), this.decode("fdivrp", this.Mode.ADDR_FREG, 1, this.Mode.ADDR_FREG, 0), this.decode("fdivp", this.Mode.ADDR_FREG, 1, this.Mode.ADDR_FREG, 0)}, {this.decode("ffreep", this.Mode.ADDR_FREG, 1), null, this.decode("fst", this.Mode.ADDR_FREG, 1), this.decode("fstp", this.Mode.ADDR_FREG, 1), this.decodeFloatGroup(7), this.decode("fucomip", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), this.decode("fcomip", this.Mode.ADDR_FREG, 0, this.Mode.ADDR_FREG, 1), null}};
    }

    private X86InstructionDecoder[] createThreeByteOpcodeTable() {
        X86InstructionDecoder[] decoders = new X86InstructionDecoder[255];
        decoders[0] = this.decode("pshufb", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10);
        decoders[15] = this.decode("palignr", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10, this.Mode.ADDR_I, 2);
        decoders[240] = this.decode("movbe", this.Mode.ADDR_G, 15, this.Mode.ADDR_M, 15);
        decoders[241] = this.decode("movbe", this.Mode.ADDR_M, 15, this.Mode.ADDR_G, 15);
        return decoders;
    }

    private X86InstructionDecoder[] createThreeByteOpcodePrefix66Table() {
        X86InstructionDecoder[] decoders = new X86InstructionDecoder[255];
        decoders[0] = this.decode("pshufb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[1] = this.decode("phaddw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[2] = this.decode("phaddd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[3] = this.decode("phaddsw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[4] = this.decode("pmaddubsw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[5] = this.decode("phsubw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[6] = this.decode("phsubd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[7] = this.decode("phsubsw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[8] = this.decode("psignb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[9] = this.decode("psignw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[10] = this.decode("psignd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[11] = this.decode("pmulhrsw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[16] = this.decode("pblendvb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[20] = this.decode("blendvps", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[21] = this.decode("blendvpd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[23] = this.decode("ptest", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[28] = this.decode("pabsb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[29] = this.decode("pabsw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[30] = this.decode("pabsd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[32] = this.decode("pmovsxbw", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[33] = this.decode("pmovsxbd", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[34] = this.decode("pmovsxbq", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[35] = this.decode("pmovsxwd", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[36] = this.decode("pmovsxwq", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[37] = this.decode("pmovsxdq", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[40] = this.decode("pmuldq", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[41] = this.decode("pcmpeqq", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[42] = this.decode("movntdqa", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[43] = this.decode("packusdw", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[48] = this.decode("pmovzxbw", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[49] = this.decode("pmovzxbd", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[50] = this.decode("pmovzxbq", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[51] = this.decode("pmovzxwd", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[52] = this.decode("pmovzxwq", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[53] = this.decode("pmovzxdq", this.Mode.ADDR_V, 5, this.Mode.ADDR_U, 5);
        decoders[55] = this.decode("pcmpgtq", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[56] = this.decode("pminsb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[57] = this.decode("pminsd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[58] = this.decode("pminuw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[59] = this.decode("pminud", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[60] = this.decode("pmaxsb", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[61] = this.decode("pmaxsd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[62] = this.decode("pmaxuw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[63] = this.decode("pmaxud", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[64] = this.decode("pmulld", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[65] = this.decode("phminposuw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[219] = this.decode("aesimc", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[220] = this.decode("aesenc", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[221] = this.decode("aesenclast", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[222] = this.decode("aesdec", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        decoders[223] = this.decode("aesdeclast", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5);
        return decoders;
    }

    private X86InstructionDecoder[] createThreeByteOpcodePrefixF2Table() {
        X86InstructionDecoder[] decoders = new X86InstructionDecoder[255];
        decoders[240] = this.decode("crc32", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 2);
        decoders[241] = this.decode("crc32", this.Mode.ADDR_G, 15, this.Mode.ADDR_E, 15);
        return decoders;
    }

    private static X86InstructionDecoder[] createThreeByteOpcodePrefixF3Table() {
        X86InstructionDecoder[] decoders = new X86InstructionDecoder[255];
        return decoders;
    }

    private X86InstructionDecoder[] createThreeByteOpcode3ATable() {
        X86InstructionDecoder[] decoders = new X86InstructionDecoder[255];
        decoders[15] = this.decode("palignr", this.Mode.ADDR_P, 10, this.Mode.ADDR_Q, 10, this.Mode.ADDR_I, 2);
        return decoders;
    }

    private X86InstructionDecoder[] createThreeByteOpcode3APrefix66Table() {
        X86InstructionDecoder[] decoders = new X86InstructionDecoder[255];
        decoders[8] = this.decode("roundps", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2);
        decoders[9] = this.decode("roundpd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2);
        decoders[10] = this.decode("roundss", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2);
        decoders[11] = this.decode("roundsd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2);
        decoders[12] = this.decode("blendps", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2);
        decoders[13] = this.decode("blendpd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2);
        decoders[14] = this.decode("pblendw", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2);
        decoders[15] = this.decode("palignr", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2);
        decoders[20] = this.decode("pextrb", this.Mode.ADDR_R, 4, this.Mode.ADDR_V, 5, this.Mode.ADDR_I, 2);
        decoders[22] = this.decode("pextrd", this.Mode.ADDR_R, 4, this.Mode.ADDR_V, 5, this.Mode.ADDR_I, 2);
        decoders[23] = this.decode("extractps", this.Mode.ADDR_R, 4, this.Mode.ADDR_V, 5, this.Mode.ADDR_I, 2);
        decoders[32] = this.decode("pinsrb", this.Mode.ADDR_V, 5, this.Mode.ADDR_R, 4, this.Mode.ADDR_I, 2);
        decoders[33] = this.decode("insertps", this.Mode.ADDR_V, 5, this.Mode.ADDR_R, 4, this.Mode.ADDR_I, 2);
        decoders[64] = this.decode("dpps", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2);
        decoders[65] = this.decode("dppd", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2);
        decoders[66] = this.decode("mpsadbw", this.Mode.ADDR_V, 5, this.Mode.ADDR_I, 2);
        decoders[68] = this.decode("pclmulqdq", this.Mode.ADDR_V, 5, this.Mode.ADDR_I, 2);
        decoders[96] = this.decode("pcmpestrm", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2);
        decoders[97] = this.decode("pcmpestri", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2);
        decoders[98] = this.decode("pcmpistrm", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2);
        decoders[99] = this.decode("pcmpistri", this.Mode.ADDR_V, 5, this.Mode.ADDR_W, 5, this.Mode.ADDR_I, 2);
        decoders[223] = this.decode("aeskeygenassist", this.Mode.ADDR_V, 5, this.Mode.ADDR_I, 2);
        return decoders;
    }
}

