/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.DecodeCtx;
import bindis.DecodeStream;
import bindis.x86.common.X86ModRM;
import bindis.x86.common.X86Prefixes;
import rreil.disassembler.OpcodeFormatter;

public final class X86DecodeCtx
extends DecodeCtx {
    private final X86Prefixes prefixes;
    private X86ModRM ModRM = null;

    public X86DecodeCtx(DecodeStream decodeStream, X86Prefixes prefixes, long startPc) {
        super(decodeStream, startPc);
        this.prefixes = prefixes;
    }

    public X86Prefixes getPrefixes() {
        return this.prefixes;
    }

    public X86ModRM getModRM() {
        if (this.ModRM == null) {
            this.ModRM = X86ModRM.decode(this.getDecodeStream());
        }
        return this.ModRM;
    }

    @Override
    public String toErrorString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{pc: 0x").append(Long.toHexString(this.getStartPc()));
        builder.append(", consumed-bytes: <");
        OpcodeFormatter.format(this.slice(), builder);
        builder.append('>');
        builder.append(", prefixes: ").append(this.prefixes).append('}');
        return builder.toString();
    }
}

