/*
 * Decompiled with CFR 0.152.
 */
package bindis.x86.common;

import bindis.x86.common.X86RegOpnd;

public class X86DebugRegisters {
    public static final int NUM_MMX_REGISTERS = 8;
    public static final X86RegOpnd DR0 = new X86RegOpnd("dr0", 32);
    public static final X86RegOpnd DR1 = new X86RegOpnd("dr1", 32);
    public static final X86RegOpnd DR2 = new X86RegOpnd("dr2", 32);
    public static final X86RegOpnd DR3 = new X86RegOpnd("dr3", 32);
    public static final X86RegOpnd DR4 = new X86RegOpnd("dr4", 32);
    public static final X86RegOpnd DR5 = new X86RegOpnd("dr5", 32);
    public static final X86RegOpnd DR6 = new X86RegOpnd("dr6", 32);
    public static final X86RegOpnd DR7 = new X86RegOpnd("dr7", 32);
    private static X86RegOpnd[] controlRegisters = new X86RegOpnd[]{DR0, DR1, DR2, DR3, DR4, DR5, DR6, DR7};

    public static int getNumberOfRegisters() {
        return 8;
    }

    public static String getRegisterName(int regNum) {
        assert (regNum > -1 && regNum < 8) : "invalid debug register number";
        return controlRegisters[regNum].toString();
    }

    public static X86RegOpnd getRegister(int regNum) {
        assert (regNum > -1 && regNum < 8) : "invalid debug register number";
        return controlRegisters[regNum];
    }
}

