/*
 * Decompiled with CFR 0.152.
 */
package bindis.avr8;

import bindis.OperandKind;
import bindis.avr8.AVRImmOpnd;
import bindis.avr8.AVROpnd;
import bindis.avr8.AVRRegOpnd;
import bindis.avr8.AVRRegisterAlterationType;
import bindis.avr8.OpndVisitor;

public class AVRMemOpnd
extends AVROpnd {
    private final AVRRegOpnd memReg;
    private final AVRRegisterAlterationType altType;
    private final AVRImmOpnd displacement;

    public AVRRegOpnd getMemReg() {
        return this.memReg;
    }

    public AVRRegisterAlterationType getAltType() {
        return this.altType;
    }

    public AVRImmOpnd getDisplacement() {
        return this.displacement;
    }

    public AVRMemOpnd(AVRRegOpnd memReg) {
        this(memReg, AVRRegisterAlterationType.None);
    }

    public AVRMemOpnd(AVRRegOpnd memReg, AVRRegisterAlterationType altType) {
        this(memReg, altType, null);
    }

    public AVRMemOpnd(AVRImmOpnd displacement) {
        this(null, AVRRegisterAlterationType.None, displacement);
    }

    public AVRMemOpnd(AVRRegOpnd memReg, AVRRegisterAlterationType altType, AVRImmOpnd displacement) {
        super(8, OperandKind.MEM);
        if (memReg == null && displacement == null) {
            throw new RuntimeException("Either memory register or displacement has to be specified.");
        }
        this.memReg = memReg;
        this.altType = altType;
        this.displacement = displacement;
    }

    public int ptrSize() {
        if (this.memReg != null) {
            return this.memReg.size();
        }
        if (this.displacement != null) {
            return this.displacement.size();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, T> R accept(OpndVisitor<R, T> visitor, T data) {
        return visitor.visit(this, data);
    }

    @Override
    public StringBuilder asString(StringBuilder buf) {
        StringBuilder sb = buf.append("[");
        if (this.memReg != null) {
            if (this.altType == AVRRegisterAlterationType.PreDecrement) {
                sb.append("-");
            }
            sb.append(this.memReg.toString());
            if (this.altType == AVRRegisterAlterationType.PostIncrement) {
                sb.append("+");
            }
            if (this.displacement != null) {
                sb.append(" + " + this.displacement);
            }
        } else {
            sb.append(this.displacement.toString());
        }
        sb.append("]");
        return sb;
    }
}

