/*
 * Decompiled with CFR 0.152.
 */
package bindead.exceptions;

import bindead.data.NumVar;
import rreil.lang.Rhs;

public abstract class DomainStateException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public DomainStateException(String message) {
        super(message);
    }

    public static class VariableSupportSetException
    extends DomainStateException {
        private static final long serialVersionUID = 1L;

        public VariableSupportSetException() {
            this("Inconsistent variable support set detected");
        }

        public VariableSupportSetException(Rhs.Rval variable) {
            this("Unkown variable " + variable);
        }

        public VariableSupportSetException(NumVar variable) {
            this("Unkown variable " + variable);
        }

        public VariableSupportSetException(Rhs.Lin target) {
            this("Some unkown variable " + target);
        }

        public VariableSupportSetException(String string) {
            super(string);
        }
    }

    public static class InvariantViolationException
    extends DomainStateException {
        private static final long serialVersionUID = 1L;

        public InvariantViolationException() {
            this("");
        }

        public InvariantViolationException(String message) {
            super("Invariant violated: " + message);
        }
    }

    public static class UnimplementedMethodException
    extends DomainStateException {
        private static final long serialVersionUID = 1L;

        public UnimplementedMethodException() {
            super("Unimplemented method");
        }

        public UnimplementedMethodException(String what) {
            super("Unimplemented method: " + what);
        }
    }
}

