/*
 * Decompiled with CFR 0.152.
 */
package bindead.environment.platform;

import bindead.analyses.Bootstrap;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.platform.Platform;
import bindis.DecodeException;
import bindis.DecodeStream;
import bindis.Disassembler;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import rreil.disassembler.Instruction;
import rreil.disassembler.translators.common.TranslationException;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.RReilHighLevelToLowLevelWrapper;
import rreil.lang.util.RvarExtractor;

public class RReilPlatform
extends Platform {
    private static final String stackPointerName = "sp";
    private static final String instructionPointerName = "ip";
    private final MemVar initialStackRegionId;
    private final Map<String, Rhs.Rvar> knownRegisters = new HashMap<String, Rhs.Rvar>();

    private RReilPlatform(int defaultSize, Disassembler dis) {
        super(dis);
        this.initialStackRegionId = MemVar.getVarOrFresh("stack.rreil_" + defaultSize);
    }

    public RReilPlatform(int defaultSize, final SortedMap<RReilAddr, RReil> instructions) {
        this(defaultSize, new Disassembler("rreil-vm", defaultSize, null, ByteOrder.LITTLE_ENDIAN){

            @Override
            public Instruction decodeOne(DecodeStream in, long pc) throws DecodeException {
                RReilAddr nativeAddress = RReilAddr.valueOf(pc);
                RReil firstInstruction = (RReil)instructions.get(nativeAddress);
                if (firstInstruction == null) {
                    throw new IllegalArgumentException("No instruction at that address: " + pc);
                }
                LinkedList<RReil> allIntraRReilInstructions = new LinkedList<RReil>();
                allIntraRReilInstructions.add(firstInstruction);
                int size = 1;
                SortedMap successorInstructions = instructions.tailMap(nativeAddress.nextOffset());
                while (!successorInstructions.isEmpty()) {
                    RReilAddr nextAddress = successorInstructions.firstKey();
                    if (nextAddress.offset() == 0) {
                        size = (int)(nextAddress.base() - nativeAddress.base());
                        break;
                    }
                    RReil nextInstruction = (RReil)successorInstructions.get(nextAddress);
                    allIntraRReilInstructions.add(nextInstruction);
                    successorInstructions = successorInstructions.tailMap(nextAddress.nextOffset());
                }
                return new InstructionWrapper(size, allIntraRReilInstructions);
            }

            @Override
            public LowLevelRReilOpnd translateIdentifier(String name) throws TranslationException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public String getArchitectureName() {
                return "rreil-vm";
            }
        });
        this.extractRegisterMapping(instructions);
    }

    private void extractRegisterMapping(SortedMap<RReilAddr, RReil> instructions) {
        for (RReil insn : instructions.values()) {
            for (Rhs.Rvar variable : RvarExtractor.getUnique(insn)) {
                String name = variable.getRegionId().getName();
                if (this.knownRegisters.containsKey(name)) {
                    Rhs.Rvar currentlyKnownVariable = this.knownRegisters.get(name);
                    if (currentlyKnownVariable.getSize() < variable.getSize()) {
                        this.knownRegisters.put(name, variable);
                        continue;
                    }
                    if (currentlyKnownVariable.getOffset() == 0 || variable.getOffset() != 0) continue;
                    this.knownRegisters.put(name, variable);
                    continue;
                }
                this.knownRegisters.put(name, variable);
            }
        }
    }

    @Override
    public Rhs.Rvar getRegisterAsVariable(String name) {
        return this.knownRegisters.get(name);
    }

    @Override
    public Bootstrap forwardAnalysisBootstrap() {
        return new Bootstrap(){

            @Override
            public <D extends RootDomain<D>> D bootstrap(D state, long initialPC) {
                state = (RootDomain)state.introduceRegion(MemVar.getVarOrFresh("stack"), RegionCtx.EMPTYSTICKY);
                state = RReilPlatform.this.initializeStackPointer(state);
                state = RReilPlatform.this.initializeInstructionPointer(state, initialPC);
                return state;
            }
        };
    }

    @Override
    public String getStackPointer() {
        return stackPointerName;
    }

    @Override
    public String getInstructionPointer() {
        return instructionPointerName;
    }

    @Override
    @Deprecated
    public MemVar getStackRegion() {
        return this.initialStackRegionId;
    }

    private static class InstructionWrapper
    extends Instruction {
        private final int length;
        private final List<RReil> instructions;

        protected InstructionWrapper(int length, List<RReil> instructions) {
            super(instructions.get(0).getRReilAddress(), LowLevelRReil.oneSizeOpcode, instructions.toString(), new LowLevelRReilOpnd[0]);
            this.length = length;
            this.instructions = instructions;
        }

        @Override
        public List<LowLevelRReil> toRReilInstructions() throws TranslationException {
            LinkedList<LowLevelRReil> insns = new LinkedList<LowLevelRReil>();
            for (RReil instruction : this.instructions) {
                insns.add(new RReilHighLevelToLowLevelWrapper(instruction));
            }
            return insns;
        }

        @Override
        public int length() {
            return this.length;
        }
    }
}

