/*
 * Decompiled with CFR 0.152.
 */
package bindead.environment.platform;

import bindead.analyses.algorithms.AnalysisProperties;
import bindead.environment.platform.GdslX86_32Platform;
import bindead.environment.platform.GdslX86_64Platform;
import bindead.environment.platform.LegacyX86_32Platform;
import bindead.environment.platform.LegacyX86_64Platform;
import bindead.environment.platform.Platform;
import bindead.environment.platform.RReilPlatform;
import binparse.Binary;
import binparse.rreil.RReilBinary;
import java.util.HashMap;
import java.util.Map;

public class PlatformsRegistry {
    private static Map<String, Platform> legacyMap = new HashMap<String, Platform>();
    private static Map<String, Platform> gdslMap = new HashMap<String, Platform>();

    public static Platform get(Binary file) {
        Platform platform = null;
        if (file.getArchitectureName().equals("rreil-vm")) {
            platform = new RReilPlatform(file.getArchitectureSize(), ((RReilBinary)file).getInstructions());
        } else if (AnalysisProperties.INSTANCE.useGDSLDisassembler.isTrue().booleanValue()) {
            if (gdslMap.isEmpty()) {
                throw new IllegalStateException("GDSL requested as disassembler frontend but no GDSL frontends found in library path or could not load/initialize any.");
            }
            platform = gdslMap.get(file.getArchitectureName());
        } else {
            platform = legacyMap.get(file.getArchitectureName());
        }
        if (platform == null) {
            throw new IllegalArgumentException("Could not instantiate a platform for " + file.getArchitectureName() + "for the binay: " + file.getFileName());
        }
        return platform;
    }

    static {
        legacyMap.put("x86-32", LegacyX86_32Platform.instance());
        legacyMap.put("x86-64", LegacyX86_64Platform.instance());
        try {
            gdslMap.put("x86-32", GdslX86_32Platform.instance());
            gdslMap.put("x86-64", GdslX86_64Platform.instance());
        }
        catch (Exception | UnsatisfiedLinkError throwable) {
            // empty catch block
        }
    }
}

