/*
 * Decompiled with CFR 0.152.
 */
package bindead.environment.platform;

import bindead.analyses.Bootstrap;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.platform.LegacyX86_32Platform;
import bindead.environment.platform.Platform;
import bindis.x86.x64.X64Disassembler;
import rreil.lang.MemVar;

public class LegacyX86_64Platform
extends Platform {
    private static Platform INSTANCE;
    private static final String stackPointerName = "rsp";
    private static final String instructionPointerName = "rip";

    public LegacyX86_64Platform() {
        super(X64Disassembler.INSTANCE);
    }

    public static Platform instance() {
        if (INSTANCE == null) {
            INSTANCE = new LegacyX86_64Platform();
        }
        return INSTANCE;
    }

    @Override
    public Bootstrap forwardAnalysisBootstrap() {
        return new Bootstrap(){

            @Override
            public <D extends RootDomain<D>> D bootstrap(D state, long initialPC) {
                state = (RootDomain)state.introduceRegion(MemVar.getVarOrFresh("stack"), RegionCtx.EMPTYSTICKY);
                state = LegacyX86_64Platform.this.initializeStackPointer(state);
                state = LegacyX86_32Platform.initializeFlags(state);
                state = LegacyX86_64Platform.this.initializeInstructionPointer(state, initialPC);
                return state;
            }
        };
    }

    @Override
    public String getStackPointer() {
        return stackPointerName;
    }

    @Override
    public String getInstructionPointer() {
        return instructionPointerName;
    }

    @Override
    public MemVar getStackRegion() {
        return MemVar.getVarOrFresh("stack.x86_64");
    }
}

