/*
 * Decompiled with CFR 0.152.
 */
package bindead.environment.platform;

import bindead.analyses.Bootstrap;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.platform.Platform;
import bindis.x86.x32.X32Disassembler;
import rreil.lang.MemVar;

public class LegacyX86_32Platform
extends Platform {
    private static Platform INSTANCE;
    private static final String stackPointerName = "esp";
    private static final String instructionPointerName = "eip";

    private LegacyX86_32Platform() {
        super(X32Disassembler.INSTANCE);
    }

    public static Platform instance() {
        if (INSTANCE == null) {
            INSTANCE = new LegacyX86_32Platform();
        }
        return INSTANCE;
    }

    @Override
    public Bootstrap forwardAnalysisBootstrap() {
        return new Bootstrap(){

            @Override
            public <D extends RootDomain<D>> D bootstrap(D state, long initialPC) {
                state = (RootDomain)state.introduceRegion(MemVar.getVarOrFresh("stack"), RegionCtx.EMPTYSTICKY);
                state = LegacyX86_32Platform.this.initializeStackPointer(state);
                state = LegacyX86_32Platform.initializeFlags(state);
                state = LegacyX86_32Platform.this.initializeInstructionPointer(state, initialPC);
                return state;
            }
        };
    }

    static <D extends RootDomain<D>> D initializeFlags(D state) {
        state = (RootDomain)state.eval(String.format("mov.%d %s, 0", 1, "DF"));
        return state;
    }

    @Override
    public String getStackPointer() {
        return stackPointerName;
    }

    @Override
    public String getInstructionPointer() {
        return instructionPointerName;
    }

    @Override
    @Deprecated
    public MemVar getStackRegion() {
        return MemVar.getVarOrFresh("stack.x86_32");
    }
}

