/*
 * Decompiled with CFR 0.152.
 */
package bindead.environment.platform;

import bindead.analyses.Bootstrap;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.platform.GdslX86_32Platform;
import bindead.environment.platform.Platform;
import bindis.Disassembler;
import bindis.gdsl.GdslX86_64Disassembler;
import java.util.HashMap;
import java.util.Map;
import rreil.gdsl.builder.IdBuilder;
import rreil.lang.MemVar;

public class GdslX86_64Platform
extends Platform {
    private static Platform INSTANCE;
    private static final String stackPointerName = "rsp";
    private static final String instructionPointerName = "rip";
    private static Map<String, String> renamings;

    private GdslX86_64Platform() {
        super(GdslX86_64Disassembler.instance);
    }

    public static Platform instance() {
        if (INSTANCE == null) {
            INSTANCE = new GdslX86_64Platform();
        }
        return INSTANCE;
    }

    @Override
    public Disassembler getDisassembler() {
        IdBuilder.setRenamings(renamings);
        return super.getDisassembler();
    }

    @Override
    public Bootstrap forwardAnalysisBootstrap() {
        return new Bootstrap(){

            @Override
            public <D extends RootDomain<D>> D bootstrap(D state, long initialPC) {
                state = (RootDomain)state.introduceRegion(MemVar.getVarOrFresh("stack"), RegionCtx.EMPTYSTICKY);
                state = GdslX86_64Platform.this.initializeStackPointer(state);
                state = GdslX86_32Platform.initializeSegmentRegisters(state);
                state = GdslX86_32Platform.initializeFlags(state);
                state = GdslX86_64Platform.this.initializeInstructionPointer(state, initialPC);
                return state;
            }
        };
    }

    @Override
    public String getStackPointer() {
        return stackPointerName;
    }

    @Override
    public String getInstructionPointer() {
        return instructionPointerName;
    }

    @Override
    @Deprecated
    public MemVar getStackRegion() {
        return MemVar.getVarOrFresh("stack.x86_64");
    }

    static {
        renamings = new HashMap<String, String>(){
            {
                this.put("virt_leu", "BE");
                this.put("virt_lts", "LT");
                this.put("virt_les", "LE");
                this.put("a", "rax");
                this.put("b", "rbx");
                this.put("c", "rcx");
                this.put("d", "rdx");
                this.put("si", "rsi");
                this.put("di", "rdi");
                this.put("bp", "rbp");
                this.put("sp", GdslX86_64Platform.stackPointerName);
                this.put("ip", GdslX86_64Platform.instructionPointerName);
            }
        };
    }
}

