/*
 * Decompiled with CFR 0.152.
 */
package bindead.environment.platform;

import bindead.analyses.Bootstrap;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.platform.Platform;
import bindis.Disassembler;
import bindis.gdsl.GdslX86_32Disassembler;
import java.util.HashMap;
import java.util.Map;
import rreil.gdsl.builder.IdBuilder;
import rreil.lang.MemVar;

public class GdslX86_32Platform
extends Platform {
    private static Platform INSTANCE;
    private static final String stackPointerName = "esp";
    private static final String instructionPointerName = "eip";
    private static Map<String, String> renamings;

    private GdslX86_32Platform() {
        super(GdslX86_32Disassembler.instance);
    }

    public static Platform instance() {
        if (INSTANCE == null) {
            INSTANCE = new GdslX86_32Platform();
        }
        return INSTANCE;
    }

    @Override
    public Disassembler getDisassembler() {
        IdBuilder.setRenamings(renamings);
        return super.getDisassembler();
    }

    @Override
    public Bootstrap forwardAnalysisBootstrap() {
        return new Bootstrap(){

            @Override
            public <D extends RootDomain<D>> D bootstrap(D state, long initialPC) {
                state = (RootDomain)state.introduceRegion(MemVar.getVarOrFresh("stack"), RegionCtx.EMPTYSTICKY);
                state = GdslX86_32Platform.this.initializeStackPointer(state);
                state = GdslX86_32Platform.initializeSegmentRegisters(state);
                state = GdslX86_32Platform.initializeFlags(state);
                state = GdslX86_32Platform.this.initializeInstructionPointer(state, initialPC);
                return state;
            }
        };
    }

    static <D extends RootDomain<D>> D initializeSegmentRegisters(D state) {
        String[] segPrefixes;
        for (String segPrefix : segPrefixes = new String[]{"e", "d", "s", "f", "g", "c"}) {
            state = (RootDomain)state.eval(String.format("mov.%d %s, 0", 64, segPrefix + "s_base"));
        }
        return state;
    }

    static <D extends RootDomain<D>> D initializeFlags(D state) {
        state = (RootDomain)state.eval(String.format("mov.%d %s, 0", 1, "flags/10"));
        return state;
    }

    @Override
    public String getStackPointer() {
        return stackPointerName;
    }

    @Override
    public String getInstructionPointer() {
        return instructionPointerName;
    }

    @Override
    @Deprecated
    public MemVar getStackRegion() {
        return MemVar.getVarOrFresh("stack.x86_32");
    }

    static {
        renamings = new HashMap<String, String>(){
            {
                this.put("virt_leu", "BE");
                this.put("virt_lts", "LT");
                this.put("virt_les", "LE");
                this.put("a", "eax");
                this.put("b", "ebx");
                this.put("c", "ecx");
                this.put("d", "edx");
                this.put("si", "esi");
                this.put("di", "edi");
                this.put("bp", "ebp");
                this.put("sp", GdslX86_32Platform.stackPointerName);
                this.put("ip", GdslX86_32Platform.instructionPointerName);
            }
        };
    }
}

